/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.interpreter.expr;

import com.alibaba.fastsql.interpreter.InterpreterContext;
import com.alibaba.fastsql.interpreter.expr.Expr;
import com.alibaba.fastsql.interpreter.expr.LongExpr;
import java.math.BigDecimal;

public class FieldLong
extends LongExpr
implements Expr<Long> {
    private final String field;

    public FieldLong(String field) {
        this.field = field;
    }

    @Override
    public Long eval(InterpreterContext context) {
        Object fieldValue = context.getFieldValue(this.field);
        if (fieldValue instanceof Long) {
            return (Long)fieldValue;
        }
        if (fieldValue instanceof BigDecimal) {
            return ((BigDecimal)fieldValue).longValueExact();
        }
        if (fieldValue instanceof Number) {
            return ((Number)fieldValue).longValue();
        }
        return null;
    }
}

