/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.interpreter.filters;

import com.alibaba.fastsql.interpreter.filters.BinaryOp;
import com.alibaba.fastsql.interpreter.filters.ConstFilter;
import com.alibaba.fastsql.interpreter.filters.FieldValueProvider;

public class IntFilter
implements ConstFilter<Integer> {
    protected final int value;
    protected final BinaryOp operator;
    protected final FieldValueProvider fieldValueProvider;

    public IntFilter(int value, BinaryOp operator, FieldValueProvider fieldValueProvider) {
        this.value = value;
        this.operator = operator;
        this.fieldValueProvider = fieldValueProvider;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public Object getFieldValue(Object object) throws Exception {
        return this.fieldValueProvider.getFieldValue(object);
    }

    @Override
    public boolean test(Object o) throws Exception {
        Object fieldValue = this.getFieldValue(o);
        if (fieldValue instanceof Integer || fieldValue instanceof Short || fieldValue instanceof Byte) {
            int intVal = ((Number)fieldValue).intValue();
            switch (this.operator) {
                case Eq: {
                    return intVal == this.value;
                }
                case Ne: {
                    return intVal != this.value;
                }
                case Ge: {
                    return intVal >= this.value;
                }
                case Gt: {
                    return intVal > this.value;
                }
                case Le: {
                    return intVal <= this.value;
                }
                case Lt: {
                    return intVal < this.value;
                }
            }
            throw new UnsupportedOperationException();
        }
        if (fieldValue instanceof Long) {
            long longValue = (Long)fieldValue;
            switch (this.operator) {
                case Eq: {
                    return longValue == (long)this.value;
                }
                case Ne: {
                    return longValue != (long)this.value;
                }
                case Ge: {
                    return longValue >= (long)this.value;
                }
                case Gt: {
                    return longValue > (long)this.value;
                }
                case Le: {
                    return longValue <= (long)this.value;
                }
                case Lt: {
                    return longValue < (long)this.value;
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }
}

