/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.HashMap;

public final class SQLLimit
extends SQLObjectImpl
implements SQLReplaceable {
    private SQLExpr rowCount;
    private SQLExpr offset;

    public SQLLimit() {
    }

    public SQLLimit(int rowCount) {
        this.setRowCount(new SQLIntegerExpr(rowCount));
    }

    public SQLLimit(SQLExpr rowCount) {
        this.setRowCount(rowCount);
    }

    public SQLLimit(SQLExpr offset, SQLExpr rowCount) {
        this.setOffset(offset);
        this.setRowCount(rowCount);
    }

    public SQLExpr getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(SQLExpr rowCount) {
        if (rowCount != null) {
            rowCount.setParent(this);
        }
        this.rowCount = rowCount;
    }

    public void setRowCount(int rowCount) {
        this.setRowCount(new SQLIntegerExpr(rowCount));
    }

    public SQLExpr getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.setOffset(new SQLIntegerExpr(offset));
    }

    public void setOffset(SQLExpr offset) {
        if (offset != null) {
            offset.setParent(this);
        }
        this.offset = offset;
    }

    public void merge(SQLLimit limit) {
        if (limit == null) {
            return;
        }
        if (limit.offset != null && this.offset == null) {
            this.offset = limit.offset.clone();
        }
        if (limit.rowCount != null && this.rowCount == null) {
            this.rowCount = limit.rowCount.clone();
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.offset != null) {
                this.offset.accept(visitor);
            }
            if (this.rowCount != null) {
                this.rowCount.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public SQLLimit clone() {
        SQLLimit x = new SQLLimit();
        if (this.offset != null) {
            x.setOffset(this.offset.clone());
        }
        if (this.rowCount != null) {
            x.setRowCount(this.rowCount.clone());
        }
        if (this.attributes != null) {
            x.attributes = (HashMap)((HashMap)this.attributes).clone();
        }
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.rowCount == expr) {
            this.setRowCount(target);
            return true;
        }
        if (this.offset == expr) {
            this.setOffset(target);
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLLimit limit = (SQLLimit)o;
        if (this.rowCount != null ? !this.rowCount.equals(limit.rowCount) : limit.rowCount != null) {
            return false;
        }
        return this.offset != null ? this.offset.equals(limit.offset) : limit.offset == null;
    }

    public int hashCode() {
        int result = this.rowCount != null ? this.rowCount.hashCode() : 0;
        result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
        return result;
    }
}

