/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.statement;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLReplaceable;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertInto;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLInsertStatement
extends SQLInsertInto
implements SQLStatement {
    protected SQLWithSubqueryClause with;
    protected boolean upsert = false;

    public void cloneTo(SQLInsertStatement x) {
        super.cloneTo(x);
        x.dbType = this.dbType;
        x.upsert = this.upsert;
        x.afterSemi = this.afterSemi;
        if (this.with != null) {
            x.setWith(this.with.clone());
        }
    }

    @Override
    public SQLInsertStatement clone() {
        SQLInsertStatement x = new SQLInsertStatement();
        this.cloneTo(x);
        return x;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tableSource);
            this.acceptChild(visitor, this.columns);
            this.acceptChild(visitor, this.valuesList);
            this.acceptChild(visitor, this.query);
        }
        visitor.endVisit(this);
    }

    @Override
    public List<SQLObject> getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        children.add(this.tableSource);
        children.addAll(this.columns);
        children.addAll(this.valuesList);
        if (this.query != null) {
            children.add(this.query);
        }
        return children;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public void setUpsert(boolean upsert) {
        this.upsert = upsert;
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }

    @Override
    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    @Override
    public boolean isAfterSemi() {
        return this.afterSemi;
    }

    @Override
    public void setAfterSemi(boolean afterSemi) {
        this.afterSemi = afterSemi;
    }

    public SQLWithSubqueryClause getWith() {
        return this.with;
    }

    public void setWith(SQLWithSubqueryClause with) {
        if (with != null) {
            with.setParent(this);
        }
        this.with = with;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, this.dbType);
    }

    public static class ValuesClause
    extends SQLObjectImpl
    implements SQLReplaceable {
        private final List values;
        private transient String originalString;
        private transient int replaceCount;

        public ValuesClause() {
            this(new ArrayList<SQLExpr>());
        }

        @Override
        public ValuesClause clone() {
            ValuesClause x = new ValuesClause(new ArrayList<SQLExpr>(this.values.size()));
            for (Object v : this.values) {
                x.addValue(v);
            }
            return x;
        }

        @Override
        public boolean replace(SQLExpr expr, SQLExpr target) {
            for (int i = 0; i < this.values.size(); ++i) {
                if (this.values.get(i) != expr) continue;
                target.setParent(this);
                this.values.set(i, target);
                return true;
            }
            return false;
        }

        public ValuesClause(List<SQLExpr> values) {
            this.values = values;
            for (int i = 0; i < values.size(); ++i) {
                values.get(i).setParent(this);
            }
        }

        public ValuesClause(List values, SQLObject parent) {
            this.values = values;
            for (int i = 0; i < values.size(); ++i) {
                Object val = values.get(i);
                if (!(val instanceof SQLObject)) continue;
                ((SQLObject)val).setParent(this);
            }
            this.parent = parent;
        }

        public void addValue(Object value) {
            if (value instanceof SQLObject) {
                ((SQLObject)value).setParent(this);
            }
            this.values.add(value);
        }

        public void addValue(SQLExpr value) {
            value.setParent(this);
            this.values.add(value);
        }

        public List<SQLExpr> getValues() {
            return this.values;
        }

        @Override
        protected void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                for (int i = 0; i < this.values.size(); ++i) {
                    Object item = this.values.get(i);
                    if (!(item instanceof SQLObject)) continue;
                    SQLObject value = (SQLObject)item;
                    value.accept(visitor);
                }
            }
            visitor.endVisit(this);
        }

        public String getOriginalString() {
            return this.originalString;
        }

        public void setOriginalString(String originalString) {
            this.originalString = originalString;
        }

        public int getReplaceCount() {
            return this.replaceCount;
        }

        public void incrementReplaceCount() {
            ++this.replaceCount;
        }
    }
}

