/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.ast.statement;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLDbTypedObject;
import com.alibaba.fastsql.sql.ast.SQLLimit;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionOperator;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SQLUnionQuery
extends SQLObjectImpl
implements SQLSelectQuery,
SQLDbTypedObject {
    private boolean bracket = false;
    private SQLSelectQuery left;
    private SQLSelectQuery right;
    private SQLUnionOperator operator = SQLUnionOperator.UNION;
    private SQLOrderBy orderBy;
    private SQLLimit limit;
    private DbType dbType;

    public SQLUnionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SQLUnionOperator operator) {
        this.operator = operator;
    }

    public SQLUnionQuery() {
    }

    public SQLUnionQuery(SQLSelectQuery left, SQLUnionOperator operator, SQLSelectQuery right) {
        this.setLeft(left);
        this.operator = operator;
        this.setRight(right);
    }

    public SQLSelectQuery getLeft() {
        return this.left;
    }

    public void setLeft(SQLSelectQuery left) {
        if (left != null) {
            left.setParent(this);
        }
        this.left = left;
    }

    public SQLSelectQuery getRight() {
        return this.right;
    }

    public void setRight(SQLSelectQuery right) {
        if (right != null) {
            right.setParent(this);
        }
        this.right = right;
    }

    public SQLOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(SQLOrderBy orderBy) {
        if (orderBy != null) {
            orderBy.setParent(this);
        }
        this.orderBy = orderBy;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.left != null) {
                this.left.accept(visitor);
            }
            if (this.right != null) {
                this.right.accept(visitor);
            }
            if (this.orderBy != null) {
                this.orderBy.accept(visitor);
            }
            if (this.limit != null) {
                this.limit.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public SQLLimit getLimit() {
        return this.limit;
    }

    public void setLimit(SQLLimit limit) {
        if (limit != null) {
            limit.setParent(this);
        }
        this.limit = limit;
    }

    @Override
    public boolean isBracket() {
        return this.bracket;
    }

    @Override
    public void setBracket(boolean bracket) {
        this.bracket = bracket;
    }

    @Override
    public SQLUnionQuery clone() {
        SQLUnionQuery x = new SQLUnionQuery();
        x.bracket = this.bracket;
        if (this.left != null) {
            x.setLeft(this.left.clone());
        }
        if (this.right != null) {
            x.setRight(this.right.clone());
        }
        x.operator = this.operator;
        if (this.orderBy != null) {
            x.setOrderBy(this.orderBy.clone());
        }
        if (this.limit != null) {
            x.setLimit(this.limit.clone());
        }
        x.dbType = this.dbType;
        return x;
    }

    public SQLSelectQueryBlock getFirstQueryBlock() {
        if (this.left instanceof SQLSelectQueryBlock) {
            return (SQLSelectQueryBlock)this.left;
        }
        if (this.left instanceof SQLUnionQuery) {
            return ((SQLUnionQuery)this.left).getFirstQueryBlock();
        }
        return null;
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public boolean replace(SQLSelectQuery cmp, SQLSelectQuery target) {
        if (cmp == this.left) {
            this.setLeft(target);
            return true;
        }
        if (cmp == this.right) {
            this.setRight(target);
            return true;
        }
        return false;
    }

    public List<SQLSelectQuery> getChildren() {
        boolean bracket;
        boolean bl = bracket = this.bracket && !(this.parent instanceof SQLUnionQueryTableSource);
        if (!bracket && this.left instanceof SQLUnionQuery && ((SQLUnionQuery)this.left).getOperator() == this.operator && !this.right.isBracket() && this.orderBy == null) {
            SQLSelectQuery leftRight;
            SQLSelectQuery leftLeft;
            SQLUnionQuery leftUnion = (SQLUnionQuery)this.left;
            ArrayList<SQLSelectQuery> rights = new ArrayList<SQLSelectQuery>();
            rights.add(this.right);
            while (true) {
                leftLeft = leftUnion.getLeft();
                leftRight = leftUnion.getRight();
                if (leftUnion.isBracket() || leftUnion.getOrderBy() != null || leftLeft.isBracket() || leftRight.isBracket() || !(leftLeft instanceof SQLUnionQuery) || ((SQLUnionQuery)leftLeft).getOperator() != this.operator) break;
                rights.add(leftRight);
                leftUnion = (SQLUnionQuery)leftLeft;
            }
            rights.add(leftRight);
            rights.add(leftLeft);
            Collections.reverse(rights);
            return rights;
        }
        return Arrays.asList(this.left, this.right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLUnionQuery that = (SQLUnionQuery)o;
        if (this.bracket != that.bracket) {
            return false;
        }
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.right != null ? !this.right.equals(that.right) : that.right != null) {
            return false;
        }
        if (this.operator != that.operator) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        return this.dbType == that.dbType;
    }

    public int hashCode() {
        int result = this.bracket ? 1 : 0;
        result = 31 * result + (this.left != null ? this.left.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.dbType != null ? this.dbType.hashCode() : 0);
        return result;
    }
}

