/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.db2.visitor;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLPartitionBy;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.fastsql.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.db2.ast.stmt.DB2CreateTableStatement;
import com.alibaba.fastsql.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.db2.ast.stmt.DB2ValuesStatement;
import com.alibaba.fastsql.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTOutputVisitor;

public class DB2OutputVisitor
extends SQLASTOutputVisitor
implements DB2ASTVisitor {
    public DB2OutputVisitor(Appendable appender) {
        super(appender, DbType.db2);
    }

    public DB2OutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = DbType.db2;
    }

    @Override
    public boolean visit(DB2SelectQueryBlock x) {
        this.visit((SQLSelectQueryBlock)x);
        if (x.isForReadOnly()) {
            this.println();
            this.print0(this.ucase ? "FOR READ ONLY" : "for read only");
        }
        if (x.getIsolation() != null) {
            this.println();
            this.print0(this.ucase ? "WITH " : "with ");
            this.print0(x.getIsolation().name());
        }
        if (x.getOptimizeFor() != null) {
            this.println();
            this.print0(this.ucase ? "OPTIMIZE FOR " : "optimize for ");
            x.getOptimizeFor().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(DB2SelectQueryBlock x) {
    }

    @Override
    public boolean visit(DB2ValuesStatement x) {
        this.print0(this.ucase ? "VALUES " : "values ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(DB2ValuesStatement x) {
    }

    @Override
    public boolean visit(DB2CreateTableStatement x) {
        Boolean compress;
        SQLPartitionBy partitionBy;
        SQLName validproc;
        SQLName database;
        SQLName indexIn;
        this.printCreateTable(x, true);
        if (x.isDataCaptureNone()) {
            this.println();
            this.print("DATA CAPTURE NONE");
        } else if (x.isDataCaptureChanges()) {
            this.println();
            this.print("DATA CAPTURE CHANGES");
        }
        SQLName tablespace = x.getTablespace();
        if (tablespace != null) {
            this.println();
            this.print("IN ");
            tablespace.accept(this);
        }
        if ((indexIn = x.getIndexIn()) != null) {
            this.println();
            this.print("INDEX IN ");
            indexIn.accept(this);
        }
        if ((database = x.getDatabase()) != null) {
            this.println();
            this.print("IN DATABASE ");
            database.accept(this);
        }
        if ((validproc = x.getValidproc()) != null) {
            this.println();
            this.print("VALIDPROC ");
            validproc.accept(this);
        }
        if ((partitionBy = x.getPartitioning()) != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            partitionBy.accept(this);
        }
        if ((compress = x.getCompress()) != null) {
            this.println();
            if (compress.booleanValue()) {
                this.print0(this.ucase ? "COMPRESS YES" : "compress yes");
            } else {
                this.print0(this.ucase ? "COMPRESS NO" : "compress no");
            }
        }
        return false;
    }

    @Override
    public void endVisit(DB2CreateTableStatement x) {
    }

    @Override
    protected void printOperator(SQLBinaryOperator operator) {
        if (operator == SQLBinaryOperator.Concat) {
            this.print0(this.ucase ? "CONCAT" : "concat");
        } else {
            this.print0(this.ucase ? operator.name : operator.name_lcase);
        }
    }

    @Override
    public boolean visit(SQLIntervalExpr x) {
        SQLExpr value = x.getValue();
        value.accept(this);
        SQLIntervalUnit unit = x.getUnit();
        if (unit != null) {
            this.print(' ');
            this.print0(this.ucase ? unit.name : unit.name_lcase);
            this.print(this.ucase ? (char)'S' : 's');
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition.Identity x) {
        this.print0(this.ucase ? "GENERATED ALWAYS AS IDENTITY" : "generated always as identity");
        Integer seed = x.getSeed();
        Integer increment = x.getIncrement();
        Integer minValue = x.getMinValue();
        Integer maxValue = x.getMaxValue();
        if (seed != null || increment != null || x.isCycle() || minValue != null || maxValue != null) {
            this.print0(" (");
        }
        if (seed != null) {
            this.print0(this.ucase ? "START WITH " : "start with ");
            this.print(seed);
        }
        if (increment != null) {
            if (seed != null) {
                this.print0(", ");
            }
            this.print0(this.ucase ? "INCREMENT BY " : "increment by ");
            this.print(increment);
        }
        if (x.isCycle()) {
            if (seed != null || increment != null) {
                this.print0(", ");
            }
            this.print0(this.ucase ? "CYCLE" : "cycle");
        }
        if (minValue != null) {
            if (seed != null || increment != null || x.isCycle()) {
                this.print0(", ");
            }
            this.print0(this.ucase ? "MINVALUE " : "minvalue ");
            this.print(minValue);
        }
        if (maxValue != null) {
            if (seed != null || increment != null || x.isCycle() || minValue != null) {
                this.print0(", ");
            }
            this.print0(this.ucase ? "MAXVALUE " : "maxvalue ");
            this.print(maxValue);
        }
        if (seed != null || increment != null || x.isCycle() || minValue != null || maxValue != null) {
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        this.print0(this.ucase ? "ADD COLUMNS " : "add columns ");
        this.printAndAccept(x.getColumns(), ", ");
        return false;
    }
}

