/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.mysql.ast.statement;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLIndex;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.SQLObjectImpl;
import com.alibaba.fastsql.sql.ast.SQLPartitionBy;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLConstraintImpl;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlObject;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class MySqlTableIndex
extends SQLConstraintImpl
implements SQLTableElement,
SQLIndex,
MySqlObject {
    private SQLName name;
    private String indexType;
    private List<SQLSelectOrderByItem> columns = new ArrayList<SQLSelectOrderByItem>();
    protected final List<SQLAssignItem> options = new ArrayList<SQLAssignItem>();
    private SQLExpr comment;
    private SQLPartitionBy dbPartitionBy;
    private SQLExpr tablePartitions;
    private SQLExpr tablePartitionBy;
    private boolean global;
    private boolean local;
    private List<SQLName> covering = new ArrayList<SQLName>();
    private SQLName analyzerName;
    private SQLName indexAnalyzerName;
    private SQLName queryAnalyzerName;

    @Override
    public SQLName getName() {
        return this.name;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    @Override
    public void setName(SQLName name) {
        this.name = name;
    }

    @Override
    public List<SQLSelectOrderByItem> getColumns() {
        return this.columns;
    }

    public void addColumn(SQLSelectOrderByItem column) {
        if (column != null) {
            column.setParent(this);
        }
        this.columns.add(column);
    }

    @Override
    public void accept0(SQLASTVisitor visitor) {
        this.accept0((MySqlASTVisitor)visitor);
    }

    @Override
    public void accept0(MySqlASTVisitor visitor) {
        if (visitor.visit(this)) {
            SQLObject item;
            int i;
            if (this.name != null) {
                this.name.accept(visitor);
            }
            for (i = 0; i < this.columns.size(); ++i) {
                item = this.columns.get(i);
                if (item == null) continue;
                ((SQLObjectImpl)item).accept(visitor);
            }
            for (i = 0; i < this.covering.size(); ++i) {
                item = this.covering.get(i);
                if (item == null) continue;
                item.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public MySqlTableIndex clone() {
        SQLExpr item2;
        MySqlTableIndex x = new MySqlTableIndex();
        if (this.name != null) {
            x.setName(this.name.clone());
        }
        x.indexType = this.indexType;
        for (SQLSelectOrderByItem sQLSelectOrderByItem : this.columns) {
            SQLSelectOrderByItem c2 = sQLSelectOrderByItem.clone();
            c2.setParent(x);
            x.columns.add(c2);
        }
        for (SQLAssignItem sQLAssignItem : this.options) {
            item2 = sQLAssignItem.clone();
            ((SQLObjectImpl)((Object)item2)).setParent(sQLAssignItem);
            x.options.add((SQLAssignItem)item2);
        }
        for (SQLName sQLName : this.covering) {
            item2 = sQLName.clone();
            item2.setParent(sQLName);
            x.covering.add((SQLName)item2);
        }
        if (null != this.dbPartitionBy) {
            x.setDbPartitionBy(this.dbPartitionBy.clone());
        }
        if (null != this.tablePartitionBy) {
            x.setTablePartitionBy(this.tablePartitionBy.clone());
        }
        if (null != this.tablePartitions) {
            x.setTablePartitions(this.tablePartitions.clone());
        }
        return x;
    }

    public boolean applyColumnRename(SQLName columnName, SQLName to) {
        for (SQLSelectOrderByItem orderByItem : this.columns) {
            SQLExpr expr = orderByItem.getExpr();
            if (!(expr instanceof SQLName) || !SQLUtils.nameEquals((SQLName)expr, columnName)) continue;
            orderByItem.setExpr(to.clone());
            return true;
        }
        return false;
    }

    public boolean applyDropColumn(SQLName columnName) {
        for (int i = this.columns.size() - 1; i >= 0; --i) {
            SQLExpr expr = this.columns.get(i).getExpr();
            if (expr instanceof SQLName && SQLUtils.nameEquals((SQLName)expr, columnName)) {
                this.columns.remove(i);
                return true;
            }
            if (!(expr instanceof SQLMethodInvokeExpr) || !SQLUtils.nameEquals(((SQLMethodInvokeExpr)expr).getMethodName(), columnName.getSimpleName())) continue;
            this.columns.remove(i);
            return true;
        }
        return false;
    }

    public void addOption(String name, SQLExpr value) {
        SQLAssignItem assignItem = new SQLAssignItem(new SQLIdentifierExpr(name), value);
        assignItem.setParent(this);
        this.options.add(assignItem);
    }

    public SQLExpr getOption(String name) {
        if (name == null) {
            return null;
        }
        return this.getOption(FnvHash.hashCode64(name));
    }

    protected SQLExpr getOption(long hash64) {
        for (SQLAssignItem item : this.options) {
            SQLExpr target = item.getTarget();
            if (!(target instanceof SQLIdentifierExpr) || ((SQLIdentifierExpr)target).hashCode64() != hash64) continue;
            return item.getValue();
        }
        return null;
    }

    public String getDistanceMeasure() {
        SQLExpr expr = this.getOption(FnvHash.Constants.DISTANCEMEASURE);
        if (expr == null) {
            return null;
        }
        return expr.toString();
    }

    public String getAlgorithm() {
        SQLExpr expr = this.getOption(FnvHash.Constants.ALGORITHM);
        if (expr == null) {
            return null;
        }
        return expr.toString();
    }

    public List<SQLAssignItem> getOptions() {
        return this.options;
    }

    @Override
    public SQLExpr getComment() {
        return this.comment;
    }

    @Override
    public void setComment(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.comment = x;
    }

    public SQLPartitionBy getDbPartitionBy() {
        return this.dbPartitionBy;
    }

    public void setDbPartitionBy(SQLPartitionBy x) {
        if (x != null) {
            x.setParent(this);
        }
        this.dbPartitionBy = x;
    }

    public SQLExpr getTablePartitions() {
        return this.tablePartitions;
    }

    public void setTablePartitions(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.tablePartitions = x;
    }

    public SQLExpr getTablePartitionBy() {
        return this.tablePartitionBy;
    }

    public void setTablePartitionBy(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.tablePartitionBy = x;
    }

    public void setCovering(List<SQLName> covering) {
        this.covering = covering;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    @Override
    public List<SQLName> getCovering() {
        return this.covering;
    }

    public SQLName getIndexAnalyzerName() {
        return this.indexAnalyzerName;
    }

    public void setIndexAnalyzerName(SQLName indexAnalyzerName) {
        this.indexAnalyzerName = indexAnalyzerName;
    }

    public SQLName getQueryAnalyzerName() {
        return this.queryAnalyzerName;
    }

    public void setQueryAnalyzerName(SQLName queryAnalyzerName) {
        this.queryAnalyzerName = queryAnalyzerName;
    }

    public SQLName getAnalyzerName() {
        return this.analyzerName;
    }

    public void setAnalyzerName(SQLName analyzerName) {
        this.analyzerName = analyzerName;
    }
}

