/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.dialect.mysql.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLAnnIndex;
import com.alibaba.fastsql.sql.ast.SQLCurrentTimeExpr;
import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLDataTypeImpl;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLOrderBy;
import com.alibaba.fastsql.sql.ast.SQLOrderingSpecification;
import com.alibaba.fastsql.sql.ast.SQLPartition;
import com.alibaba.fastsql.sql.ast.SQLPartitionValue;
import com.alibaba.fastsql.sql.ast.SQLSubPartition;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLArrayExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLExtractExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLHexExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntervalUnit;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLQueryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLAssignItem;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLValuesQuery;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.fastsql.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.fastsql.sql.dialect.mysql.ast.expr.MySqlCharExpr;
import com.alibaba.fastsql.sql.dialect.mysql.ast.expr.MySqlOrderingExpr;
import com.alibaba.fastsql.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.fastsql.sql.dialect.mysql.ast.expr.MySqlUserName;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.ParserException;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLSelectParser;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.util.FnvHash;
import java.util.Arrays;
import java.util.List;

public class MySqlExprParser
extends SQLExprParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;

    public MySqlExprParser(Lexer lexer) {
        super(lexer, DbType.mysql);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    public MySqlExprParser(String sql) {
        this(new MySqlLexer(sql));
        this.lexer.nextToken();
    }

    public MySqlExprParser(String sql, SQLParserFeature ... features) {
        super(new MySqlLexer(sql, features), DbType.mysql);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
        if (sql.length() > 6) {
            char c0 = sql.charAt(0);
            char c1 = sql.charAt(1);
            char c2 = sql.charAt(2);
            char c3 = sql.charAt(3);
            char c4 = sql.charAt(4);
            char c5 = sql.charAt(5);
            char c6 = sql.charAt(6);
            if (c0 == 'S' && c1 == 'E' && c2 == 'L' && c3 == 'E' && c4 == 'C' && c5 == 'T' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.SELECT);
                return;
            }
            if (c0 == 's' && c1 == 'e' && c2 == 'l' && c3 == 'e' && c4 == 'c' && c5 == 't' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.SELECT);
                return;
            }
            if (c0 == 'I' && c1 == 'N' && c2 == 'S' && c3 == 'E' && c4 == 'R' && c5 == 'T' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.INSERT);
                return;
            }
            if (c0 == 'i' && c1 == 'n' && c2 == 's' && c3 == 'e' && c4 == 'r' && c5 == 't' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.INSERT);
                return;
            }
            if (c0 == 'U' && c1 == 'P' && c2 == 'D' && c3 == 'A' && c4 == 'T' && c5 == 'E' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.UPDATE);
                return;
            }
            if (c0 == 'u' && c1 == 'p' && c2 == 'd' && c3 == 'a' && c4 == 't' && c5 == 'e' && c6 == ' ') {
                this.lexer.reset(6, ' ', Token.UPDATE);
                return;
            }
            if (c0 == '/' && c1 == '*' && this.isEnabled(SQLParserFeature.OptimizedForParameterized) && !this.isEnabled(SQLParserFeature.TDDLHint)) {
                MySqlLexer mySqlLexer = (MySqlLexer)this.lexer;
                mySqlLexer.skipFirstHintsOrMultiCommentAndNextToken();
                return;
            }
        }
        this.lexer.nextToken();
    }

    public MySqlExprParser(String sql, boolean keepComments) {
        this(new MySqlLexer(sql, true, keepComments));
        this.lexer.nextToken();
    }

    public MySqlExprParser(String sql, boolean skipComment, boolean keepComments) {
        this(new MySqlLexer(sql, skipComment, keepComments));
        this.lexer.nextToken();
    }

    @Override
    public SQLExpr primary() {
        Token tok = this.lexer.token();
        switch (tok) {
            case IDENTIFIER: {
                long hash_lower = this.lexer.hash_lower();
                if (hash_lower == FnvHash.Constants.OUTLINE) {
                    this.lexer.nextToken();
                    SQLExpr file = this.primary();
                    MySqlOutFileExpr expr = new MySqlOutFileExpr(file);
                    return this.primaryRest(expr);
                }
                String strVal = this.lexer.stringVal();
                boolean quoteStart = strVal.length() > 0 && (strVal.charAt(0) == '`' || strVal.charAt(0) == '\"');
                SQLCurrentTimeExpr currentTimeExpr = null;
                if (hash_lower == FnvHash.Constants.CURRENT_TIME && !quoteStart) {
                    currentTimeExpr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.CURRENT_TIME);
                } else if (hash_lower == FnvHash.Constants.CURRENT_TIMESTAMP && !quoteStart) {
                    currentTimeExpr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.CURRENT_TIMESTAMP);
                } else if (hash_lower == FnvHash.Constants.CURRENT_DATE && !quoteStart) {
                    currentTimeExpr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.CURRENT_DATE);
                } else if (hash_lower == FnvHash.Constants.CURDATE && !quoteStart) {
                    currentTimeExpr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.CURDATE);
                } else if (hash_lower == FnvHash.Constants.LOCALTIME && !quoteStart) {
                    currentTimeExpr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.LOCALTIME);
                } else if (hash_lower == FnvHash.Constants.LOCALTIMESTAMP && !quoteStart) {
                    currentTimeExpr = new SQLCurrentTimeExpr(SQLCurrentTimeExpr.Type.LOCALTIMESTAMP);
                } else if (hash_lower == -5808529385363204345L && this.lexer.charAt(this.lexer.pos()) == '\'') {
                    this.lexer.nextToken();
                    SQLHexExpr hex = new SQLHexExpr(this.lexer.stringVal());
                    this.lexer.nextToken();
                    return this.primaryRest(hex);
                }
                if (currentTimeExpr != null) {
                    String methodName = this.lexer.stringVal();
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.LPAREN) {
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.LPAREN) {
                            this.lexer.nextToken();
                        } else {
                            return this.primaryRest(this.methodRest(new SQLIdentifierExpr(methodName), false));
                        }
                    }
                    return this.primaryRest(currentTimeExpr);
                }
                return super.primary();
            }
            case VARIANT: {
                SQLVariantRefExpr varRefExpr = new SQLVariantRefExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                if (varRefExpr.getName().equalsIgnoreCase("@@global")) {
                    this.accept(Token.DOT);
                    varRefExpr = new SQLVariantRefExpr(this.lexer.stringVal(), true);
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                }
                return this.primaryRest(varRefExpr);
            }
            case VALUES: {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LPAREN) {
                    SQLExpr expr = this.primary();
                    SQLValuesQuery values = new SQLValuesQuery();
                    values.addValue(new SQLListExpr(expr));
                    return new SQLQueryExpr(new SQLSelect(values));
                }
                return this.methodRest(new SQLIdentifierExpr("VALUES"), true);
            }
            case BINARY: {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COMMA || this.lexer.token() == Token.SEMI || this.lexer.token() == Token.EOF) {
                    return new SQLIdentifierExpr("BINARY");
                }
                SQLUnaryExpr binaryExpr = new SQLUnaryExpr(SQLUnaryOperator.BINARY, this.primary());
                return this.primaryRest(binaryExpr);
            }
        }
        return super.primary();
    }

    @Override
    public final SQLExpr primaryRest(SQLExpr expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr");
        }
        if (this.lexer.token() == Token.LITERAL_CHARS) {
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
                String ident = identExpr.getName();
                if (ident.equalsIgnoreCase("x")) {
                    char ch = this.lexer.charAt(this.lexer.pos());
                    if (ch == '\'') {
                        String charValue = this.lexer.stringVal();
                        this.lexer.nextToken();
                        expr = new SQLHexExpr(charValue);
                        return this.primaryRest(expr);
                    }
                } else if (ident.startsWith("_")) {
                    String charValue = this.lexer.stringVal();
                    this.lexer.nextToken();
                    MySqlCharExpr mysqlCharExpr = new MySqlCharExpr(charValue);
                    mysqlCharExpr.setCharset(identExpr.getName());
                    if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                        this.lexer.nextToken();
                        String collate = this.lexer.stringVal();
                        mysqlCharExpr.setCollate(collate);
                        if (this.lexer.token() == Token.LITERAL_CHARS) {
                            this.lexer.nextToken();
                        } else {
                            this.accept(Token.IDENTIFIER);
                        }
                    }
                    expr = mysqlCharExpr;
                    return this.primaryRest(expr);
                }
            } else if (expr instanceof SQLCharExpr) {
                String text2 = ((SQLCharExpr)expr).getText();
                do {
                    String chars = this.lexer.stringVal();
                    text2 = text2 + chars;
                    this.lexer.nextToken();
                } while (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS);
                expr = new SQLCharExpr(text2);
            } else if (expr instanceof SQLVariantRefExpr) {
                SQLMethodInvokeExpr concat = new SQLMethodInvokeExpr("CONCAT");
                concat.addArgument(expr);
                concat.addArgument(this.primary());
                expr = concat;
                return this.primaryRest(expr);
            }
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            if (expr instanceof SQLHexExpr) {
                if ("USING".equalsIgnoreCase(this.lexer.stringVal())) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.IDENTIFIER) {
                        throw new ParserException("syntax error, illegal hex. " + this.lexer.info());
                    }
                    String charSet = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr.getAttributes().put("USING", charSet);
                    return this.primaryRest(expr);
                }
            } else {
                if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.EQ) {
                        this.lexer.nextToken();
                    }
                    if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.LITERAL_CHARS) {
                        throw new ParserException("syntax error. " + this.lexer.info());
                    }
                    String collate = this.lexer.stringVal();
                    this.lexer.nextToken();
                    SQLBinaryOpExpr binaryExpr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.COLLATE, new SQLIdentifierExpr(collate), DbType.mysql);
                    expr = binaryExpr;
                    return this.primaryRest(expr);
                }
                if (expr instanceof SQLVariantRefExpr && this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.LITERAL_CHARS) {
                        throw new ParserException("syntax error. " + this.lexer.info());
                    }
                    String collate = this.lexer.stringVal();
                    this.lexer.nextToken();
                    expr.putAttribute("COLLATE", collate);
                    return this.primaryRest(expr);
                }
            }
        } else if (this.lexer.token() == Token.LBRACKET) {
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(expr);
            this.lexer.nextToken();
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        if (this.lexer.token() == Token.VARIANT) {
            String variant = this.lexer.stringVal();
            if ("@".equals(variant)) {
                return this.userNameRest(expr);
            }
            if ("@localhost".equals(variant)) {
                return this.userNameRest(expr);
            }
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        if (this.lexer.token() == Token.ERROR) {
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        return super.primaryRest(expr);
    }

    public SQLName userName() {
        SQLName name = this.name();
        if (this.lexer.token() == Token.LPAREN && name.hashCode64() == FnvHash.Constants.CURRENT_USER) {
            this.lexer.nextToken();
            this.accept(Token.RPAREN);
            return name;
        }
        return (SQLName)this.userNameRest(name);
    }

    private SQLExpr userNameRest(SQLExpr expr) {
        if (this.lexer.token() != Token.VARIANT || !this.lexer.stringVal().startsWith("@")) {
            return expr;
        }
        MySqlUserName userName = new MySqlUserName();
        if (expr instanceof SQLCharExpr) {
            userName.setUserName(((SQLCharExpr)expr).getText());
        } else {
            userName.setUserName(((SQLIdentifierExpr)expr).getName());
        }
        String strVal = this.lexer.stringVal();
        this.lexer.nextToken();
        if (strVal.length() > 1) {
            userName.setHost(strVal.substring(1));
            return userName;
        }
        if (this.lexer.token() == Token.LITERAL_CHARS) {
            userName.setHost(this.lexer.stringVal());
        } else {
            if (this.lexer.token() == Token.PERCENT) {
                throw new ParserException("syntax error. " + this.lexer.info());
            }
            userName.setHost(this.lexer.stringVal());
        }
        this.lexer.nextToken();
        if (this.lexer.identifierEquals(FnvHash.Constants.IDENTIFIED)) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BY) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.PASSWORD)) {
                    this.lexer.reset(mark);
                } else {
                    userName.setIdentifiedBy(this.lexer.stringVal());
                    this.lexer.nextToken();
                }
            } else {
                this.lexer.reset(mark);
            }
        }
        return userName;
    }

    @Override
    protected SQLExpr parsePosition() {
        SQLExpr expr = this.primary();
        expr = this.primaryRest(expr);
        expr = this.bitXorRest(expr);
        expr = this.additiveRest(expr);
        expr = this.shiftRest(expr);
        expr = this.bitAndRest(expr);
        expr = this.bitOrRest(expr);
        if (this.lexer.token() == Token.IN) {
            this.accept(Token.IN);
        } else if (this.lexer.token() == Token.COMMA) {
            this.accept(Token.COMMA);
        } else {
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        SQLExpr str = this.expr();
        this.accept(Token.RPAREN);
        SQLMethodInvokeExpr locate = new SQLMethodInvokeExpr("LOCATE");
        locate.addArgument(expr);
        locate.addArgument(str);
        return this.primaryRest(locate);
    }

    @Override
    protected SQLExpr parseExtract() {
        if (this.lexer.token() != Token.IDENTIFIER) {
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        String unitVal = this.lexer.stringVal();
        SQLIntervalUnit unit = SQLIntervalUnit.valueOf(unitVal.toUpperCase());
        this.lexer.nextToken();
        this.accept(Token.FROM);
        SQLExpr value = this.expr();
        SQLExtractExpr extract = new SQLExtractExpr();
        extract.setValue(value);
        extract.setUnit(unit);
        this.accept(Token.RPAREN);
        SQLExtractExpr expr = extract;
        return this.primaryRest(expr);
    }

    @Override
    public SQLSelectParser createSelectParser() {
        return new MySqlSelectParser(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SQLExpr parseInterval() {
        this.accept(Token.INTERVAL);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr("INTERVAL");
            if (this.lexer.token() != Token.RPAREN) {
                this.exprList(methodInvokeExpr.getArguments(), methodInvokeExpr);
            }
            this.accept(Token.RPAREN);
            if (methodInvokeExpr.getArguments().size() != 1 || this.lexer.token() != Token.IDENTIFIER) return this.primaryRest(methodInvokeExpr);
            SQLExpr value = methodInvokeExpr.getArguments().get(0);
            String unit = this.lexer.stringVal();
            this.lexer.nextToken();
            SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
            intervalExpr.setValue(value);
            intervalExpr.setUnit(SQLIntervalUnit.valueOf(unit.toUpperCase()));
            return intervalExpr;
        }
        SQLExpr value = this.expr();
        if (this.lexer.token() != Token.IDENTIFIER) {
            throw new ParserException("Syntax error. " + this.lexer.info());
        }
        SQLIntervalUnit intervalUnit = null;
        String unit = this.lexer.stringVal();
        long unitHash = this.lexer.hash_lower();
        this.lexer.nextToken();
        intervalUnit = SQLIntervalUnit.valueOf(unit.toUpperCase());
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            if (unitHash == FnvHash.Constants.YEAR) {
                if (!this.lexer.identifierEquals(FnvHash.Constants.MONTH)) throw new ParserException("Syntax error. " + this.lexer.info());
                this.lexer.nextToken();
                intervalUnit = SQLIntervalUnit.YEAR_MONTH;
            } else if (unitHash == FnvHash.Constants.DAY) {
                if (this.lexer.identifierEquals(FnvHash.Constants.HOUR)) {
                    this.lexer.nextToken();
                    intervalUnit = SQLIntervalUnit.DAY_HOUR;
                } else if (this.lexer.identifierEquals(FnvHash.Constants.MINUTE)) {
                    this.lexer.nextToken();
                    intervalUnit = SQLIntervalUnit.DAY_MINUTE;
                } else {
                    if (!this.lexer.identifierEquals(FnvHash.Constants.SECOND)) throw new ParserException("Syntax error. " + this.lexer.info());
                    this.lexer.nextToken();
                    intervalUnit = SQLIntervalUnit.DAY_SECOND;
                }
            } else if (unitHash == FnvHash.Constants.HOUR) {
                if (this.lexer.identifierEquals(FnvHash.Constants.MINUTE)) {
                    this.lexer.nextToken();
                    intervalUnit = SQLIntervalUnit.HOUR_MINUTE;
                } else {
                    if (!this.lexer.identifierEquals(FnvHash.Constants.SECOND)) throw new ParserException("Syntax error. " + this.lexer.info());
                    this.lexer.nextToken();
                    intervalUnit = SQLIntervalUnit.HOUR_SECOND;
                }
            } else {
                if (unitHash != FnvHash.Constants.MINUTE) throw new ParserException("Syntax error. " + this.lexer.info());
                if (!this.lexer.identifierEquals(FnvHash.Constants.SECOND)) throw new ParserException("Syntax error. " + this.lexer.info());
                this.lexer.nextToken();
                intervalUnit = SQLIntervalUnit.MINUTE_SECOND;
            }
        }
        SQLIntervalExpr intervalExpr = new SQLIntervalExpr();
        intervalExpr.setValue(value);
        intervalExpr.setUnit(intervalUnit);
        return intervalExpr;
    }

    @Override
    public SQLColumnDefinition parseColumn() {
        SQLColumnDefinition column = new SQLColumnDefinition();
        column.setDbType(this.dbType);
        SQLName name = this.name();
        column.setName(name);
        column.setDataType(this.parseDataType());
        if (this.lexer.identifierEquals(FnvHash.Constants.GENERATED)) {
            this.lexer.nextToken();
            this.acceptIdentifier("ALWAYS");
            this.accept(Token.AS);
            this.accept(Token.LPAREN);
            SQLExpr expr = this.expr();
            this.accept(Token.RPAREN);
            column.setGeneratedAlawsAs(expr);
        }
        return this.parseColumnRest(column);
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        SQLExpr expr;
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.accept(Token.UPDATE);
            expr = this.primary();
            column.setOnUpdate(expr);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ENCODE)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            column.setEncode(this.charExpr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.COMPRESSION)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            column.setCompression(this.charExpr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CHARACTER) || this.lexer.identifierEquals(FnvHash.Constants.CHARSET)) {
            if (this.lexer.identifierEquals(FnvHash.Constants.CHARACTER)) {
                this.lexer.nextToken();
                this.accept(Token.SET);
            } else {
                this.lexer.nextToken();
            }
            SQLExprImpl charSet = this.lexer.token() == Token.IDENTIFIER ? new SQLIdentifierExpr(this.lexer.stringVal()) : new SQLCharExpr(this.lexer.stringVal());
            this.lexer.nextToken();
            column.setCharsetExpr(charSet);
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals("disableindex")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.TRUE) {
                this.lexer.nextToken();
                column.setDisableIndex(true);
            }
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals("jsonIndexAttrs")) {
            this.lexer.nextToken();
            column.setJsonIndexAttrsExpr(new SQLIdentifierExpr(this.lexer.stringVal()));
            this.lexer.nextToken();
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals("precision")) {
            this.lexer.nextToken();
            int precision = this.parseIntValue();
            this.acceptIdentifier("scale");
            int scale = this.parseIntValue();
            List<SQLExpr> arguments = column.getDataType().getArguments();
            arguments.add(new SQLIntegerExpr(precision));
            arguments.add(new SQLIntegerExpr(scale));
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
            this.lexer.nextToken();
            SQLExprImpl collateExpr = this.lexer.token() == Token.IDENTIFIER ? new SQLIdentifierExpr(this.lexer.stringVal()) : new SQLCharExpr(this.lexer.stringVal());
            this.lexer.nextToken();
            column.setCollateExpr(collateExpr);
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PRECISION) && column.getDataType().nameHashCode64() == FnvHash.Constants.DOUBLE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.PARTITION) {
            throw new ParserException("syntax error " + this.lexer.info());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORAGE)) {
            this.lexer.nextToken();
            expr = this.expr();
            column.setStorage(expr);
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            expr = this.expr();
            column.setAsExpr(expr);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            this.lexer.nextToken();
            column.setSorted(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.VIRTUAL)) {
            this.lexer.nextToken();
            column.setVirtual(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DELIMITER)) {
            this.lexer.nextToken();
            expr = this.expr();
            column.setDelimiter(expr);
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals("delimiter_tokenizer")) {
            this.lexer.nextToken();
            expr = this.expr();
            column.setDelimiterTokenizer(expr);
            return this.parseColumnRest(column);
        }
        if (this.lexer.identifierEquals("nlp_tokenizer")) {
            this.lexer.nextToken();
            expr = this.expr();
            column.setNlpTokenizer(expr);
        }
        if (this.lexer.identifierEquals("value_type")) {
            this.lexer.nextToken();
            expr = this.expr();
            column.setValueType(expr);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.COLPROPERTIES)) {
            this.lexer.nextToken();
            this.parseAssignItem(column.getColProperties(), column);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ANNINDEX)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLAnnIndex annIndex = new SQLAnnIndex();
            while (true) {
                String type;
                if (this.lexer.identifierEquals(FnvHash.Constants.TYPE)) {
                    this.lexer.nextToken();
                    this.accept(Token.EQ);
                    type = this.lexer.stringVal();
                    annIndex.setIndexType(type);
                    this.accept(Token.LITERAL_CHARS);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.RTTYPE)) {
                    this.lexer.nextToken();
                    this.accept(Token.EQ);
                    type = this.lexer.stringVal();
                    annIndex.setRtIndexType(type);
                    this.accept(Token.LITERAL_CHARS);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.DISTANCE)) {
                    this.lexer.nextToken();
                    this.accept(Token.EQ);
                    type = this.lexer.stringVal();
                    annIndex.setDistance(type);
                    this.accept(Token.LITERAL_CHARS);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
            column.setAnnIndex(annIndex);
            return this.parseColumnRest(column);
        }
        super.parseColumnRest(column);
        return column;
    }

    @Override
    protected SQLDataType parseDataTypeRest(SQLDataType dataType) {
        super.parseDataTypeRest(dataType);
        while (true) {
            if (this.lexer.identifierEquals(FnvHash.Constants.UNSIGNED)) {
                this.lexer.nextToken();
                ((SQLDataTypeImpl)dataType).setUnsigned(true);
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.ZEROFILL)) break;
            this.lexer.nextToken();
            ((SQLDataTypeImpl)dataType).setZerofill(true);
        }
        return dataType;
    }

    @Override
    public SQLAssignItem parseAssignItem(boolean variant) {
        SQLAssignItem item = new SQLAssignItem();
        SQLExpr var = this.primary();
        String ident = null;
        long identHash = 0L;
        if (variant && var instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identExpr = (SQLIdentifierExpr)var;
            ident = identExpr.getName();
            identHash = identExpr.hashCode64();
            if (identHash == FnvHash.Constants.GLOBAL) {
                ident = this.lexer.stringVal();
                this.lexer.nextToken();
                var = new SQLVariantRefExpr(ident, true);
            } else if (identHash == FnvHash.Constants.SESSION) {
                ident = this.lexer.stringVal();
                this.lexer.nextToken();
                var = new SQLVariantRefExpr(ident, false, true);
            } else {
                var = new SQLVariantRefExpr(ident);
            }
        }
        if (identHash == FnvHash.Constants.NAMES) {
            String charset = this.lexer.stringVal();
            SQLVariantRefExpr varExpr = null;
            boolean chars = false;
            Token token = this.lexer.token();
            if (token == Token.IDENTIFIER) {
                this.lexer.nextToken();
            } else if (token == Token.DEFAULT) {
                charset = "DEFAULT";
                this.lexer.nextToken();
            } else if (token == Token.QUES) {
                varExpr = new SQLVariantRefExpr("?");
                this.lexer.nextToken();
            } else {
                chars = true;
                this.accept(Token.LITERAL_CHARS);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
                MySqlCharExpr charsetExpr = new MySqlCharExpr(charset);
                this.lexer.nextToken();
                String collate = this.lexer.stringVal();
                this.lexer.nextToken();
                charsetExpr.setCollate(collate);
                item.setValue(charsetExpr);
            } else if (varExpr != null) {
                item.setValue(varExpr);
            } else {
                item.setValue(chars ? new SQLCharExpr(charset) : new SQLIdentifierExpr(charset));
            }
            item.setTarget(var);
            return item;
        }
        if (identHash == FnvHash.Constants.CHARACTER) {
            var = new SQLVariantRefExpr("CHARACTER SET");
            this.accept(Token.SET);
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
        } else if (identHash == FnvHash.Constants.CHARSET) {
            var = new SQLVariantRefExpr("CHARACTER SET");
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
        } else if (identHash == FnvHash.Constants.TRANSACTION) {
            var = new SQLVariantRefExpr("TRANSACTION");
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
        } else if (this.lexer.token() == Token.COLONEQ) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.EQ);
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            item.setValue(new SQLIdentifierExpr("ON"));
        } else {
            item.setValue(this.expr());
        }
        item.setTarget(var);
        return item;
    }

    @Override
    public SQLName nameRest(SQLName name) {
        if (this.lexer.token() == Token.VARIANT && "@".equals(this.lexer.stringVal())) {
            this.lexer.nextToken();
            MySqlUserName userName = new MySqlUserName();
            userName.setUserName(((SQLIdentifierExpr)name).getName());
            if (this.lexer.token() == Token.LITERAL_CHARS) {
                userName.setHost("'" + this.lexer.stringVal() + "'");
            } else {
                userName.setHost(this.lexer.stringVal());
            }
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.IDENTIFIED)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                userName.setIdentifiedBy(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            return userName;
        }
        return super.nameRest(name);
    }

    @Override
    public MySqlPrimaryKey parsePrimaryKey() {
        this.accept(Token.PRIMARY);
        this.accept(Token.KEY);
        MySqlPrimaryKey primaryKey = new MySqlPrimaryKey();
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            primaryKey.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() != Token.LPAREN) {
            SQLName name = this.name();
            primaryKey.setName(name);
        }
        this.accept(Token.LPAREN);
        while (true) {
            SQLExpr expr = this.lexer.token() == Token.LITERAL_ALIAS ? this.name() : this.expr();
            primaryKey.addColumn(expr);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        while (true) {
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                SQLExpr comment = this.primary();
                primaryKey.setComment(comment);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.KEY_BLOCK_SIZE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr keyBlockSize = this.primary();
                primaryKey.setKeyBlockSize(keyBlockSize);
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.USING)) break;
            this.lexer.nextToken();
            primaryKey.setIndexType(this.lexer.stringVal());
            this.accept(Token.IDENTIFIER);
        }
        return primaryKey;
    }

    @Override
    public MySqlUnique parseUnique() {
        this.accept(Token.UNIQUE);
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
        }
        MySqlUnique unique = new MySqlUnique();
        if (this.lexer.token() != Token.LPAREN && !this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            SQLName indexName = this.name();
            unique.setName(indexName);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            unique.setIndexType(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        this.parseIndexRest(unique);
        while (true) {
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                SQLExpr comment = this.primary();
                unique.setComment(comment);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.KEY_BLOCK_SIZE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr keyBlockSize = this.primary();
                unique.setKeyBlockSize(keyBlockSize);
                continue;
            }
            if (!this.lexer.identifierEquals(FnvHash.Constants.USING)) break;
            this.lexer.nextToken();
            unique.setIndexType(this.lexer.stringVal());
            this.accept(Token.IDENTIFIER);
        }
        return unique;
    }

    @Override
    public MysqlForeignKey parseForeignKey() {
        this.accept(Token.FOREIGN);
        this.accept(Token.KEY);
        MysqlForeignKey fk = new MysqlForeignKey();
        if (this.lexer.token() != Token.LPAREN) {
            SQLName indexName = this.name();
            fk.setIndexName(indexName);
        }
        this.accept(Token.LPAREN);
        this.names(fk.getReferencingColumns(), fk);
        this.accept(Token.RPAREN);
        this.accept(Token.REFERENCES);
        fk.setReferencedTableName(this.name());
        this.accept(Token.LPAREN);
        this.names(fk.getReferencedColumns());
        this.accept(Token.RPAREN);
        if (this.lexer.identifierEquals(FnvHash.Constants.MATCH)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("FULL") || this.lexer.token() == Token.FULL) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.FULL);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.PARTIAL)) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.PARTIAL);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.SIMPLE)) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.SIMPLE);
                this.lexer.nextToken();
            } else {
                throw new ParserException("TODO : " + this.lexer.info());
            }
        }
        while (this.lexer.token() == Token.ON) {
            SQLForeignKeyImpl.Option option;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DELETE) {
                this.lexer.nextToken();
                option = this.parseReferenceOption();
                fk.setOnDelete(option);
                continue;
            }
            if (this.lexer.token() == Token.UPDATE) {
                this.lexer.nextToken();
                option = this.parseReferenceOption();
                fk.setOnUpdate(option);
                continue;
            }
            throw new ParserException("syntax error, expect DELETE or UPDATE, actual " + (Object)((Object)this.lexer.token()) + " " + this.lexer.info());
        }
        return fk;
    }

    @Override
    protected SQLAggregateExpr parseAggregateExprRest(SQLAggregateExpr aggregateExpr) {
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.parseOrderBy();
            aggregateExpr.putAttribute("ORDER BY", orderBy);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SEPARATOR)) {
            this.lexer.nextToken();
            SQLExpr seperator = this.primary();
            seperator.setParent(aggregateExpr);
            aggregateExpr.putAttribute("SEPARATOR", seperator);
        }
        return aggregateExpr;
    }

    public MySqlOrderingExpr parseSelectGroupByItem() {
        MySqlOrderingExpr item = new MySqlOrderingExpr();
        item.setExpr(this.expr());
        if (this.lexer.token() == Token.ASC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.ASC);
        } else if (this.lexer.token() == Token.DESC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.DESC);
        }
        return item;
    }

    @Override
    public SQLPartition parsePartition() {
        if (this.lexer.identifierEquals(FnvHash.Constants.DBPARTITION) || this.lexer.identifierEquals(FnvHash.Constants.TBPARTITION) || this.lexer.identifierEquals(FnvHash.Constants.SUBPARTITION)) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.PARTITION);
        }
        SQLPartition partitionDef = new SQLPartition();
        partitionDef.setName(this.name());
        SQLPartitionValue values = this.parsePartitionValues();
        if (values != null) {
            partitionDef.setValues(values);
        }
        while (true) {
            boolean storage = false;
            if (this.lexer.identifierEquals(FnvHash.Constants.DATA)) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                partitionDef.setDataDirectory(this.expr());
                continue;
            }
            if (this.lexer.token() == Token.TABLESPACE) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLName tableSpace = this.name();
                partitionDef.setTablespace(tableSpace);
                continue;
            }
            if (this.lexer.token() == Token.INDEX) {
                this.lexer.nextToken();
                this.acceptIdentifier("DIRECTORY");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                partitionDef.setIndexDirectory(this.expr());
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MAX_ROWS)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr maxRows = this.primary();
                partitionDef.setMaxRows(maxRows);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MIN_ROWS)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLExpr minRows = this.primary();
                partitionDef.setMaxRows(minRows);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE) || (storage = this.lexer.token() == Token.STORAGE || this.lexer.identifierEquals(FnvHash.Constants.STORAGE))) {
                if (storage) {
                    this.lexer.nextToken();
                }
                this.acceptIdentifier("ENGINE");
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                SQLName engine = this.name();
                partitionDef.setEngine(engine);
                continue;
            }
            if (this.lexer.token() != Token.COMMENT) break;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr comment = this.primary();
            partitionDef.setComment(comment);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                this.acceptIdentifier("SUBPARTITION");
                SQLName subPartitionName = this.name();
                SQLSubPartition subPartition = new SQLSubPartition();
                subPartition.setName(subPartitionName);
                partitionDef.addSubPartition(subPartition);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        return partitionDef;
    }

    @Override
    protected SQLExpr parseAliasExpr(String alias) {
        if (this.isEnabled(SQLParserFeature.KeepNameQuotes)) {
            return new SQLIdentifierExpr(alias);
        }
        String chars = alias.substring(1, alias.length() - 1);
        return new SQLCharExpr(chars);
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "GROUP_CONCAT", "LISTAGG", "MAX", "MIN", "STDDEV", "STDDEV_SAMP", "SUM", "JSON_ARRAYAGG", "JSON_OBJECTAGG"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            MySqlExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

