/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLBlockStatement;
import com.alibaba.fastsql.sql.optimizer.OptimizerFeature;
import com.alibaba.fastsql.sql.optimizer.rules.ADSRewrite;
import com.alibaba.fastsql.sql.optimizer.rules.CastFloatToReal;
import com.alibaba.fastsql.sql.optimizer.rules.ConstFolding;
import com.alibaba.fastsql.sql.optimizer.rules.DecorticateExistsWithAGG;
import com.alibaba.fastsql.sql.optimizer.rules.DistinctEagerAggregation;
import com.alibaba.fastsql.sql.optimizer.rules.ImplicitJoinRewrite;
import com.alibaba.fastsql.sql.optimizer.rules.MergeUnion;
import com.alibaba.fastsql.sql.optimizer.rules.MultiDistinctEagerAggregation;
import com.alibaba.fastsql.sql.optimizer.rules.Ordinal;
import com.alibaba.fastsql.sql.optimizer.rules.PipesAsConcat;
import com.alibaba.fastsql.sql.optimizer.rules.PushDown;
import com.alibaba.fastsql.sql.optimizer.rules.PushDownCount;
import com.alibaba.fastsql.sql.optimizer.rules.PushDownQueryExpr;
import com.alibaba.fastsql.sql.optimizer.rules.PushUp;
import com.alibaba.fastsql.sql.optimizer.rules.TypeInference;
import com.alibaba.fastsql.sql.optimizer.rules.ViewRewrite;
import com.alibaba.fastsql.sql.optimizer.rules.ViewRewriteWithSchema;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLParserUtils;
import com.alibaba.fastsql.sql.parser.SQLStatementParser;
import com.alibaba.fastsql.sql.repository.SchemaRepository;
import com.alibaba.fastsql.sql.repository.SchemaResolveVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public class Optimizer {
    static long DEFAULT_FEATURES;
    private DbType dbType;
    private SchemaRepository repository;
    private TimeZone timeZone;
    private long features = DEFAULT_FEATURES;
    private boolean rewriteView = false;
    private long defaultLimit = -1L;
    private String defaultSchema = null;
    private boolean constFoldingNowFun = true;
    private int distinctEagerAggregationCount = 0;

    public Optimizer(DbType dbType, OptimizerFeature ... features) {
        this.dbType = dbType;
        if (features != null) {
            for (OptimizerFeature feature : features) {
                this.features |= feature.mask;
            }
        }
    }

    public Optimizer(DbType dbType, SchemaRepository repository, OptimizerFeature ... features) {
        this.dbType = dbType;
        this.repository = repository;
        if (features != null) {
            for (OptimizerFeature feature : features) {
                this.features |= feature.mask;
            }
        }
    }

    public Optimizer(DbType dbType, SchemaRepository repository, TimeZone timeZone, OptimizerFeature ... features) {
        this.dbType = dbType;
        this.repository = repository;
        this.timeZone = timeZone;
        if (features != null) {
            for (OptimizerFeature feature : features) {
                this.features |= feature.mask;
            }
        }
    }

    public Optimizer(DbType dbType, SchemaRepository repository, TimeZone timeZone, long defaultFeatures, OptimizerFeature ... features) {
        this.dbType = dbType;
        this.repository = repository;
        this.timeZone = timeZone;
        this.features = defaultFeatures;
        if (features != null) {
            for (OptimizerFeature feature : features) {
                this.features |= feature.mask;
            }
        }
    }

    public boolean isClearSelectHint() {
        return (this.features & OptimizerFeature.ClearSelectHint.mask) != 0L;
    }

    public void setClearSelectHint(boolean value) {
        this.features = value ? (this.features |= OptimizerFeature.ClearSelectHint.mask) : (this.features &= OptimizerFeature.ClearSelectHint.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public String optimize(String sql) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, this.dbType);
        parser.config(SQLParserFeature.EnableSQLBinaryOpExprGroup, true);
        if (OptimizerFeature.isEnabled(this.features, OptimizerFeature.PipesAsConcat)) {
            parser.config(SQLParserFeature.PipesAsConcat, true);
        }
        ArrayList<SQLStatement> stmtList = new ArrayList<SQLStatement>();
        parser.parseStatementList(stmtList, -1, null);
        boolean adsRewrite = OptimizerFeature.isEnabled(this.features, OptimizerFeature.ADSRewrite);
        for (int i = 0; i < stmtList.size(); ++i) {
            SQLStatement stmt = (SQLStatement)stmtList.get(i);
            if (this.repository != null) {
                if (adsRewrite) {
                    this.repository.resolve(stmt, SchemaResolveVisitor.Option.ResolveAllColumn);
                } else {
                    this.repository.resolve(stmt, new SchemaResolveVisitor.Option[0]);
                }
            }
            this.optimize(stmt);
        }
        if (adsRewrite && stmtList.size() == 1 && stmtList.get(0) instanceof SQLBlockStatement && ((SQLBlockStatement)stmtList.get(0)).getStatementList().size() == 1) {
            SQLStatement subStmt = ((SQLBlockStatement)stmtList.get(0)).getStatementList().get(0);
            stmtList.set(0, subStmt);
        }
        return SQLUtils.toSQLString(stmtList, this.dbType);
    }

    public void optimize(SQLStatement stmt) {
        List<SQLASTVisitor> visitors = this.createVisitors();
        for (int i = 0; i < visitors.size(); ++i) {
            SQLASTVisitor v = visitors.get(i);
            stmt.accept(v);
            if (!(v instanceof DistinctEagerAggregation)) continue;
            this.distinctEagerAggregationCount += ((DistinctEagerAggregation)v).getReplaceCount();
        }
    }

    private List<SQLASTVisitor> createVisitors() {
        ArrayList<SQLASTVisitor> visitors = new ArrayList<SQLASTVisitor>();
        if ((this.features & OptimizerFeature.ADSRewrite.mask) != 0L) {
            visitors.add(new ADSRewrite.TypeResolve());
        }
        if ((this.features & OptimizerFeature.ViewRewrite.mask) != 0L) {
            visitors.add(new ViewRewrite(this.repository));
        }
        if ((this.features & OptimizerFeature.ViewRewriteWithSchema.mask) != 0L) {
            visitors.add(new ViewRewriteWithSchema(this.repository, this.defaultSchema));
        }
        if ((this.features & OptimizerFeature.PipesAsConcat.mask) != 0L) {
            visitors.add(new PipesAsConcat());
        }
        if ((this.features & OptimizerFeature.ImplicitJoinRewrite.mask) != 0L) {
            visitors.add(new ImplicitJoinRewrite());
        }
        if ((this.features & OptimizerFeature.TypeInference.mask) != 0L) {
            visitors.add(new TypeInference(this.dbType, this.timeZone));
        }
        if ((this.features & OptimizerFeature.ConstFolding.mask) != 0L) {
            visitors.add(new ConstFolding(this.dbType, this.timeZone, this.constFoldingNowFun));
        }
        if ((this.features & OptimizerFeature.MergeUnion.mask) != 0L) {
            visitors.add(new MergeUnion());
        }
        if ((this.features & OptimizerFeature.PushDownCount.mask) != 0L) {
            visitors.add(new PushDownCount());
        }
        if ((this.features & OptimizerFeature.PushDown.mask) != 0L) {
            visitors.add(new PushDown());
            visitors.add(new PushDownQueryExpr());
        }
        if ((this.features & OptimizerFeature.PushUp.mask) != 0L) {
            visitors.add(new PushUp());
        }
        if ((this.features & OptimizerFeature.Ordinal.mask) != 0L) {
            visitors.add(new Ordinal());
        }
        if ((this.features & OptimizerFeature.CastFloatToReal.mask) != 0L) {
            visitors.add(new CastFloatToReal());
        }
        if ((this.features & OptimizerFeature.ADSRewrite.mask) != 0L) {
            ADSRewrite v = new ADSRewrite(this.repository, this.timeZone, this.defaultLimit);
            v.setClearSelectHint(this.isClearSelectHint());
            visitors.add(v);
        }
        if ((this.features & OptimizerFeature.DistinctEagerAggregation.mask) != 0L) {
            visitors.add(new DistinctEagerAggregation());
        }
        if ((this.features & OptimizerFeature.DecorticateExistsWithAGG.mask) != 0L) {
            visitors.add(new DecorticateExistsWithAGG());
        }
        if ((this.features & OptimizerFeature.MultiDistinctEagerAggregation.mask) != 0L) {
            visitors.add(new MultiDistinctEagerAggregation());
        }
        return visitors;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public SchemaRepository getRepository() {
        return this.repository;
    }

    public void setRepository(SchemaRepository repository) {
        this.repository = repository;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public long getFeatures() {
        return this.features;
    }

    public void setFeatures(long features) {
        this.features = features;
    }

    public boolean isRewriteView() {
        return (this.features & OptimizerFeature.ViewRewrite.mask) != 0L;
    }

    public void setRewriteView(boolean rewriteView) {
        this.features |= OptimizerFeature.ViewRewrite.mask;
    }

    public long getDefaultLimit() {
        return this.defaultLimit;
    }

    public void setDefaultLimit(long defaultLimit) {
        this.defaultLimit = defaultLimit;
    }

    public boolean isConstFoldingNowFun() {
        return this.constFoldingNowFun;
    }

    public void setConstFoldingNowFun(boolean constFoldingNowFun) {
        this.constFoldingNowFun = constFoldingNowFun;
    }

    public int getDistinctEagerAggregationCount() {
        return this.distinctEagerAggregationCount;
    }

    static {
        DEFAULT_FEATURES |= OptimizerFeature.ConstFolding.mask;
        DEFAULT_FEATURES |= OptimizerFeature.PushUp.mask;
        DEFAULT_FEATURES |= OptimizerFeature.PushDown.mask;
        DEFAULT_FEATURES |= OptimizerFeature.PushDownCount.mask;
        DEFAULT_FEATURES |= OptimizerFeature.MergeUnion.mask;
        DEFAULT_FEATURES |= OptimizerFeature.Ordinal.mask;
        DEFAULT_FEATURES |= OptimizerFeature.TypeInference.mask;
        DEFAULT_FEATURES |= OptimizerFeature.ImplicitJoinRewrite.mask;
        DEFAULT_FEATURES |= OptimizerFeature.ClearSelectHint.mask;
    }
}

