/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.optimizer.Optimizer;
import com.alibaba.fastsql.sql.optimizer.OptimizerFeature;
import com.alibaba.fastsql.sql.repository.SchemaRepository;
import java.util.TimeZone;

public class Optimizers {
    public static String optimize(String sql, DbType dbType) {
        Optimizer optimizer = new Optimizer(dbType, new OptimizerFeature[0]);
        return optimizer.optimize(sql);
    }

    public static String optimize(String sql, DbType dbType, OptimizerFeature ... features) {
        Optimizer optimizer = new Optimizer(dbType, features);
        return optimizer.optimize(sql);
    }

    public static String optimize(String sql, DbType dbType, SchemaRepository repository, OptimizerFeature ... features) {
        Optimizer optimizer = new Optimizer(dbType, repository, features);
        return optimizer.optimize(sql);
    }

    public static String optimize(String sql, DbType dbType, SchemaRepository repository, TimeZone timeZone, OptimizerFeature ... features) {
        Optimizer optimizer = new Optimizer(dbType, repository, timeZone, features);
        return optimizer.optimize(sql);
    }

    public static String optimize(String sql, DbType dbType, SchemaRepository repository, TimeZone timeZone, long defaultFeature, OptimizerFeature ... features) {
        Optimizer optimizer = new Optimizer(dbType, repository, timeZone, defaultFeature, features);
        return optimizer.optimize(sql);
    }

    public static void optimize(SQLStatement stmt, DbType dbType) {
        Optimizer optimizer = new Optimizer(dbType, new OptimizerFeature[0]);
        optimizer.optimize(stmt);
    }

    public static void optimize(SQLStatement stmt, DbType dbType, SchemaRepository repository, OptimizerFeature ... features) {
        Optimizer optimizer = new Optimizer(dbType, repository, features);
        optimizer.optimize(stmt);
    }

    public static void optimize(SQLStatement stmt, DbType dbType, SchemaRepository repository, TimeZone timeZone, OptimizerFeature ... features) {
        Optimizer optimizer = new Optimizer(dbType, repository, timeZone, features);
        optimizer.optimize(stmt);
    }

    public static void optimize(SQLStatement stmt, DbType dbType, SchemaRepository repository, long defaultFeature, OptimizerFeature ... features) {
        Optimizer optimizer = new Optimizer(dbType, repository, null, defaultFeature, features);
        optimizer.optimize(stmt);
    }
}

