/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNumberExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLRealExpr;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;

public class CastFloatToReal
extends OptimizerVisitor {
    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        if (this.isGroup(x)) {
            return super.visit(x);
        }
        if (x.isLeftNameAndRightLiteral()) {
            SQLName left = (SQLName)x.getLeft();
            SQLLiteralExpr right = (SQLLiteralExpr)x.getRight();
            SQLDataType dataType = left.computeDataType();
            if (dataType == null) {
                return true;
            }
            if ((dataType.nameHashCode64() == FnvHash.Constants.FLOAT || dataType.nameHashCode64() == FnvHash.Constants.REAL) && right instanceof SQLNumberExpr) {
                x.setRight(new SQLRealExpr(((SQLNumberExpr)right).getNumber().floatValue()));
            }
        }
        return true;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        SQLDataType dataType = x.getExpr().computeDataType();
        if (dataType == null) {
            return true;
        }
        if (dataType.nameHashCode64() == FnvHash.Constants.FLOAT || dataType.nameHashCode64() == FnvHash.Constants.REAL) {
            List<SQLExpr> targetList = x.getTargetList();
            for (int i = 0; i < targetList.size(); ++i) {
                SQLExpr val = targetList.get(i);
                if (!(val instanceof SQLNumberExpr)) continue;
                SQLRealExpr real = new SQLRealExpr(((SQLNumberExpr)val).getNumber().floatValue());
                real.setParent(x);
                targetList.set(i, real);
            }
        }
        return true;
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        SQLDataType dataType = x.getTestExpr().computeDataType();
        if (dataType == null) {
            return true;
        }
        if (dataType.nameHashCode64() == FnvHash.Constants.FLOAT || dataType.nameHashCode64() == FnvHash.Constants.REAL) {
            SQLExpr end;
            SQLExpr begin = x.getBeginExpr();
            if (begin instanceof SQLNumberExpr) {
                x.setBeginExpr(new SQLRealExpr(((SQLNumberExpr)begin).getNumber().floatValue()));
            }
            if ((end = x.getEndExpr()) instanceof SQLNumberExpr) {
                x.setEndExpr(new SQLRealExpr(((SQLNumberExpr)end).getNumber().floatValue()));
            }
        }
        return true;
    }
}

