/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCaseExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLNullExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class DistinctEagerAggregation
extends OptimizerVisitor {
    private int columnALiasSeed = 1;
    private int tableALiasSeed = 1;

    protected String genColumnAlias() {
        return "DEA_F_" + this.columnALiasSeed++ + "_";
    }

    protected String genTableAlias() {
        return "DEA_T_" + this.tableALiasSeed++ + "_";
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        super.visit(x);
        SQLSelectGroupByClause groupBy = x.getGroupBy();
        if (groupBy == null) {
            return false;
        }
        if (groupBy.getHaving() != null) {
            return false;
        }
        for (SQLExpr item : groupBy.getItems()) {
            if (item instanceof SQLIntegerExpr || item instanceof SQLName) continue;
            return false;
        }
        if (x.getStartWith() != null || x.getConnectBy() != null || x.getDistributeByDirect() != null && x.getDistributeByDirect().size() > 0 || x.getSortByDirect() != null && x.getSortByDirect().size() > 0 || x.getClusterByDirect() != null && x.getClusterByDirect().size() > 0 || x.getWindows() != null && x.getWindows().size() > 0) {
            return false;
        }
        List<SQLSelectItem> selectList = x.getSelectList();
        ArrayList<SQLSelectItem> countDistinctItems = new ArrayList<SQLSelectItem>();
        SQLName distinctColumn = null;
        for (SQLSelectItem selectItem : selectList) {
            SQLExpr expr = selectItem.getExpr();
            if (expr instanceof SQLName) continue;
            if (!(expr instanceof SQLAggregateExpr)) {
                return false;
            }
            SQLAggregateExpr aggregateExpr = (SQLAggregateExpr)expr;
            if (aggregateExpr.getOver() != null) {
                return false;
            }
            List<SQLExpr> arguments = aggregateExpr.getArguments();
            if (arguments.size() != 1) {
                return false;
            }
            SQLExpr arg0 = arguments.get(0);
            if (arg0 instanceof SQLCaseExpr) {
                SQLCaseExpr caseExpr = (SQLCaseExpr)arg0;
                if (caseExpr.getValueExpr() != null || !(caseExpr.getElseExpr() instanceof SQLNullExpr) || caseExpr.getItems().size() != 1 || !(caseExpr.getItems().get(0).getValueExpr() instanceof SQLName)) {
                    return false;
                }
                SQLMethodInvokeExpr ifExpr = new SQLMethodInvokeExpr("IF", null, caseExpr.getItems().get(0).getConditionExpr().clone(), caseExpr.getItems().get(0).getValueExpr().clone(), new SQLNullExpr());
                arg0 = ifExpr;
                aggregateExpr.setArgument(0, ifExpr);
            }
            if (aggregateExpr.methodNameHashCode64() != FnvHash.Constants.COUNT) {
                if (aggregateExpr.methodNameHashCode64() == FnvHash.Constants.SUM || aggregateExpr.methodNameHashCode64() == FnvHash.Constants.MAX || aggregateExpr.methodNameHashCode64() == FnvHash.Constants.MIN) {
                    if (arg0 instanceof SQLName) continue;
                    return false;
                }
                return false;
            }
            if (!aggregateExpr.isDistinct()) {
                if (arg0 instanceof SQLName || arg0 instanceof SQLIntegerExpr) continue;
                if (arg0 instanceof SQLAllColumnExpr) {
                    return false;
                }
                if (arg0 instanceof SQLMethodInvokeExpr) {
                    SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)arg0;
                    if (methodInvokeExpr.methodNameHashCode64() != FnvHash.Constants.IF || methodInvokeExpr.getArguments().size() != 3 || !(methodInvokeExpr.getArguments().get(1) instanceof SQLName) || !(methodInvokeExpr.getArguments().get(2) instanceof SQLNullExpr)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (arguments.size() != 1) {
                return false;
            }
            SQLExpr distinctExpr = arguments.get(0);
            if (distinctExpr instanceof SQLMethodInvokeExpr) {
                SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)distinctExpr;
                if (methodInvokeExpr.methodNameHashCode64() != FnvHash.Constants.IF || methodInvokeExpr.getArguments().size() != 3 || !(methodInvokeExpr.getArguments().get(1) instanceof SQLName) || !(methodInvokeExpr.getArguments().get(2) instanceof SQLNullExpr)) {
                    return false;
                }
            } else if (distinctExpr instanceof SQLName) {
                distinctColumn = (SQLName)distinctExpr;
            } else {
                return false;
            }
            countDistinctItems.add(selectItem);
        }
        if (distinctColumn == null) {
            return true;
        }
        String distinctColumnAlias = this.genColumnAlias();
        ArrayList<SQLExpr> filters = new ArrayList<SQLExpr>();
        for (SQLSelectItem item : countDistinctItems) {
            SQLAggregateExpr aggregateExpr = (SQLAggregateExpr)item.getExpr();
            SQLExpr expr = aggregateExpr.getArguments().get(0);
            if (expr instanceof SQLName) {
                if (DistinctEagerAggregation.nameEquals(expr, distinctColumn)) continue;
                return false;
            }
            if (expr instanceof SQLMethodInvokeExpr) {
                SQLMethodInvokeExpr ifExpr = (SQLMethodInvokeExpr)expr;
                SQLExpr arg1 = ifExpr.getArguments().get(1);
                if (!DistinctEagerAggregation.nameEquals(arg1, distinctColumn)) {
                    return false;
                }
                filters.add(ifExpr.getArguments().get(0));
                continue;
            }
            return false;
        }
        if (filters.size() != countDistinctItems.size() - 1) {
            return false;
        }
        SQLSelectQueryBlock subquery = new SQLSelectQueryBlock(this.dbType);
        subquery.setFrom(x.getFrom());
        SQLSelectGroupByClause subGroupBy = groupBy.clone();
        subGroupBy.addItem(distinctColumn.clone());
        for (SQLExpr filter : filters) {
            subGroupBy.addItem(filter.clone());
        }
        subquery.setGroupBy(subGroupBy);
        for (SQLSelectItem selectItem : selectList) {
            SQLExpr selectItemExpr = selectItem.getExpr();
            String selectItemAlias = selectItem.getAlias();
            if (selectItemExpr instanceof SQLName) {
                subquery.addSelectItem(selectItem.clone());
                selectItem.setExpr(new SQLIdentifierExpr(selectItem.computeAlias()));
                selectItem.setAlias(null);
                continue;
            }
            SQLAggregateExpr aggregateExpr = (SQLAggregateExpr)selectItemExpr;
            SQLExpr arg0 = aggregateExpr.getArguments().get(0);
            if (aggregateExpr.methodNameHashCode64() == FnvHash.Constants.COUNT && aggregateExpr.isDistinct()) {
                if (aggregateExpr.isDistinct()) {
                    if (arg0 instanceof SQLName) {
                        SQLName name = (SQLName)arg0;
                        subquery.addSelectItem(new SQLSelectItem(name, distinctColumnAlias));
                        if (selectItemAlias == null) continue;
                        aggregateExpr.setArgument(0, new SQLIdentifierExpr(distinctColumnAlias));
                        continue;
                    }
                    if (arg0 instanceof SQLMethodInvokeExpr) {
                        SQLMethodInvokeExpr ifExpr = (SQLMethodInvokeExpr)arg0;
                        SQLExpr filter = ifExpr.getArguments().get(0);
                        String subSelectItemAlias = this.genColumnAlias();
                        subquery.addSelectItem(filter, subSelectItemAlias);
                        ifExpr.setArgument(0, new SQLIdentifierExpr(subSelectItemAlias));
                        ifExpr.setArgument(1, new SQLIdentifierExpr(distinctColumnAlias));
                        continue;
                    }
                    throw new IllegalStateException();
                }
                throw new UnsupportedOperationException();
            }
            String subItemALias = this.genColumnAlias();
            subquery.addSelectItem(new SQLSelectItem(aggregateExpr.clone(), subItemALias));
            if (selectItemAlias != null) {
                aggregateExpr.setArgument(0, new SQLIdentifierExpr(subItemALias));
            }
            if (aggregateExpr.methodNameHashCode64() != FnvHash.Constants.COUNT) continue;
            aggregateExpr.setMethodName("SUM");
        }
        for (int i = groupBy.getItems().size() - 1; i >= 0; --i) {
            SQLExpr item = groupBy.getItems().get(i);
            if (item instanceof SQLIntegerExpr) continue;
            SQLName name = (SQLName)item;
            for (SQLSelectItem selectItem : subquery.getSelectList()) {
                SQLExpr selectItemExpr = selectItem.getExpr();
                if (!DistinctEagerAggregation.nameEquals(selectItemExpr, name)) continue;
                String alias = selectItem.computeAlias();
                groupBy.getItems().set(i, new SQLIdentifierExpr(alias));
            }
        }
        x.setFrom(subquery, this.genTableAlias());
        SQLExpr where = x.getWhere();
        if (where != null) {
            subquery.setWhere(where.clone());
            x.setWhere(null);
        }
        ++this.optimizedCount;
        return false;
    }

    private static boolean nameEquals(SQLExpr a, SQLExpr b) {
        if (a instanceof SQLPropertyExpr && b instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)a).hashCode64() == ((SQLPropertyExpr)b).hashCode64();
        }
        if (a instanceof SQLIdentifierExpr && b instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)a).hashCode64() == ((SQLIdentifierExpr)b).hashCode64();
        }
        return false;
    }
}

