/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLExprImpl;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLDecimalExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLInListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLListExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.fastsql.util.FnvHash;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DynamicFilterVisitor
extends OptimizerVisitor {
    private DynamicQueryHandler dynamicQueryHandler;
    protected Exception error = null;
    private int tableALiasSeed = 1;

    protected String genTableAlias() {
        return "DFP_T_" + this.tableALiasSeed++ + "_";
    }

    public DynamicQueryHandler getDynamicQueryHandler() {
        return this.dynamicQueryHandler;
    }

    public void setDynamicQueryHandler(DynamicQueryHandler dynamicQueryHandler) {
        this.dynamicQueryHandler = dynamicQueryHandler;
    }

    public Exception getError() {
        return this.error;
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock x) {
        Plan plan2;
        if (this.dynamicQueryHandler == null) {
            return super.visit(x);
        }
        List<SQLTableSource> mappJoinTableSources = x.getMappJoinTableSources();
        if (mappJoinTableSources.size() == 0) {
            return super.visit(x);
        }
        block7: for (int i = mappJoinTableSources.size() - 1; i >= 0; --i) {
            SQLTableSource tableSource = mappJoinTableSources.get(i);
            SQLObject parent = tableSource.getParent();
            if (!(parent instanceof SQLJoinTableSource)) {
                mappJoinTableSources.remove(i);
                continue;
            }
            SQLJoinTableSource join = (SQLJoinTableSource)parent;
            SQLJoinTableSource.JoinType joinType = join.getJoinType();
            if (joinType == null) continue;
            switch (joinType) {
                case JOIN: 
                case INNER_JOIN: {
                    continue block7;
                }
                case LEFT_OUTER_JOIN: {
                    if (tableSource != join.getRight()) continue block7;
                    mappJoinTableSources.remove(i);
                    continue block7;
                }
                case RIGHT_OUTER_JOIN: {
                    if (tableSource != join.getLeft()) continue block7;
                    mappJoinTableSources.remove(i);
                    continue block7;
                }
                default: {
                    mappJoinTableSources.remove(i);
                    continue block7;
                }
            }
        }
        List<SQLExpr> queryConditions = null;
        SQLExpr where = x.getWhere();
        if (where != null) {
            queryConditions = SQLBinaryOpExpr.split(where, SQLBinaryOperator.BooleanAnd);
        }
        ArrayList<Plan> planList = new ArrayList<Plan>();
        for (SQLTableSource tableSource : mappJoinTableSources) {
            SQLIdentifierExpr identTableSourceExpr;
            SQLTableSource resolvedTableSource;
            SQLExpr tableSourceExpr;
            plan2 = new Plan();
            long aliasHashCode64 = tableSource.aliasHashCode64();
            if (aliasHashCode64 == 0L && tableSource instanceof SQLExprTableSource) {
                SQLName tableName = (SQLName)((SQLExprTableSource)tableSource).getExpr();
                aliasHashCode64 = tableName.nameHashCode64();
            }
            plan2.queryBlock = new MySqlSelectQueryBlock();
            plan2.queryBlock.setFrom(tableSource.clone());
            if (tableSource instanceof SQLExprTableSource && (tableSourceExpr = ((SQLExprTableSource)tableSource).getExpr()) instanceof SQLIdentifierExpr && (resolvedTableSource = (identTableSourceExpr = (SQLIdentifierExpr)tableSourceExpr).getResolvedTableSource()) instanceof SQLWithSubqueryClause.Entry) {
                SQLSelect subQuery = ((SQLWithSubqueryClause.Entry)resolvedTableSource).getSubQuery().clone();
                plan2.queryBlock.setFrom(subQuery, identTableSourceExpr.normalizedName());
            }
            plan2.values = new SQLValuesTableSource();
            plan2.values.setAlias(tableSource.computeAlias());
            plan2.mapTableSource = tableSource;
            SQLObject parent = tableSource.getParent();
            if (parent instanceof SQLJoinTableSource) {
                SQLJoinTableSource join = (SQLJoinTableSource)parent;
                SQLExpr on = join.getCondition();
                if (on == null) continue;
                List<SQLExpr> joinConditions = SQLBinaryOpExpr.split(on, SQLBinaryOperator.BooleanAnd);
                for (SQLExpr joinCondition : joinConditions) {
                    SQLBinaryOpExpr binaryOpExpr;
                    if (!(joinCondition instanceof SQLBinaryOpExpr) || !(binaryOpExpr = (SQLBinaryOpExpr)joinCondition).isBothName() || binaryOpExpr.getOperator() == SQLBinaryOperator.Equality) continue;
                    return false;
                }
                this.buildQuery(aliasHashCode64, plan2, joinConditions);
                this.buildQuery(aliasHashCode64, plan2, queryConditions);
            }
            planList.add(plan2);
        }
        boolean hasNotSupportType = false;
        for (int i = 0; i < planList.size(); ++i) {
            List<Object[]> rows;
            plan2 = (Plan)planList.get(i);
            MySqlSelectQueryBlock dynamicQuery = plan2.queryBlock;
            String dynamicQuerySql = dynamicQuery.toString();
            try {
                rows = this.dynamicQueryHandler.executeQuery(dynamicQuerySql);
            }
            catch (Exception ex) {
                this.error = ex;
                return false;
            }
            for (Object[] row : rows) {
                SQLListExpr rowExpr = new SQLListExpr();
                Iterator<Object> iterator = plan2.inSelectItemIndexes.iterator();
                while (iterator.hasNext()) {
                    int selectItemIndex = iterator.next();
                    Object colVal = row[selectItemIndex];
                    SQLExprImpl expr = null;
                    if (colVal instanceof Byte || colVal instanceof Short || colVal instanceof Integer || colVal instanceof Long) {
                        expr = new SQLIntegerExpr((Number)colVal);
                    } else if (colVal instanceof BigDecimal) {
                        expr = new SQLDecimalExpr((BigDecimal)colVal);
                    } else if (colVal instanceof String) {
                        expr = new SQLCharExpr((String)colVal);
                    } else if (colVal instanceof Character) {
                        expr = new SQLCharExpr(colVal.toString());
                    } else if (colVal instanceof Boolean) {
                        expr = new SQLBooleanExpr((Boolean)colVal);
                    } else if (colVal instanceof Date) {
                        expr = new SQLDateExpr((Date)colVal);
                    } else if (colVal instanceof Timestamp) {
                        expr = new SQLTimestampExpr((Timestamp)colVal);
                    } else {
                        hasNotSupportType = true;
                        if (colVal == null) {
                            this.error = new SQLException("not support null value.");
                            break;
                        }
                        this.error = new SQLException("not support Type : " + colVal.getClass());
                        break;
                    }
                    plan2.ins.get(selectItemIndex).addTarget(expr);
                    rowExpr.addItem(expr.clone());
                }
                plan2.values.addValue(rowExpr);
            }
        }
        if (hasNotSupportType) {
            return false;
        }
        for (Plan plan2 : planList) {
            for (SQLInListExpr in : plan2.ins) {
                if (in.getTargetList().size() != 0) continue;
                this.error = new SQLException("in targetList is empty");
                return false;
            }
        }
        for (Plan plan2 : planList) {
            PlanVisitor v = new PlanVisitor(plan2);
            x.accept(v);
        }
        int tableSourceReplacedCount = 0;
        for (Plan plan3 : planList) {
            for (SQLInListExpr in : plan3.ins) {
                x.addCondition(in);
            }
            if (!plan3.isIncludeAllColumns()) continue;
            boolean tableSourceReplaced = false;
            if (plan3.values.getColumns().size() == plan3.ins.size()) {
                if (SQLUtils.replaceInParent(plan3.mapTableSource, null)) {
                    tableSourceReplaced = true;
                }
            } else if (SQLUtils.replaceInParent(plan3.mapTableSource, plan3.values)) {
                tableSourceReplaced = true;
            }
            if (!tableSourceReplaced) continue;
            ++tableSourceReplacedCount;
            for (SQLExpr filter : plan3.mapTableSourceFilters) {
                SQLUtils.replaceInParent(filter, null);
            }
        }
        if (planList.size() > 0 && planList.size() == mappJoinTableSources.size() && tableSourceReplacedCount == planList.size()) {
            x.clearMapJoinHint();
        }
        return false;
    }

    private void buildQuery(long aliasHashCode64, Plan plan, List<SQLExpr> joinConditions) {
        if (joinConditions == null) {
            return;
        }
        SQLTableSource from = plan.queryBlock.getFrom();
        if (from.getAlias() == null && from instanceof SQLExprTableSource && ((SQLExprTableSource)from).getExpr() instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)((SQLExprTableSource)from).getExpr();
            from.setAlias(propertyExpr.getName());
        }
        for (SQLExpr condition : joinConditions) {
            SQLBetweenExpr betweenExpr;
            SQLName name;
            if (condition instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpCond = (SQLBinaryOpExpr)condition;
                if (binaryOpCond.isBothName()) {
                    SQLInListExpr in;
                    SQLName leftName = (SQLName)binaryOpCond.getLeft();
                    SQLName rightName = (SQLName)binaryOpCond.getRight();
                    if (leftName instanceof SQLPropertyExpr && ((SQLPropertyExpr)leftName).getOwner() instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)((SQLPropertyExpr)leftName).getOwner()).nameHashCode64() == aliasHashCode64) {
                        plan.queryBlock.addSelectItem(leftName.clone());
                        plan.values.addColumn(rightName.getSimpleName());
                        in = new SQLInListExpr();
                        in.setExpr(rightName.clone());
                        plan.ins.add(in);
                        plan.inSelectItemIndexes.add(plan.queryBlock.getSelectList().size() - 1);
                    } else if (rightName instanceof SQLPropertyExpr && ((SQLPropertyExpr)rightName).getOwner() instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)((SQLPropertyExpr)rightName).getOwner()).nameHashCode64() == aliasHashCode64) {
                        plan.queryBlock.addSelectItem(rightName.clone());
                        plan.values.addColumn(rightName.getSimpleName());
                        in = new SQLInListExpr();
                        in.setExpr(leftName.clone());
                        plan.ins.add(in);
                        plan.inSelectItemIndexes.add(plan.queryBlock.getSelectList().size() - 1);
                    }
                }
                name = null;
                SQLLiteralExpr literal = null;
                if (binaryOpCond.isLeftNameAndRightLiteral()) {
                    name = (SQLName)binaryOpCond.getLeft();
                    literal = (SQLLiteralExpr)binaryOpCond.getRight();
                } else if (binaryOpCond.isLeftLiteralAndRightName()) {
                    name = (SQLName)binaryOpCond.getRight();
                    literal = (SQLLiteralExpr)binaryOpCond.getLeft();
                }
                if (name == null) continue;
                if (name instanceof SQLPropertyExpr && ((SQLPropertyExpr)name).getOwner() instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)((SQLPropertyExpr)name).getOwner()).nameHashCode64() == aliasHashCode64) {
                    plan.queryBlock.addCondition(condition.clone());
                    plan.mapTableSourceFilters.add(condition);
                    continue;
                }
                if (!(name instanceof SQLIdentifierExpr) || ((SQLIdentifierExpr)name).getResolvedTableSource() == null || ((SQLIdentifierExpr)name).getResolvedTableSource() != plan.mapTableSource) continue;
                plan.queryBlock.addCondition(condition.clone());
                plan.mapTableSourceFilters.add(condition);
                continue;
            }
            if (condition instanceof SQLInListExpr) {
                SQLInListExpr inListExpr = (SQLInListExpr)condition;
                if (!(inListExpr.getExpr() instanceof SQLName)) continue;
                name = (SQLName)inListExpr.getExpr();
                boolean allLiteral = true;
                for (SQLExpr item : inListExpr.getTargetList()) {
                    if (item instanceof SQLLiteralExpr) continue;
                    allLiteral = false;
                    break;
                }
                if (!allLiteral || !(name instanceof SQLPropertyExpr) || !(((SQLPropertyExpr)name).getOwner() instanceof SQLIdentifierExpr) || ((SQLIdentifierExpr)((SQLPropertyExpr)name).getOwner()).nameHashCode64() != aliasHashCode64) continue;
                plan.queryBlock.addCondition(condition.clone());
                plan.mapTableSourceFilters.add(condition);
                continue;
            }
            if (!(condition instanceof SQLBetweenExpr) || !((betweenExpr = (SQLBetweenExpr)condition).getTestExpr() instanceof SQLName)) continue;
            name = (SQLName)betweenExpr.getTestExpr();
            boolean allLiteral = betweenExpr.getBeginExpr() instanceof SQLLiteralExpr && betweenExpr.getEndExpr() instanceof SQLLiteralExpr;
            if (!allLiteral || !(name instanceof SQLPropertyExpr) || !(((SQLPropertyExpr)name).getOwner() instanceof SQLIdentifierExpr) || ((SQLIdentifierExpr)((SQLPropertyExpr)name).getOwner()).nameHashCode64() != aliasHashCode64) continue;
            plan.queryBlock.addCondition(condition.clone());
            plan.mapTableSourceFilters.add(condition);
        }
    }

    public static interface DynamicQueryHandler {
        public List<Object[]> executeQuery(String var1);
    }

    private class PlanVisitor
    extends SQLASTVisitorAdapter {
        Plan plan;

        public PlanVisitor(Plan plan) {
            this.plan = plan;
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            SQLExpr owner = x.getOwner();
            if (owner instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)owner).nameHashCode64() == this.plan.mapTableSource.aliasHashCode64()) {
                this.plan.columns.add(new SQLIdentifierExpr(x.getName()));
            }
            return false;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            return false;
        }

        @Override
        public boolean visit(SQLAggregateExpr x) {
            SQLExpr arg;
            return x.methodNameHashCode64() != FnvHash.Constants.COUNT || x.getArguments().size() != 1 || !((arg = x.getArguments().get(0)) instanceof SQLAllColumnExpr);
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            SQLTableSource resolvedTableSource = x.getResolvedTableSource();
            if (resolvedTableSource == null) {
                this.plan.notResolvedcolumns.add(x);
            } else if (resolvedTableSource == this.plan.mapTableSource) {
                this.plan.columns.add(x);
            }
            return false;
        }

        @Override
        public boolean visit(SQLAllColumnExpr x) {
            this.plan.notResolvedcolumns.add(new SQLIdentifierExpr("*"));
            return false;
        }

        @Override
        public boolean visit(SQLBinaryOpExpr x) {
            return !this.plan.mapTableSourceFilters.contains(x);
        }
    }

    static class Plan {
        MySqlSelectQueryBlock queryBlock;
        List<SQLInListExpr> ins = new ArrayList<SQLInListExpr>();
        List<Integer> inSelectItemIndexes = new ArrayList<Integer>();
        SQLValuesTableSource values;
        SQLTableSource mapTableSource;
        List<SQLExpr> mapTableSourceFilters = new ArrayList<SQLExpr>();
        List<SQLName> columns = new ArrayList<SQLName>();
        List<SQLName> notResolvedcolumns = new ArrayList<SQLName>();

        Plan() {
        }

        public boolean isIncludeAllColumns() {
            if (this.notResolvedcolumns.size() > 0) {
                return false;
            }
            for (SQLName column : this.columns) {
                if (this.values.getColumns().contains(column)) continue;
                return false;
            }
            return true;
        }
    }
}

