/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLAggregateOption;
import com.alibaba.fastsql.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.util.FnvHash;
import java.util.List;

public class PushDownCount
extends OptimizerVisitor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        if (x.getGroupBy() != null || x.getWhere() != null || x.getFrom() == null) {
            return super.visit(x);
        }
        List<SQLSelectItem> selectList = x.getSelectList();
        String alias = null;
        boolean count_match = false;
        if (selectList.size() == 1 && selectList.get(0).getExpr() instanceof SQLAggregateExpr) {
            SQLAggregateExpr aggregateExpr = (SQLAggregateExpr)selectList.get(0).getExpr();
            if (aggregateExpr.getOver() != null) {
                return super.visit(x);
            }
            if (aggregateExpr.methodNameHashCode64() == FnvHash.Constants.COUNT && aggregateExpr.getArguments().size() == 1) {
                SQLExpr arg0 = aggregateExpr.getArguments().get(0);
                if (arg0 instanceof SQLAllColumnExpr) {
                    count_match = true;
                } else if (arg0 instanceof SQLPropertyExpr) {
                    SQLPropertyExpr propertyExpr = (SQLPropertyExpr)arg0;
                    SQLExpr owner = propertyExpr.getOwner();
                    long aliasHash = x.getFrom().aliasHashCode64();
                    if (propertyExpr.getName().equals("*") && owner instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)owner).nameHashCode64() == aliasHash) {
                        alias = x.getFrom().getAlias();
                        count_match = true;
                    }
                } else if (arg0 instanceof SQLIntegerExpr && ((SQLIntegerExpr)arg0).getNumber().intValue() == 1) {
                    count_match = true;
                }
            }
        }
        if (!count_match) {
            return super.visit(x);
        }
        SQLSelectQueryBlock subQueryBlock = null;
        SQLTableSource from = x.getFrom();
        if (from instanceof SQLSubqueryTableSource) {
            SQLSelect select = ((SQLSubqueryTableSource)from).getSelect();
            subQueryBlock = select.getQueryBlock();
        }
        if (subQueryBlock == null) {
            return super.visit(x);
        }
        SQLTableSource subQueryBlockFrom = subQueryBlock.getFrom();
        SQLSelectQueryBlock subQueryBlock_cloned = subQueryBlock.clone();
        subQueryBlock_cloned.getSelectList().clear();
        SQLSelectGroupByClause subQueryGroupBy = subQueryBlock.getGroupBy();
        if (subQueryGroupBy == null) {
            for (SQLSelectItem subquerySelectItem : subQueryBlock.getSelectList()) {
                if (!(subquerySelectItem.getExpr() instanceof SQLAggregateExpr)) continue;
                return true;
            }
            if (subQueryBlockFrom instanceof SQLJoinTableSource) {
                return super.visit(x);
            }
            SQLSelectItem selectItem = selectList.get(0).clone();
            SQLAggregateExpr aggregateExpr = (SQLAggregateExpr)selectItem.getExpr();
            if (aggregateExpr.getOption() == SQLAggregateOption.DISTINCT || subQueryBlock.getDistionOption() == 2) {
                if (subQueryBlock.getSelectList().size() != 1) return super.visit(x);
                aggregateExpr.getArguments().clear();
                aggregateExpr.addArgument(subQueryBlock.getSelectList().get(0).getExpr().clone());
                if (subQueryBlock.getDistionOption() == 2) {
                    aggregateExpr.setOption(SQLAggregateOption.DISTINCT);
                    subQueryBlock_cloned.setDistionOption(0);
                }
            } else if (alias != null) {
                aggregateExpr.getArguments().clear();
                aggregateExpr.addArgument(new SQLAllColumnExpr());
            }
            subQueryBlock_cloned.addSelectItem(selectItem);
            if (!x.replaceInParent(subQueryBlock_cloned)) return super.visit(x);
            ++this.optimizedCount;
            return super.visit(x);
        } else {
            if (subQueryGroupBy.getItems().size() == 1 && subQueryGroupBy.getHaving() == null && subQueryBlock.getLimit() == null) {
                SQLExpr groupByExpr = subQueryBlock_cloned.getGroupBy().getItems().get(0);
                if (groupByExpr instanceof SQLIdentifierExpr) {
                    for (SQLSelectItem selectItem : subQueryBlock.getSelectList()) {
                        if (selectItem.alias_hash() != ((SQLIdentifierExpr)groupByExpr).nameHashCode64()) continue;
                        groupByExpr = selectItem.getExpr().clone();
                    }
                }
                subQueryBlock_cloned.setGroupBy(null);
                SQLSelectItem selectItem = selectList.get(0).clone();
                selectItem.setExpr(new SQLAggregateExpr("COUNT", SQLAggregateOption.DISTINCT, groupByExpr));
                subQueryBlock_cloned.getSelectList().clear();
                subQueryBlock_cloned.addSelectItem(selectItem);
                if (x.replaceInParent(subQueryBlock_cloned)) {
                    ++this.optimizedCount;
                    return super.visit(x);
                }
            }
            subQueryBlock_cloned.addSelectItem(new SQLSelectItem(1));
            ((SQLSubqueryTableSource)from).getSelect().setQuery(subQueryBlock_cloned);
            ++this.optimizedCount;
            return super.visit(x);
        }
    }
}

