/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.optimizer.rules;

import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.SQLObject;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelect;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.sql.ast.statement.SQLTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.fastsql.sql.optimizer.rules.OptimizerVisitor;
import com.alibaba.fastsql.sql.optimizer.rules.ViewRewriteRefAlias;
import com.alibaba.fastsql.sql.repository.Schema;
import com.alibaba.fastsql.sql.repository.SchemaObject;
import com.alibaba.fastsql.sql.repository.SchemaRepository;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewRewriteWithSchema
extends OptimizerVisitor {
    private List<SchemaObject> views = new ArrayList<SchemaObject>();
    private SchemaRepository repository;
    private String defaultSchema;
    private Map<String, SchemaObject> viewMap = new HashMap<String, SchemaObject>();
    private Map<String, String> originalViewMap = new HashMap<String, String>();
    private Map<String, String> newViewMap = new HashMap<String, String>();

    public ViewRewriteWithSchema(SchemaRepository repository, String defaultSchema) {
        this.repository = repository;
        this.defaultSchema = defaultSchema;
    }

    @Override
    public void endVisit(SQLSelectStatement x) {
        ViewRewriteRefAlias refAlias = new ViewRewriteRefAlias(this.newViewMap);
        x.getSelect().getQuery().accept(refAlias);
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        SQLExpr expr;
        String alias = x.getAlias();
        String alias2 = StringUtils.quoteAlias(alias);
        if (alias2 != alias) {
            x.setAlias(alias2);
        }
        if ((expr = x.getExpr()) instanceof SQLName && this.repository != null) {
            SchemaObject view;
            String name = ((SQLName)expr).getSimpleName();
            Schema schema = null;
            SQLTableSource resolvedTableSource = null;
            if (expr instanceof SQLIdentifierExpr) {
                resolvedTableSource = ((SQLIdentifierExpr)expr).getResolvedTableSource();
                schema = !StringUtils.isEmpty(this.defaultSchema) ? this.repository.findSchema(this.defaultSchema) : this.repository.getDefaultSchema();
            } else if (expr instanceof SQLPropertyExpr) {
                resolvedTableSource = ((SQLPropertyExpr)expr).getResolvedTableSource();
                schema = this.repository.findSchema(((SQLPropertyExpr)expr).getOwnernName());
            }
            if (resolvedTableSource == null && schema != null && x.getSchemaObject() == null && (view = schema.findView(name)) != null) {
                this.views.add(view);
                String viewName = this.buildViewName(view);
                this.viewMap.put(viewName, view);
                this.newViewMap.put(SQLUtils.normalize(name.toLowerCase()), viewName);
                SQLExprTableSource replaceTo = new SQLExprTableSource(viewName);
                replaceTo.setAlias(x.getAlias());
                SQLUtils.replaceInParent(x, replaceTo);
                SQLCreateViewStatement stmt = (SQLCreateViewStatement)view.getStatement();
                SQLSelect subQuery = stmt.getSubQuery();
                subQuery.getQuery().accept(this);
            }
        }
        return super.visit(x);
    }

    private String buildViewName(SchemaObject view) {
        StringBuilder viewName = new StringBuilder();
        String simpleName = view.getSchema().getSimpleName();
        if (!StringUtils.isEmpty(simpleName)) {
            long fnv32Lower = FnvHash.fnv_32_lower(simpleName);
            if (fnv32Lower < 0L) {
                fnv32Lower = -fnv32Lower;
            }
            viewName.append(simpleName);
            viewName.append("_");
            viewName.append(fnv32Lower);
            viewName.append("_");
        }
        viewName.append(view.getName());
        return SQLUtils.normalize(viewName.toString().toLowerCase());
    }

    @Override
    public boolean visit(SQLSelect x) {
        SQLWithSubqueryClause with = x.getWithSubQuery();
        if (with != null) {
            with.accept(this);
        }
        x.getQuery().accept(this);
        SQLWithSubqueryClause withSubQuery = null;
        SQLSelectStatement stmt = null;
        for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof SQLSelectStatement)) continue;
            stmt = (SQLSelectStatement)parent;
            break;
        }
        if (stmt == null) {
            return false;
        }
        withSubQuery = stmt.getSelect().getWithSubQuery();
        if (withSubQuery == null && this.views != null && this.views.size() > 0) {
            withSubQuery = new SQLWithSubqueryClause();
            stmt.getSelect().setWithSubQuery(withSubQuery);
        }
        for (int i = this.views.size() - 1; i >= 0; --i) {
            SQLSelect subQuery;
            SchemaObject view = this.views.get(i);
            String alias = this.newViewMap.get(view.getName().toLowerCase());
            if (withSubQuery.findEntry(FnvHash.fnv1a_64(alias)) != null) continue;
            SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
            SQLCreateViewStatement viewStatement = (SQLCreateViewStatement)view.getStatement();
            if (viewStatement.getColumns() != null) {
                for (SQLTableElement sQLTableElement : viewStatement.getColumns()) {
                    if (!(sQLTableElement instanceof SQLColumnDefinition)) continue;
                    entry.getColumns().add(((SQLColumnDefinition)sQLTableElement).getName());
                }
            }
            if ((subQuery = viewStatement.getSubQuery().clone()).getWithSubQuery() != null && subQuery.getWithSubQuery().getEntries().size() > 0) {
                for (SQLWithSubqueryClause.Entry item : subQuery.getWithSubQuery().getEntries()) {
                    SQLWithSubqueryClause.Entry clonedItem = item.clone();
                    if (withSubQuery.findEntry(item.aliasHashCode64()) != null) {
                        return false;
                    }
                    withSubQuery.addEntry(clonedItem);
                    this.visit(clonedItem.getSubQuery());
                    subQuery.setWithSubQuery(null);
                }
            }
            SchemaBuilderVisitor schemaBuilderVisitor = new SchemaBuilderVisitor(view);
            subQuery.accept(schemaBuilderVisitor);
            entry.setSubQuery(subQuery);
            entry.setAlias(alias);
            if (x.getParent() instanceof SQLWithSubqueryClause.Entry) {
                withSubQuery.getEntries().add(0, entry);
            } else {
                withSubQuery.getEntries().add(entry);
            }
            entry.setParent(withSubQuery);
        }
        return false;
    }

    class SchemaBuilderVisitor
    extends OptimizerVisitor {
        private SchemaObject view;

        public SchemaBuilderVisitor(SchemaObject view) {
            this.view = view;
        }

        @Override
        public boolean visit(SQLUnionQueryTableSource x) {
            x.getUnion().accept(this);
            return false;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            if (!StringUtils.isEmpty(x.getSchema())) {
                return false;
            }
            Schema schema = ViewRewriteWithSchema.this.repository.findSchema(x.getSchema());
            SchemaObject tableOrView = schema.findTableOrView(x.getTableName());
            if (tableOrView != null) {
                String tableSchemaSimpleName = tableOrView.getSchema().getSimpleName();
                if (StringUtils.isEmpty(tableSchemaSimpleName)) {
                    String viewSchemaSimple = this.view.getSchema().getSimpleName();
                    if (!StringUtils.isEmpty(viewSchemaSimple)) {
                        x.setSchema(viewSchemaSimple);
                    }
                } else {
                    x.setSchema(tableSchemaSimpleName);
                }
            }
            return false;
        }
    }
}

