/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.parser;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLDateExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLValuableExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.ads.parser.AdsStatementParser;
import com.alibaba.fastsql.sql.dialect.antspark.parser.AntsparkLexer;
import com.alibaba.fastsql.sql.dialect.antspark.parser.AntsparkStatementParser;
import com.alibaba.fastsql.sql.dialect.blink.parser.BlinkStatementParser;
import com.alibaba.fastsql.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.db2.parser.DB2ExprParser;
import com.alibaba.fastsql.sql.dialect.db2.parser.DB2Lexer;
import com.alibaba.fastsql.sql.dialect.db2.parser.DB2StatementParser;
import com.alibaba.fastsql.sql.dialect.h2.parser.H2ExprParser;
import com.alibaba.fastsql.sql.dialect.h2.parser.H2Lexer;
import com.alibaba.fastsql.sql.dialect.h2.parser.H2StatementParser;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.fastsql.sql.dialect.hive.parser.HiveStatementParser;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.fastsql.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.fastsql.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsLexer;
import com.alibaba.fastsql.sql.dialect.odps.parser.OdpsStatementParser;
import com.alibaba.fastsql.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.fastsql.sql.dialect.oracle.parser.OracleLexer;
import com.alibaba.fastsql.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.fastsql.sql.dialect.phoenix.parser.PhoenixExprParser;
import com.alibaba.fastsql.sql.dialect.phoenix.parser.PhoenixLexer;
import com.alibaba.fastsql.sql.dialect.phoenix.parser.PhoenixStatementParser;
import com.alibaba.fastsql.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.fastsql.sql.dialect.postgresql.parser.PGLexer;
import com.alibaba.fastsql.sql.dialect.postgresql.parser.PGSQLStatementParser;
import com.alibaba.fastsql.sql.dialect.presto.parser.PrestoExprParser;
import com.alibaba.fastsql.sql.dialect.presto.parser.PrestoLexer;
import com.alibaba.fastsql.sql.dialect.presto.parser.PrestoStatementParser;
import com.alibaba.fastsql.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.sqlserver.parser.SQLServerExprParser;
import com.alibaba.fastsql.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.alibaba.fastsql.sql.optimizer.rules.ConstFolding;
import com.alibaba.fastsql.sql.parser.Lexer;
import com.alibaba.fastsql.sql.parser.SQLExprParser;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLStatementParser;
import com.alibaba.fastsql.sql.parser.SQLType;
import com.alibaba.fastsql.sql.parser.Token;
import com.alibaba.fastsql.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.fastsql.sql.visitor.VisitorFeature;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.MySqlUtils;
import com.alibaba.fastsql.util.StringUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class SQLParserUtils {
    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType) {
        SQLParserFeature[] features = DbType.odps == dbType || DbType.mysql == dbType ? new SQLParserFeature[]{SQLParserFeature.KeepComments} : new SQLParserFeature[]{};
        return SQLParserUtils.createSQLStatementParser(sql, dbType, features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType, boolean keepComments) {
        SQLParserFeature[] features = keepComments ? new SQLParserFeature[]{SQLParserFeature.KeepComments} : new SQLParserFeature[]{};
        return SQLParserUtils.createSQLStatementParser(sql, dbType, features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, String dbType, SQLParserFeature ... features) {
        return SQLParserUtils.createSQLStatementParser(sql, dbType == null ? null : DbType.valueOf(dbType), features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: {
                return new OracleStatementParser(sql, features);
            }
            case mysql: 
            case mariadb: 
            case drds: {
                return new MySqlStatementParser(sql, features);
            }
            case elastic_search: {
                MySqlStatementParser parser = new MySqlStatementParser(sql, features);
                parser.dbType = dbType;
                parser.exprParser.dbType = dbType;
                return parser;
            }
            case postgresql: 
            case edb: {
                return new PGSQLStatementParser(sql, features);
            }
            case sqlserver: 
            case jtds: {
                return new SQLServerStatementParser(sql);
            }
            case h2: {
                return new H2StatementParser(sql, features);
            }
            case blink: {
                return new BlinkStatementParser(sql, features);
            }
            case db2: {
                return new DB2StatementParser(sql, features);
            }
            case odps: {
                return new OdpsStatementParser(sql, features);
            }
            case phoenix: {
                return new PhoenixStatementParser(sql);
            }
            case hive: {
                return new HiveStatementParser(sql, features);
            }
            case presto: {
                return new PrestoStatementParser(sql);
            }
            case ads: {
                return new AdsStatementParser(sql);
            }
            case antspark: {
                return new AntsparkStatementParser(sql);
            }
        }
        return new SQLStatementParser(sql, dbType);
    }

    public static SQLExprParser createExprParser(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: {
                return new OracleExprParser(sql, features);
            }
            case mysql: 
            case mariadb: {
                return new MySqlExprParser(sql, features);
            }
            case elastic_search: {
                MySqlExprParser parser = new MySqlExprParser(sql, features);
                parser.dbType = dbType;
                return parser;
            }
            case h2: {
                return new H2ExprParser(sql, features);
            }
            case postgresql: 
            case edb: {
                return new PGExprParser(sql, features);
            }
            case sqlserver: 
            case jtds: {
                return new SQLServerExprParser(sql, features);
            }
            case db2: {
                return new DB2ExprParser(sql, features);
            }
            case odps: {
                return new OdpsExprParser(sql, features);
            }
            case phoenix: {
                return new PhoenixExprParser(sql, features);
            }
            case presto: {
                return new PrestoExprParser(sql, features);
            }
            case hive: {
                return new HiveExprParser(sql, features);
            }
        }
        return new SQLExprParser(sql, dbType, features);
    }

    public static Lexer createLexer(String sql, DbType dbType) {
        return SQLParserUtils.createLexer(sql, dbType, new SQLParserFeature[0]);
    }

    public static Lexer createLexer(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: {
                return new OracleLexer(sql);
            }
            case mysql: 
            case mariadb: {
                return new MySqlLexer(sql);
            }
            case elastic_search: {
                MySqlLexer lexer = new MySqlLexer(sql);
                lexer.dbType = dbType;
                return lexer;
            }
            case h2: {
                return new H2Lexer(sql);
            }
            case postgresql: 
            case edb: {
                return new PGLexer(sql, new SQLParserFeature[0]);
            }
            case db2: {
                return new DB2Lexer(sql);
            }
            case odps: {
                return new OdpsLexer(sql, new SQLParserFeature[0]);
            }
            case phoenix: {
                return new PhoenixLexer(sql, new SQLParserFeature[0]);
            }
            case presto: {
                return new PrestoLexer(sql, new SQLParserFeature[0]);
            }
            case antspark: {
                return new AntsparkLexer(sql);
            }
        }
        return new Lexer(sql, null, dbType);
    }

    public static SQLSelectQueryBlock createSelectQueryBlock(DbType dbType) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case mysql: {
                return new MySqlSelectQueryBlock();
            }
            case oracle: {
                return new OracleSelectQueryBlock();
            }
            case db2: {
                return new DB2SelectQueryBlock();
            }
            case postgresql: {
                return new PGSelectQueryBlock();
            }
            case odps: {
                return new OdpsSelectQueryBlock();
            }
            case sqlserver: {
                return new SQLServerSelectQueryBlock();
            }
        }
        return new SQLSelectQueryBlock(dbType);
    }

    public static SQLType getSQLType(String sql, DbType dbType) {
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        return lexer.scanSQLType();
    }

    public static boolean startsWithHint(String sql, DbType dbType) {
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.nextToken();
        return lexer.token() == Token.HINT;
    }

    public static boolean containsAny(String sql, DbType dbType, Token token) {
        Token tok;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        do {
            lexer.nextToken();
            tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
        } while (tok != token);
        return true;
    }

    public static boolean containsAny(String sql, DbType dbType, Token token1, Token token2) {
        Token tok;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        do {
            lexer.nextToken();
            tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
        } while (tok != token1 && tok != token2);
        return true;
    }

    public static boolean containsAny(String sql, DbType dbType, Token token1, Token token2, Token token3) {
        Token tok;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        do {
            lexer.nextToken();
            tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
        } while (tok != token1 && tok != token2 && tok != token3);
        return true;
    }

    public static boolean containsAny(String sql, DbType dbType, Token ... tokens) {
        if (tokens == null) {
            return false;
        }
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        block3: while (true) {
            lexer.nextToken();
            Token tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
            int i = 0;
            while (true) {
                if (i >= tokens.length) continue block3;
                if (tokens[i] == tok) {
                    return true;
                }
                ++i;
            }
            break;
        }
    }

    public static Object getSimpleSelectValue(String sql, DbType dbType) {
        return SQLParserUtils.getSimpleSelectValue(sql, dbType, null);
    }

    public static Object getSimpleSelectValue(String sql, DbType dbType, SimpleValueEvalHandler handler) {
        Object value;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.nextToken();
        if (lexer.token != Token.SELECT && lexer.token != Token.VALUES) {
            return null;
        }
        lexer.nextTokenValue();
        SQLExpr expr = null;
        switch (lexer.token) {
            case LITERAL_INT: {
                value = lexer.integerValue();
                break;
            }
            case LITERAL_CHARS: 
            case LITERAL_NCHARS: {
                value = lexer.stringVal();
                break;
            }
            case LITERAL_FLOAT: {
                return lexer.decimalValue();
            }
            default: {
                if (handler == null) {
                    return null;
                }
                expr = new SQLExprParser(lexer).expr();
                try {
                    value = handler.eval(expr);
                    break;
                }
                catch (Exception error) {
                    value = null;
                }
            }
        }
        lexer.nextToken();
        if (lexer.token != Token.EOF) {
            return null;
        }
        return value;
    }

    public static String replaceBackQuote(String sql, DbType dbType) {
        int i = sql.indexOf(96);
        if (i == -1) {
            return sql;
        }
        char[] chars = sql.toCharArray();
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        int len = chars.length;
        int off = 0;
        block4: while (true) {
            lexer.nextToken();
            switch (lexer.token) {
                case IDENTIFIER: {
                    int p0 = lexer.startPos + off;
                    int p1 = lexer.pos - 1 + off;
                    char c0 = chars[p0];
                    char c1 = chars[p1];
                    if (c0 != '`' || c1 != '`') continue block4;
                    if (p1 - p0 > 2 && chars[p0 + 1] == '\'' && chars[p1 - 1] == '\'') {
                        System.arraycopy(chars, p0 + 1, chars, p0, p1 - p0 - 1);
                        System.arraycopy(chars, p1 + 1, chars, p1 - 1, chars.length - p1 - 1);
                        len -= 2;
                        off -= 2;
                        continue block4;
                    }
                    chars[p0] = 34;
                    chars[p1] = 34;
                    continue block4;
                }
                case EOF: 
                case ERROR: {
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
        return new String(chars, 0, len);
    }

    public static String addBackQuote(String sql, DbType dbType) {
        if (StringUtils.isEmpty(sql)) {
            return sql;
        }
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType);
        StringBuffer buf = new StringBuffer(sql.length() + 20);
        SQLASTOutputVisitor out = SQLUtils.createOutputVisitor(buf, DbType.mysql);
        out.config(VisitorFeature.OutputNameQuote, true);
        SQLType sqlType = SQLParserUtils.getSQLType(sql, dbType);
        if (sqlType == SQLType.INSERT) {
            parser.config(SQLParserFeature.InsertReader, true);
            SQLInsertStatement stmt = (SQLInsertStatement)parser.parseStatement();
            int startPos = parser.getLexer().startPos;
            stmt.accept(out);
            if (stmt.getQuery() == null) {
                buf.append(' ');
                buf.append(sql, startPos, sql.length());
            }
        } else {
            SQLStatement stmt = parser.parseStatement();
            stmt.accept(out);
        }
        return buf.toString();
    }

    public static class ConstFoldingEvalHandler
    implements SimpleValueEvalHandler {
        private TimeZone timeZone;
        private ConstFolding visitor;
        private final Map<Long, Object> functionMapping;

        public ConstFoldingEvalHandler(DbType dbType, TimeZone timeZone) {
            this(dbType, timeZone, new HashMap<Long, Object>());
        }

        public ConstFoldingEvalHandler(DbType dbType, TimeZone timeZone, Map<Long, Object> functionMapping) {
            this.timeZone = timeZone;
            this.visitor = new ConstFolding(dbType, timeZone, true);
            this.functionMapping = functionMapping;
        }

        public void setFunction(String functionName, Object value) {
            long hash = FnvHash.hashCode64(functionName);
            this.functionMapping.put(hash, value);
        }

        @Override
        public Object eval(SQLExpr expr) {
            long functionHashCode;
            Object value;
            SQLMethodInvokeExpr functionCall;
            if (expr instanceof SQLMethodInvokeExpr && (functionCall = (SQLMethodInvokeExpr)expr).getArguments().size() == 0 && (value = this.functionMapping.get(functionHashCode = functionCall.methodNameHashCode64())) != null) {
                return value;
            }
            SQLSelectItem selectItem = new SQLSelectItem(expr);
            selectItem.accept(this.visitor);
            SQLExpr valueExpr = selectItem.getExpr();
            if (valueExpr instanceof SQLDateExpr) {
                String literal = ((SQLDateExpr)valueExpr).getLiteral();
                return Date.valueOf(literal);
            }
            if (valueExpr instanceof SQLTimestampExpr) {
                String literal = ((SQLTimestampExpr)valueExpr).getLiteral();
                return new Timestamp(MySqlUtils.parseDate(literal, this.timeZone).getTime());
            }
            if (valueExpr instanceof SQLValuableExpr) {
                return ((SQLValuableExpr)valueExpr).getValue();
            }
            return null;
        }
    }

    public static interface SimpleValueEvalHandler {
        public Object eval(SQLExpr var1);
    }
}

