/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.support.protobuf;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.parser.SQLInsertValueHandler;
import com.alibaba.fastsql.support.protobuf.InvalidValueException;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.MySqlUtils;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

public abstract class ProtobufInsertValueHandler
implements SQLInsertValueHandler {
    protected DbType dbType;
    protected final Descriptors.Descriptor descriptor;
    protected TimeZone timeZone;

    public ProtobufInsertValueHandler(Descriptors.Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ProtobufInsertValueHandler(Descriptors.Descriptor descriptor, TimeZone timeZone) {
        this.descriptor = descriptor;
        this.timeZone = timeZone;
    }

    public ProtobufInsertValueHandler(DbType dbType, Descriptors.Descriptor descriptor, TimeZone timeZone) {
        this.dbType = dbType;
        this.descriptor = descriptor;
        this.timeZone = timeZone;
    }

    @Override
    public Object newRow() throws SQLException {
        return DynamicMessage.newBuilder((Descriptors.Descriptor)this.descriptor);
    }

    protected abstract Descriptors.FieldDescriptor getField(int var1) throws SQLException;

    @Override
    public void processInteger(Object row, int index, Number number) throws SQLException {
        DynamicMessage.Builder msgBuilder = (DynamicMessage.Builder)row;
        Descriptors.FieldDescriptor field = this.getField(index);
        Descriptors.FieldDescriptor.Type fieldType = field.getType();
        switch (fieldType) {
            case INT32: {
                Integer intValue = null;
                if (!(number instanceof Integer)) {
                    throw new InvalidValueException("int value over flow", field.getName(), number.toString());
                }
                intValue = (Integer)number;
                msgBuilder.setFieldDirect(field, (Object)intValue);
                break;
            }
            case INT64: {
                Long longValue = null;
                if (number instanceof Integer) {
                    longValue = number.longValue();
                } else if (number instanceof Long) {
                    longValue = (Long)number;
                } else {
                    throw new InvalidValueException("int value over flow", field.getName(), number.toString());
                }
                msgBuilder.setFieldDirect(field, (Object)longValue);
                break;
            }
            case FLOAT: {
                msgBuilder.setFieldDirect(field, (Object)Float.valueOf(number.floatValue()));
                break;
            }
            case DOUBLE: {
                msgBuilder.setFieldDirect(field, (Object)number.doubleValue());
                break;
            }
            case JSON: 
            case STRING: {
                msgBuilder.setFieldDirect(field, (Object)number.toString());
                break;
            }
            case BOOL: {
                if (number instanceof Integer) {
                    int intValue = number.intValue();
                    if (intValue == 1) {
                        msgBuilder.setFieldDirect(field, (Object)true);
                        break;
                    }
                    if (intValue == 0) {
                        msgBuilder.setFieldDirect(field, (Object)false);
                        break;
                    }
                    throw new InvalidValueException("can not cast to boolean", field.getName(), number.toString());
                }
                throw new InvalidValueException("can not cast to boolean", field.getName(), number.toString());
            }
            default: {
                throw new InvalidValueException("type convert not support : " + fieldType, field.getName(), number.toString());
            }
        }
    }

    @Override
    public void processString(Object row, int index, String strVal) throws SQLException {
        DynamicMessage.Builder msgBuilder = (DynamicMessage.Builder)row;
        Descriptors.FieldDescriptor field = this.getField(index);
        Descriptors.FieldDescriptor.Type fieldType = field.getType();
        switch (fieldType) {
            case INT32: {
                int intValue;
                try {
                    intValue = Integer.parseInt(strVal);
                }
                catch (NumberFormatException e) {
                    throw new InvalidValueException("type convert parseLong error", field.getName(), strVal);
                }
                msgBuilder.setFieldDirect(field, (Object)intValue);
                break;
            }
            case INT64: {
                long longValue;
                try {
                    longValue = Long.parseLong(strVal);
                }
                catch (NumberFormatException e) {
                    throw new InvalidValueException("type convert parseLong error", field.getName(), strVal);
                }
                msgBuilder.setFieldDirect(field, (Object)longValue);
                break;
            }
            case FLOAT: {
                float floatValue;
                try {
                    floatValue = Float.parseFloat(strVal);
                }
                catch (NumberFormatException e) {
                    throw new InvalidValueException("type convert parseLong error", field.getName(), strVal);
                }
                msgBuilder.setFieldDirect(field, (Object)Float.valueOf(floatValue));
                break;
            }
            case DOUBLE: {
                double doubleValue;
                try {
                    doubleValue = Double.parseDouble(strVal);
                }
                catch (NumberFormatException e) {
                    throw new InvalidValueException("type convert parseLong error", field.getName(), strVal);
                }
                msgBuilder.setFieldDirect(field, (Object)doubleValue);
                break;
            }
            case JSON: {
                msgBuilder.setFieldDirect(field, (Object)strVal);
                break;
            }
            case STRING: {
                msgBuilder.setFieldDirect(field, (Object)strVal);
                break;
            }
            case TIME: {
                Date datetime = MySqlUtils.parseDate(strVal, this.timeZone);
                if (datetime != null) {
                    this.processTime(row, index, datetime);
                    break;
                }
                if (strVal.equals("0000-00-00 00:00:00") || strVal.equals("0000-00-00") || strVal.equals("00:00:00")) {
                    this.processTime(row, index, new Date(0L));
                    break;
                }
                this.processIllegalTimestamp(field, strVal);
                break;
            }
            case DATE: {
                Date datetime = MySqlUtils.parseDate(strVal, this.timeZone);
                if (datetime != null) {
                    this.processDate(row, index, datetime);
                    break;
                }
                if (strVal.equals("0000-00-00 00:00:00") || strVal.equals("0000-00-00") || strVal.equals("00:00:00")) {
                    this.processDate(row, index, new Date(0L));
                    break;
                }
                this.processIllegalTimestamp(field, strVal);
                break;
            }
            case TIMESTAMP: {
                Date datetime = MySqlUtils.parseDate(strVal, this.timeZone);
                if (datetime != null) {
                    msgBuilder.setFieldDirect(field, (Object)((int)(datetime.getTime() / 1000L)));
                    break;
                }
                if (strVal.equals("0000-00-00 00:00:00") || strVal.equals("0000-00-00") || strVal.equals("00:00:00")) {
                    msgBuilder.setFieldDirect(field, (Object)0);
                    break;
                }
                this.processIllegalTimestamp(field, strVal);
                break;
            }
            case DATETIME: {
                Date datetime = MySqlUtils.parseDate(strVal, this.timeZone);
                if (datetime != null) {
                    msgBuilder.setFieldDirect(field, (Object)((int)(datetime.getTime() / 1000L)));
                    break;
                }
                this.processIllegalTimestamp(field, strVal);
                break;
            }
            case BOOL: {
                if (strVal.equalsIgnoreCase("true") || strVal.equalsIgnoreCase("Y") || strVal.equalsIgnoreCase("1")) {
                    msgBuilder.setFieldDirect(field, (Object)true);
                    break;
                }
                if (strVal.equalsIgnoreCase("false") || strVal.equalsIgnoreCase("N") || strVal.equalsIgnoreCase("0")) {
                    msgBuilder.setFieldDirect(field, (Object)false);
                    break;
                }
                throw new InvalidValueException("type convert not support : " + fieldType, field.getName(), strVal);
            }
            case BYTES: {
                break;
            }
            default: {
                throw new InvalidValueException("type convert not support : " + fieldType, field.getName(), strVal);
            }
        }
    }

    protected void processIllegalTimestamp(Descriptors.FieldDescriptor field, String value) throws SQLException {
        throw new InvalidValueException("type convert not support : Timestamp", field.getName(), value);
    }

    @Override
    public void processDate(Object row, int index, String value) throws SQLException {
        this.processString(row, index, value);
    }

    public void processTime(Object row, int index, Date value) throws SQLException {
        Calendar cale = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
        int hour = cale.get(11);
        int minute = cale.get(12);
        int second = cale.get(13);
        char[] chars = new char[10];
        chars[0] = (char)(hour / 10 + 48);
        chars[1] = (char)(hour % 10 + 48);
        chars[2] = 58;
        chars[3] = (char)(minute / 10 + 48);
        chars[4] = (char)(minute % 10 + 48);
        chars[5] = 58;
        chars[6] = (char)(second / 10 + 48);
        chars[7] = (char)(second % 10 + 48);
        DynamicMessage.Builder msgBuilder = (DynamicMessage.Builder)row;
        Descriptors.FieldDescriptor field = this.getField(index);
        String strVal = new String(chars);
        msgBuilder.setFieldDirect(field, (Object)strVal);
    }

    @Override
    public void processDate(Object row, int index, Date value) throws SQLException {
        Calendar cale = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
        cale.setTime(value);
        int year = cale.get(1);
        int month = cale.get(2) + 1;
        int dayOfMonth = cale.get(5);
        char[] chars = new char[]{(char)(year / 1000 + 48), (char)(year / 100 % 10 + 48), (char)(year / 10 % 10 + 48), (char)(year % 10 + 48), '-', (char)(month / 10 + 48), (char)(month % 10 + 48), '-', (char)(dayOfMonth / 10 + 48), (char)(dayOfMonth % 10 + 48)};
        DynamicMessage.Builder msgBuilder = (DynamicMessage.Builder)row;
        Descriptors.FieldDescriptor field = this.getField(index);
        String strVal = new String(chars);
        msgBuilder.setFieldDirect(field, (Object)strVal);
    }

    @Override
    public void processTimestamp(Object row, int index, String value) throws SQLException {
        this.processString(row, index, value);
    }

    @Override
    public void processTimestamp(Object row, int index, Date value) throws SQLException {
        Calendar cale = this.timeZone == null ? Calendar.getInstance() : Calendar.getInstance(this.timeZone);
        cale.setTime(value);
        int year = cale.get(1);
        int month = cale.get(2) + 1;
        int dayOfMonth = cale.get(5);
        int hour = cale.get(11);
        int minute = cale.get(12);
        int second = cale.get(13);
        char[] chars = new char[]{(char)(year / 1000 + 48), (char)(year / 100 % 10 + 48), (char)(year / 10 % 10 + 48), (char)(year % 10 + 48), '-', (char)(month / 10 + 48), (char)(month % 10 + 48), '-', (char)(dayOfMonth / 10 + 48), (char)(dayOfMonth % 10 + 48), ' ', (char)(hour / 10 + 48), (char)(hour % 10 + 48), ':', (char)(minute / 10 + 48), (char)(minute % 10 + 48), ':', (char)(second / 10 + 48), (char)(second % 10 + 48)};
        String strVal = new String(chars);
        this.processString(row, index, strVal);
    }

    @Override
    public void processTime(Object row, int index, String value) throws SQLException {
        this.processString(row, index, value);
    }

    @Override
    public void processDecimal(Object row, int index, BigDecimal value) throws SQLException {
        DynamicMessage.Builder msgBuilder = (DynamicMessage.Builder)row;
        Descriptors.FieldDescriptor field = this.getField(index);
        Descriptors.FieldDescriptor.Type fieldType = field.getType();
        switch (fieldType) {
            case INT32: {
                int intValue;
                try {
                    intValue = value.intValue();
                }
                catch (NumberFormatException e) {
                    throw new InvalidValueException("type convert parseInt error", field.getName(), value.toString());
                }
                msgBuilder.setFieldDirect(field, (Object)intValue);
                break;
            }
            case INT64: {
                long longValue;
                try {
                    longValue = value.longValue();
                }
                catch (NumberFormatException e) {
                    throw new InvalidValueException("type convert parseLong error", field.getName(), value.toString());
                }
                msgBuilder.setFieldDirect(field, (Object)longValue);
                break;
            }
            case FLOAT: {
                float floatValue;
                try {
                    floatValue = value.floatValue();
                }
                catch (NumberFormatException e) {
                    throw new InvalidValueException("type convert parseFloat error", field.getName(), value.toString());
                }
                msgBuilder.setFieldDirect(field, (Object)Float.valueOf(floatValue));
                break;
            }
            case DOUBLE: {
                double doubleValue;
                try {
                    doubleValue = value.doubleValue();
                }
                catch (NumberFormatException e) {
                    throw new InvalidValueException("type convert parseDouble error", field.getName(), value.toString());
                }
                msgBuilder.setFieldDirect(field, (Object)doubleValue);
                break;
            }
            case STRING: {
                msgBuilder.setFieldDirect(field, (Object)value.toString());
                break;
            }
            default: {
                throw new InvalidValueException("type convert not support : " + fieldType, field.getName(), value.toString());
            }
        }
    }

    @Override
    public void processBoolean(Object row, int index, boolean value) throws SQLException {
        DynamicMessage.Builder msgBuilder = (DynamicMessage.Builder)row;
        Descriptors.FieldDescriptor field = this.getField(index);
        Descriptors.FieldDescriptor.Type fieldType = field.getType();
        switch (fieldType) {
            case INT32: 
            case INT64: {
                int intValue = value ? 1 : 0;
                msgBuilder.setFieldDirect(field, (Object)intValue);
                break;
            }
            case STRING: {
                msgBuilder.setFieldDirect(field, (Object)Boolean.toString(value));
                break;
            }
            case BOOL: {
                msgBuilder.setFieldDirect(field, (Object)value);
                break;
            }
            default: {
                throw new InvalidValueException("type convert not support : " + fieldType, field.getName(), Boolean.toString(value));
            }
        }
    }

    @Override
    public void processNull(Object row, int index) throws SQLException {
    }

    protected SQLException processValueError(Descriptors.FieldDescriptor field, SQLException ex) {
        return ex;
    }

    @Override
    public void processFunction(Object row, int index, String funcName, long funcNameHashCode64, Object ... values) throws SQLException {
        if (funcNameHashCode64 == FnvHash.Constants.UUID) {
            String uuid = UUID.randomUUID().toString();
            this.processString(row, index, uuid);
            return;
        }
        if ((funcNameHashCode64 == FnvHash.Constants.STR_TO_DATE || funcNameHashCode64 == FnvHash.Constants.DATE_PARSE) && values.length == 2) {
            String str = (String)values[0];
            String fmt = (String)values[1];
            DateFormat dateFormat = MySqlUtils.toJavaFormat(fmt, this.timeZone);
            if (dateFormat != null) {
                try {
                    Date date = dateFormat.parse(str);
                    this.processDate(row, index, date);
                    return;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        Descriptors.FieldDescriptor field = this.getField(index);
        throw new InvalidValueException("insert value not support function : " + funcName, field.getName(), funcName);
    }

    @Override
    public void processRow(Object row) throws SQLException {
    }

    @Override
    public void processComplete() throws SQLException {
    }
}

