/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.util;

public class IpUtils {
    public static String ipInt2DotDec(int ipInt) throws IllegalArgumentException {
        return IpUtils.ipLong2DotDec((long)ipInt & 0xFFFFFFFFL);
    }

    public static String ipLong2DotDec(long ipLong) throws IllegalArgumentException {
        if (ipLong < 0L) {
            throw new IllegalArgumentException("argument must be positive");
        }
        if (ipLong > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("argument must be smaller than 4294967295L");
        }
        StringBuffer sb = new StringBuffer(15);
        sb.append((int)(ipLong >>> 24));
        sb.append('.');
        sb.append((int)((ipLong & 0xFFFFFFL) >>> 16));
        sb.append('.');
        sb.append((int)((ipLong & 0xFFFFL) >>> 8));
        sb.append('.');
        sb.append((int)(ipLong & 0xFFL));
        return sb.toString();
    }

    static int number(char ch) {
        int val = ch - 48;
        if (val < 0 || val > 9) {
            throw new IllegalArgumentException();
        }
        return val;
    }

    public static int ipDotDec2Int(String ip) {
        if (ip == null || ip.length() == 0) {
            throw new IllegalArgumentException("argument is null");
        }
        if (ip.length() > 15) {
            throw new IllegalArgumentException("illegal ip : " + ip);
        }
        int i = 0;
        char ch = ip.charAt(i++);
        while (ch == ' ' && i < ip.length()) {
            ch = ip.charAt(i++);
        }
        int p0 = IpUtils.number(ch);
        if ((ch = ip.charAt(i++)) != '.') {
            p0 = p0 * 10 + IpUtils.number(ch);
            ch = ip.charAt(i++);
        }
        if (ch != '.') {
            p0 = p0 * 10 + IpUtils.number(ch);
            ch = ip.charAt(i++);
        }
        if (ch != '.') {
            throw new IllegalArgumentException("illegal ip : " + ip);
        }
        ch = ip.charAt(i++);
        int p1 = IpUtils.number(ch);
        if ((ch = ip.charAt(i++)) != '.') {
            p1 = p1 * 10 + IpUtils.number(ch);
            ch = ip.charAt(i++);
        }
        if (ch != '.') {
            p1 = p1 * 10 + IpUtils.number(ch);
            ch = ip.charAt(i++);
        }
        if (ch != '.') {
            throw new IllegalArgumentException("illegal ip : " + ip);
        }
        ch = ip.charAt(i++);
        int p2 = IpUtils.number(ch);
        if ((ch = ip.charAt(i++)) != '.') {
            p2 = p2 * 10 + IpUtils.number(ch);
            ch = ip.charAt(i++);
        }
        if (ch != '.') {
            p2 = p2 * 10 + IpUtils.number(ch);
            ch = ip.charAt(i++);
        }
        if (ch != '.') {
            throw new IllegalArgumentException("illegal ip : " + ip);
        }
        ch = ip.charAt(i++);
        int p3 = IpUtils.number(ch);
        if (i < ip.length()) {
            ch = ip.charAt(i++);
            p3 = p3 * 10 + IpUtils.number(ch);
        }
        if (i < ip.length()) {
            ch = ip.charAt(i++);
            p3 = p3 * 10 + IpUtils.number(ch);
        }
        return (p0 << 24) + (p1 << 16) + (p2 << 8) + p3;
    }

    public static long ipDotDec2Long(String ipDotDec) throws IllegalArgumentException {
        int intValue = IpUtils.ipDotDec2Int(ipDotDec);
        return (long)intValue & 0xFFFFFFFFL;
    }

    public static String ipHex2DotDec(String ipHex) throws IllegalArgumentException {
        if (ipHex == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if ((ipHex = ipHex.trim()).length() != 8 && ipHex.length() != 7) {
            throw new IllegalArgumentException("argument is: " + ipHex);
        }
        long ipLong = Long.parseLong(ipHex, 16);
        return IpUtils.ipLong2DotDec(ipLong);
    }

    public static String ipDotDec2Hex(String ipDotDec) throws IllegalArgumentException {
        long ipLong = IpUtils.ipDotDec2Long(ipDotDec);
        String ipHex = Long.toHexString(ipLong);
        if (ipHex.length() < 8) {
            ipHex = "0" + ipHex;
        }
        return ipHex;
    }
}

