/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.util;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.support.logging.Log;
import com.alibaba.fastsql.support.logging.LogFactory;
import com.alibaba.fastsql.util.JdbcUtils;
import com.alibaba.fastsql.util.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OracleUtils {
    private static final Log LOG = LogFactory.getLog(OracleUtils.class);
    private static Set<String> builtinFunctions;
    private static Set<String> builtinTables;
    private static Set<String> keywords;

    public static boolean isBuiltinFunction(String function) {
        if (function == null) {
            return false;
        }
        String function_lower = function.toLowerCase();
        Set<String> functions = builtinFunctions;
        if (functions == null) {
            functions = new HashSet<String>();
            Utils.loadFromFile("META-INF/fastsql/parser/oracle/builtin_functions", functions);
            builtinFunctions = functions;
        }
        return functions.contains(function_lower);
    }

    public static boolean isBuiltinTable(String table) {
        if (table == null) {
            return false;
        }
        String table_lower = table.toLowerCase();
        Set<String> tables = builtinTables;
        if (tables == null) {
            tables = new HashSet<String>();
            Utils.loadFromFile("META-INF/fastsql/parser/oracle/builtin_tables", tables);
            builtinTables = tables;
        }
        return tables.contains(table_lower);
    }

    public static boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        String name_lower = name.toLowerCase();
        Set<String> words = keywords;
        if (words == null) {
            words = new HashSet<String>();
            Utils.loadFromFile("META-INF/fastsql/parser/oracle/keywords", words);
            keywords = words;
        }
        return words.contains(name_lower);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> showTables(Connection conn) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select table_name from user_tables");
            while (rs.next()) {
                String tableName = rs.getString(1);
                tables.add(tableName);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        return tables;
    }

    public static List<String> getTableDDL(Connection conn, String ... tables) throws SQLException {
        return OracleUtils.getTableDDL(conn, Arrays.asList(tables));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTableDDL(Connection conn, List<String> tables) throws SQLException {
        ArrayList<String> ddlList = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int i;
            String sql = "select DBMS_METADATA.GET_DDL('TABLE', TABLE_NAME) FROM user_tables";
            if (tables.size() > 0) {
                sql = sql + "IN (";
                for (i = 0; i < tables.size(); ++i) {
                    sql = i != 0 ? sql + ", ?" : sql + "?";
                }
                sql = sql + ")";
            }
            pstmt = conn.prepareStatement(sql);
            for (i = 0; i < tables.size(); ++i) {
                pstmt.setString(i + 1, tables.get(i));
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String ddl = rs.getString(1);
                ddlList.add(ddl);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(pstmt);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(pstmt);
        return ddlList;
    }

    public static String getCreateTableScript(Connection conn) throws SQLException {
        return OracleUtils.getCreateTableScript(conn, true, true);
    }

    public static String getCreateTableScript(Connection conn, boolean sorted, boolean simplify) throws SQLException {
        List<String> ddlList = OracleUtils.getTableDDL(conn, new String[0]);
        StringBuilder buf = new StringBuilder();
        for (String ddl : ddlList) {
            buf.append(ddl);
            buf.append(';');
        }
        String ddlScript = buf.toString();
        if (!sorted && !simplify) {
            return ddlScript;
        }
        List<SQLStatement> stmtList = SQLUtils.parseStatements(ddlScript, DbType.oracle, new SQLParserFeature[0]);
        if (simplify) {
            for (SQLStatement o : stmtList) {
                if (!(o instanceof SQLCreateTableStatement)) continue;
                SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)o;
                createTableStmt.simplify();
            }
        }
        if (sorted) {
            SQLCreateTableStatement.sort(stmtList);
        }
        return SQLUtils.toSQLString(stmtList, DbType.oracle);
    }
}

