/*
 * Decompiled with CFR 0.152.
 */
package com.anji.captcha.service.impl;

import com.anji.captcha.model.common.RepCodeEnum;
import com.anji.captcha.model.common.ResponseModel;
import com.anji.captcha.model.vo.CaptchaVO;
import com.anji.captcha.service.CaptchaCacheService;
import com.anji.captcha.service.CaptchaService;
import com.anji.captcha.service.impl.CaptchaServiceFactory;
import com.anji.captcha.service.impl.FrequencyLimitHandler;
import com.anji.captcha.util.AESUtil;
import com.anji.captcha.util.CacheUtil;
import com.anji.captcha.util.ImageUtils;
import com.anji.captcha.util.MD5Util;
import com.anji.captcha.util.StringUtils;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCaptchaService
implements CaptchaService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String IMAGE_TYPE_PNG = "png";
    protected static int HAN_ZI_SIZE = 25;
    protected static int HAN_ZI_SIZE_HALF = HAN_ZI_SIZE / 2;
    protected static String REDIS_CAPTCHA_KEY = "RUNNING:CAPTCHA:%s";
    protected static String REDIS_SECOND_CAPTCHA_KEY = "RUNNING:CAPTCHA:second-%s";
    protected static Long EXPIRESIN_SECONDS = 120L;
    protected static Long EXPIRESIN_THREE = 180L;
    protected static String waterMark = "\u6211\u7684\u6c34\u5370";
    protected static String waterMarkFontStr = "WenQuanZhengHei.ttf";
    protected Font waterMarkFont;
    protected static String slipOffset = "5";
    protected static Boolean captchaAesStatus = true;
    protected static String clickWordFontStr = "WenQuanZhengHei.ttf";
    protected Font clickWordFont;
    protected static String cacheType = "local";
    protected static int captchaInterferenceOptions = 0;
    private static FrequencyLimitHandler limitHandler;

    @Override
    public void init(final Properties config) {
        boolean aBoolean = Boolean.parseBoolean(config.getProperty("captcha.init.original"));
        if (!aBoolean) {
            ImageUtils.cacheImage(config.getProperty("captcha.captchaOriginalPath.jigsaw"), config.getProperty("captcha.captchaOriginalPath.pic-click"), config.getProperty("captcha.captchaOriginalPath.rotate"));
        }
        this.logger.info("--->>>\u521d\u59cb\u5316\u9a8c\u8bc1\u7801\u5e95\u56fe<<<---" + this.captchaType());
        waterMark = config.getProperty("captcha.water.mark", "\u6211\u7684\u6c34\u5370");
        slipOffset = config.getProperty("captcha.slip.offset", "5");
        waterMarkFontStr = config.getProperty("captcha.water.font", "WenQuanZhengHei.ttf");
        captchaAesStatus = Boolean.parseBoolean(config.getProperty("captcha.aes.status", "true"));
        clickWordFontStr = config.getProperty("captcha.font.type", "WenQuanZhengHei.ttf");
        cacheType = config.getProperty("captcha.cacheType", "local");
        captchaInterferenceOptions = Integer.parseInt(config.getProperty("captcha.interference.options", "0"));
        this.loadWaterMarkFont();
        if (cacheType.equals("local")) {
            this.logger.info("\u521d\u59cb\u5316local\u7f13\u5b58...");
            CacheUtil.init(Integer.parseInt(config.getProperty("captcha.cache.number", "1000")), Long.parseLong(config.getProperty("captcha.timing.clear", "180")));
        }
        if (config.getProperty("captcha.history.data.clear.enable", "0").equals("1")) {
            this.logger.info("\u5386\u53f2\u8d44\u6e90\u6e05\u9664\u5f00\u5173...\u5f00\u542f..." + this.captchaType());
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    AbstractCaptchaService.this.destroy(config);
                }
            }));
        }
        if (config.getProperty("captcha.req.frequency.limit.enable", "0").equals("1") && limitHandler == null) {
            this.logger.info("\u63a5\u53e3\u5206\u949f\u5185\u9650\u6d41\u5f00\u5173...\u5f00\u542f...");
            limitHandler = new FrequencyLimitHandler.DefaultLimitHandler(config, this.getCacheService(cacheType));
        }
    }

    protected CaptchaCacheService getCacheService(String cacheType) {
        return CaptchaServiceFactory.getCache(cacheType);
    }

    @Override
    public void destroy(Properties config) {
    }

    @Override
    public ResponseModel get(CaptchaVO captchaVO) {
        if (limitHandler != null) {
            captchaVO.setClientUid(this.getValidateClientId(captchaVO));
            return limitHandler.validateGet(captchaVO);
        }
        return null;
    }

    @Override
    public ResponseModel check(CaptchaVO captchaVO) {
        if (limitHandler != null) {
            captchaVO.setClientUid(this.getValidateClientId(captchaVO));
            return limitHandler.validateCheck(captchaVO);
        }
        return null;
    }

    @Override
    public ResponseModel verification(CaptchaVO captchaVO) {
        if (captchaVO == null) {
            return RepCodeEnum.NULL_ERROR.parseError("captchaVO");
        }
        if (StringUtils.isEmpty(captchaVO.getCaptchaVerification())) {
            return RepCodeEnum.NULL_ERROR.parseError("captchaVerification");
        }
        if (limitHandler != null) {
            return limitHandler.validateVerify(captchaVO);
        }
        return null;
    }

    protected boolean validatedReq(ResponseModel resp) {
        return resp == null || resp.isSuccess();
    }

    protected String getValidateClientId(CaptchaVO req) {
        if (StringUtils.isNotEmpty(req.getBrowserInfo())) {
            return MD5Util.md5(req.getBrowserInfo());
        }
        if (StringUtils.isNotEmpty(req.getClientUid())) {
            return req.getClientUid();
        }
        return null;
    }

    protected void afterValidateFail(CaptchaVO data) {
        if (limitHandler != null) {
            String fails = String.format("AJ.CAPTCHA.REQ.LIMIT-%s-%s", "FAIL", data.getClientUid());
            CaptchaCacheService cs = this.getCacheService(cacheType);
            boolean getCountsKeyExists = cs.exists(fails);
            if (!getCountsKeyExists) {
                cs.set(fails, "1", 60L);
            }
            cs.increment(fails, 1L);
        }
    }

    private void loadWaterMarkFont() {
        try {
            this.waterMarkFont = waterMarkFontStr.toLowerCase().endsWith(".ttf") || waterMarkFontStr.toLowerCase().endsWith(".ttc") || waterMarkFontStr.toLowerCase().endsWith(".otf") ? Font.createFont(0, this.getClass().getResourceAsStream("/fonts/" + waterMarkFontStr)).deriveFont(1, HAN_ZI_SIZE / 2) : new Font(waterMarkFontStr, 1, HAN_ZI_SIZE / 2);
        }
        catch (Exception e) {
            this.logger.error("load font error:", (Throwable)e);
        }
    }

    public static boolean base64StrToImage(String imgStr, String path) {
        if (imgStr == null) {
            return false;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        try {
            byte[] b = decoder.decode(imgStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            File tempFile = new File(path);
            if (!tempFile.getParentFile().exists()) {
                tempFile.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(tempFile);
            ((OutputStream)out).write(b);
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String decrypt(String point, String key) throws Exception {
        return AESUtil.aesDecrypt(point, key);
    }

    protected static int getEnOrChLength(String s) {
        int enCount = 0;
        int chCount = 0;
        for (int i = 0; i < s.length(); ++i) {
            int length = String.valueOf(s.charAt(i)).getBytes(StandardCharsets.UTF_8).length;
            if (length > 1) {
                ++chCount;
                continue;
            }
            ++enCount;
        }
        int chOffset = HAN_ZI_SIZE / 2 * chCount + 5;
        int enOffset = enCount * 8;
        return chOffset + enOffset;
    }
}

