/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.tx;

import com.baomidou.dynamic.datasource.toolkit.DsStrUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.transaction.support.TransactionSynchronization;

public class TransactionContext {
    private static final ThreadLocal<String> CONTEXT_HOLDER = new ThreadLocal();
    private static final ThreadLocal<Set<TransactionSynchronization>> SYNCHRONIZATION_HOLDER = ThreadLocal.withInitial(LinkedHashSet::new);

    public static String getXID() {
        String xid = CONTEXT_HOLDER.get();
        if (!DsStrUtils.isEmpty((String)xid)) {
            return xid;
        }
        return null;
    }

    public static String unbind(String xid) {
        CONTEXT_HOLDER.remove();
        return xid;
    }

    public static String bind(String xid) {
        CONTEXT_HOLDER.set(xid);
        return xid;
    }

    public static void remove() {
        CONTEXT_HOLDER.remove();
    }

    public static void registerSynchronization(TransactionSynchronization synchronization) {
        if (Objects.isNull(synchronization)) {
            throw new IllegalArgumentException("TransactionSynchronization must not be null");
        }
        if (DsStrUtils.isEmpty((String)TransactionContext.getXID())) {
            throw new IllegalStateException("Transaction is not active");
        }
        Set<TransactionSynchronization> synchs = SYNCHRONIZATION_HOLDER.get();
        synchs.add(synchronization);
    }

    public static List<TransactionSynchronization> getSynchronizations() {
        Set<TransactionSynchronization> synchs = SYNCHRONIZATION_HOLDER.get();
        if (synchs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TransactionSynchronization> sortedSynchs = new ArrayList<TransactionSynchronization>(synchs);
        AnnotationAwareOrderComparator.sort(sortedSynchs);
        return Collections.unmodifiableList(sortedSynchs);
    }

    public static void removeSynchronizations() {
        SYNCHRONIZATION_HOLDER.remove();
    }
}

