/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core;

import com.wechat.pay.java.core.AbstractRSAConfig;
import com.wechat.pay.java.core.AbstractRSAConfigBuilder;
import com.wechat.pay.java.core.certificate.CertificateProvider;
import com.wechat.pay.java.core.certificate.InMemoryCertificateProvider;
import com.wechat.pay.java.core.util.PemUtil;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RSAConfig
extends AbstractRSAConfig {
    private RSAConfig(String merchantId, PrivateKey privateKey, String merchantSerialNumber, CertificateProvider certificateProvider) {
        super(merchantId, privateKey, merchantSerialNumber, certificateProvider);
    }

    public static class Builder
    extends AbstractRSAConfigBuilder<Builder> {
        private List<X509Certificate> wechatPayCertificates;

        @Override
        protected Builder self() {
            return this;
        }

        public Builder wechatPayCertificates(String ... wechatPayCertificates) {
            this.wechatPayCertificates = new ArrayList<X509Certificate>();
            for (String certificate : wechatPayCertificates) {
                X509Certificate x509Certificate = PemUtil.loadX509FromString(certificate);
                if (x509Certificate == null) continue;
                this.wechatPayCertificates.add(x509Certificate);
            }
            return this;
        }

        public Builder wechatPayCertificatesFromPath(String ... certPaths) {
            this.wechatPayCertificates = new ArrayList<X509Certificate>();
            for (String certPath : certPaths) {
                X509Certificate x509Certificate = PemUtil.loadX509FromPath(certPath);
                if (x509Certificate == null) continue;
                this.wechatPayCertificates.add(x509Certificate);
            }
            return this;
        }

        public RSAConfig build() {
            return new RSAConfig(Objects.requireNonNull(this.merchantId), Objects.requireNonNull(this.privateKey), Objects.requireNonNull(this.merchantSerialNumber), new InMemoryCertificateProvider(Objects.requireNonNull(this.wechatPayCertificates)));
        }
    }
}

