/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.enums;

import com.xkzhangsan.time.constants.Constant;
import com.xkzhangsan.time.converter.DateTimeConverterUtil;
import java.time.LocalTime;
import java.util.Date;
import java.util.Objects;

public enum TwelveTwoEnum {
    ZISHI(1, "\u5b50\u65f6", "23:00:00", "01:00:00"),
    CHOUSHI(2, "\u4e11\u65f6", "01:00:00", "03:00:00"),
    YINSHI(3, "\u5bc5\u65f6", "03:00:00", "05:00:00"),
    MAOSHI(4, "\u536f\u8fb0", "05:00:00", "07:00:00"),
    CHENSHI(5, "\u8fb0\u65f6", "07:00:00", "09:00:00"),
    SISHI(6, "\u5df3\u65f6", "09:00:00", "11:00:00"),
    WUSHI(7, "\u5348\u65f6", "11:00:00", "13:00:00"),
    WEISHI(8, "\u672a\u65f6", "13:00:00", "15:00:00"),
    SHENSHI(9, "\u7533\u65f6", "15:00:00", "17:00:00"),
    YOUSHI(10, "\u9149\u65f6", "17:00:00", "19:00:00"),
    XUSHI(11, "\u620c\u65f6", "19:00:00", "21:00:00"),
    HAISHI(12, "\u4ea5\u65f6", "21:00:00", "23:00:00");

    private int code;
    private String nameCn;
    private String startTime;
    private String endTime;

    private TwelveTwoEnum(int code, String nameCn, String startTime, String endTime) {
        this.code = code;
        this.nameCn = nameCn;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public static TwelveTwoEnum getTwelveHoursEnum(LocalTime localTime) {
        Objects.requireNonNull(localTime, "localTime");
        for (TwelveTwoEnum twelveHours : TwelveTwoEnum.values()) {
            LocalTime timeEnd;
            LocalTime timeStart = LocalTime.parse(twelveHours.getStartTime());
            if (TwelveTwoEnum.isZiShi(localTime, timeStart, timeEnd = LocalTime.parse(twelveHours.getEndTime()))) {
                return ZISHI;
            }
            if (!TwelveTwoEnum.isBetween(localTime, timeStart, timeEnd)) continue;
            return twelveHours;
        }
        return null;
    }

    private static boolean isBetween(LocalTime localTime, LocalTime timeStart, LocalTime timeEnd) {
        return localTime.equals(timeStart) || localTime.isAfter(timeStart) && localTime.isBefore(timeEnd);
    }

    private static boolean isZiShi(LocalTime localTime, LocalTime timeStart, LocalTime timeEnd) {
        if (Constant.TWENTYTHREECLOCK.equals(localTime) || LocalTime.MIDNIGHT.equals(localTime)) {
            return true;
        }
        if (localTime.isAfter(Constant.TWENTYTHREECLOCK)) {
            return true;
        }
        return localTime.isAfter(LocalTime.MIDNIGHT) && localTime.isBefore(Constant.ONECLOCK);
    }

    public static String getNameCn(LocalTime localTime) {
        TwelveTwoEnum twelveHours = TwelveTwoEnum.getTwelveHoursEnum(localTime);
        return twelveHours != null ? twelveHours.getNameCn() : null;
    }

    public static String getNameCn(Date date) {
        return TwelveTwoEnum.getNameCn(DateTimeConverterUtil.toLocalTime(date));
    }

    public int getCode() {
        return this.code;
    }

    public String getNameCn() {
        return this.nameCn;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }
}

