/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.borders;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.property.TransparentColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Border {
    public static final Border NO_BORDER = null;
    private static final float CURV = 0.447f;
    public static final int SOLID = 0;
    public static final int DASHED = 1;
    public static final int DOTTED = 2;
    public static final int DOUBLE = 3;
    public static final int ROUND_DOTS = 4;
    public static final int _3D_GROOVE = 5;
    public static final int _3D_INSET = 6;
    public static final int _3D_OUTSET = 7;
    public static final int _3D_RIDGE = 8;
    public static final int DASHED_FIXED = 9;
    protected TransparentColor transparentColor;
    protected float width;
    protected int type;
    private int hash;

    protected Border(float width) {
        this(ColorConstants.BLACK, width);
    }

    protected Border(Color color, float width) {
        this.transparentColor = new TransparentColor(color);
        this.width = width;
    }

    protected Border(Color color, float width, float opacity) {
        this.transparentColor = new TransparentColor(color, opacity);
        this.width = width;
    }

    public abstract void draw(PdfCanvas var1, float var2, float var3, float var4, float var5, Side var6, float var7, float var8);

    public void draw(PdfCanvas canvas, Rectangle rectangle) {
        float left = rectangle.getX();
        float bottom = rectangle.getY();
        float right = rectangle.getX() + rectangle.getWidth();
        float top = rectangle.getY() + rectangle.getHeight();
        this.draw(canvas, left, top, right, top, Side.TOP, this.width, this.width);
        this.draw(canvas, right, top, right, bottom, Side.RIGHT, this.width, this.width);
        this.draw(canvas, right, bottom, left, bottom, Side.BOTTOM, this.width, this.width);
        this.draw(canvas, left, bottom, left, top, Side.LEFT, this.width, this.width);
    }

    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderRadius, Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        this.draw(canvas, x1, y1, x2, y2, borderRadius, borderRadius, borderRadius, borderRadius, defaultSide, borderWidthBefore, borderWidthAfter);
    }

    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float horizontalRadius1, float verticalRadius1, float horizontalRadius2, float verticalRadius2, Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        Logger logger = LoggerFactory.getLogger(Border.class);
        logger.warn(MessageFormatUtil.format((String)"Method {0} is not implemented by default: please, override and implement it. {1} will be used instead.", (Object[])new Object[]{"Border#draw(PdfCanvas, float, float, float, float, float, float, float, float, Side, float, float", "Border#draw(PdfCanvas, float, float, float, float, Side, float, float)"}));
        this.draw(canvas, x1, y1, x2, y2, defaultSide, borderWidthBefore, borderWidthAfter);
    }

    public abstract void drawCellBorder(PdfCanvas var1, float var2, float var3, float var4, float var5, Side var6);

    public abstract int getType();

    public Color getColor() {
        return this.transparentColor.getColor();
    }

    public float getOpacity() {
        return this.transparentColor.getOpacity();
    }

    public float getWidth() {
        return this.width;
    }

    public void setColor(Color color) {
        this.transparentColor = new TransparentColor(color, this.transparentColor.getOpacity());
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof Border) {
            Border anotherBorder = (Border)anObject;
            return anotherBorder.getType() == this.getType() && anotherBorder.getColor().equals((Object)this.getColor()) && anotherBorder.getWidth() == this.getWidth() && anotherBorder.transparentColor.getOpacity() == this.transparentColor.getOpacity();
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = (int)this.getWidth() * 31 + this.getColor().hashCode();
            this.hash = h = h * 31 + (int)this.transparentColor.getOpacity();
        }
        return h;
    }

    protected Side getBorderSide(float x1, float y1, float x2, float y2, Side defaultSide) {
        boolean isLeft = false;
        boolean isRight = false;
        if (Math.abs(y2 - y1) > 5.0E-4f) {
            isLeft = y2 - y1 > 0.0f;
            isRight = y2 - y1 < 0.0f;
        }
        boolean isTop = false;
        boolean isBottom = false;
        if (Math.abs(x2 - x1) > 5.0E-4f) {
            isTop = x2 - x1 > 0.0f;
            boolean bl = isBottom = x2 - x1 < 0.0f;
        }
        if (isTop) {
            return isLeft ? Side.LEFT : Side.TOP;
        }
        if (isRight) {
            return Side.RIGHT;
        }
        if (isBottom) {
            return Side.BOTTOM;
        }
        if (isLeft) {
            return Side.LEFT;
        }
        return defaultSide;
    }

    protected Point getIntersectionPoint(Point lineBeg, Point lineEnd, Point clipLineBeg, Point clipLineEnd) {
        double A1 = lineBeg.getY() - lineEnd.getY();
        double A2 = clipLineBeg.getY() - clipLineEnd.getY();
        double B1 = lineEnd.getX() - lineBeg.getX();
        double B2 = clipLineEnd.getX() - clipLineBeg.getX();
        double C1 = lineBeg.getX() * lineEnd.getY() - lineBeg.getY() * lineEnd.getX();
        double C2 = clipLineBeg.getX() * clipLineEnd.getY() - clipLineBeg.getY() * clipLineEnd.getX();
        double M = B1 * A2 - B2 * A1;
        return new Point((B2 * C1 - B1 * C2) / M, (C2 * A1 - C1 * A2) / M);
    }

    protected float getDotsGap(double distance, float initialGap) {
        double gapsNum = Math.ceil(distance / (double)initialGap);
        if (gapsNum == 0.0) {
            return initialGap;
        }
        return (float)(distance / gapsNum);
    }

    protected void drawDiscontinuousBorders(PdfCanvas canvas, Rectangle boundingRectangle, float[] horizontalRadii, float[] verticalRadii, Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        float x1 = boundingRectangle.getX();
        float y1 = boundingRectangle.getY();
        float x2 = boundingRectangle.getRight();
        float y2 = boundingRectangle.getTop();
        float horizontalRadius1 = horizontalRadii[0];
        float horizontalRadius2 = horizontalRadii[1];
        float verticalRadius1 = verticalRadii[0];
        float verticalRadius2 = verticalRadii[1];
        float x0 = boundingRectangle.getX();
        float y0 = boundingRectangle.getY();
        float x3 = boundingRectangle.getRight();
        float y3 = boundingRectangle.getTop();
        float widthHalf = this.width / 2.0f;
        Side borderSide = this.getBorderSide(x1, y1, x2, y2, defaultSide);
        switch (borderSide) {
            case TOP: {
                float innerRadiusBefore = Math.max(0.0f, horizontalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, verticalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, verticalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, horizontalRadius2 - borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 - borderWidthBefore), (double)(y1 + this.width)), new Point((double)x1, (double)y1), new Point((double)(x0 -= borderWidthBefore / 2.0f), (double)(y0 -= innerRadiusFirst)), new Point((double)(x0 + 10.0f), (double)y0));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 + borderWidthAfter), (double)(y2 + this.width)), new Point((double)x2, (double)y2), new Point((double)(x3 += borderWidthAfter / 2.0f), (double)(y3 -= innerRadiusSecond)), new Point((double)(x3 - 10.0f), (double)y3));
                if (clipPoint1.x > clipPoint2.x) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 - borderWidthBefore), (double)(y1 + this.width)), clipPoint1, clipPoint2, new Point((double)(x2 + borderWidthAfter), (double)(y2 + this.width)));
                    canvas.moveTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 + borderWidthAfter), (double)(y2 + this.width)).lineTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width));
                } else {
                    canvas.moveTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 + borderWidthAfter), (double)(y2 + this.width)).lineTo((double)(x1 - borderWidthBefore), (double)(y1 + this.width));
                }
                canvas.clip().endPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)x0, (double)(y0 + innerRadiusFirst * 0.447f), (double)((x1 += innerRadiusBefore) - innerRadiusBefore * 0.447f), (double)(y1 += widthHalf), (double)x1, (double)y1).lineTo((double)(x2 -= innerRadiusAfter), (double)(y2 += widthHalf)).curveTo((double)(x2 + innerRadiusAfter * 0.447f), (double)y2, (double)x3, (double)(y3 + innerRadiusSecond * 0.447f), (double)x3, (double)y3);
                break;
            }
            case RIGHT: {
                float innerRadiusBefore = Math.max(0.0f, verticalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, horizontalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, horizontalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, verticalRadius2 - borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 + this.width), (double)(y1 + borderWidthBefore)), new Point((double)x1, (double)y1), new Point((double)(x0 -= innerRadiusFirst), (double)(y0 += borderWidthBefore / 2.0f)), new Point((double)x0, (double)(y0 - 10.0f)));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 + this.width), (double)(y2 - borderWidthAfter)), new Point((double)x2, (double)y2), new Point((double)(x3 -= innerRadiusSecond), (double)(y3 -= borderWidthAfter / 2.0f)), new Point((double)x3, (double)(y3 - 10.0f)));
                if (clipPoint1.y < clipPoint2.y) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 + this.width), (double)(y1 + borderWidthBefore)), clipPoint1, clipPoint2, new Point((double)(x2 + this.width), (double)(y2 - borderWidthAfter)));
                    canvas.moveTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 + this.width), (double)(y2 - borderWidthAfter)).lineTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).clip().endPath();
                } else {
                    canvas.moveTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 + this.width), (double)(y2 - borderWidthAfter)).lineTo((double)(x1 + this.width), (double)(y1 + borderWidthBefore)).clip().endPath();
                }
                canvas.clip().endPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)(x0 + innerRadiusFirst * 0.447f), (double)y0, (double)(x1 += widthHalf), (double)((y1 -= innerRadiusBefore) + innerRadiusBefore * 0.447f), (double)x1, (double)y1).lineTo((double)(x2 += widthHalf), (double)(y2 += innerRadiusAfter)).curveTo((double)x2, (double)(y2 - innerRadiusAfter * 0.447f), (double)(x3 + innerRadiusSecond * 0.447f), (double)y3, (double)x3, (double)y3);
                break;
            }
            case BOTTOM: {
                float innerRadiusBefore = Math.max(0.0f, horizontalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, verticalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, verticalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, horizontalRadius2 - borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 + borderWidthBefore), (double)(y1 - this.width)), new Point((double)x1, (double)y1), new Point((double)(x0 += borderWidthBefore / 2.0f), (double)(y0 += innerRadiusFirst)), new Point((double)(x0 - 10.0f), (double)y0));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 - borderWidthAfter), (double)(y2 - this.width)), new Point((double)x2, (double)y2), new Point((double)(x3 -= borderWidthAfter / 2.0f), (double)(y3 += innerRadiusSecond)), new Point((double)(x3 + 10.0f), (double)y3));
                if (clipPoint1.x < clipPoint2.x) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 + borderWidthBefore), (double)(y1 - this.width)), clipPoint1, clipPoint2, new Point((double)(x2 - borderWidthAfter), (double)(y2 - this.width)));
                    canvas.moveTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 - borderWidthAfter), (double)(y2 - this.width)).lineTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width));
                } else {
                    canvas.moveTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 - borderWidthAfter), (double)(y2 - this.width)).lineTo((double)(x1 + borderWidthBefore), (double)(y1 - this.width));
                }
                canvas.clip().endPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)x0, (double)(y0 - innerRadiusFirst * 0.447f), (double)((x1 -= innerRadiusBefore) + innerRadiusBefore * 0.447f), (double)(y1 -= widthHalf), (double)x1, (double)y1).lineTo((double)(x2 += innerRadiusAfter), (double)(y2 -= widthHalf)).curveTo((double)(x2 - innerRadiusAfter * 0.447f), (double)y2, (double)x3, (double)(y3 - innerRadiusSecond * 0.447f), (double)x3, (double)y3);
                break;
            }
            case LEFT: {
                float innerRadiusBefore = Math.max(0.0f, verticalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, horizontalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, horizontalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, verticalRadius2 - borderWidthAfter);
                Point clipPoint1 = this.getIntersectionPoint(new Point((double)(x1 - this.width), (double)(y1 - borderWidthBefore)), new Point((double)x1, (double)y1), new Point((double)(x0 += innerRadiusFirst), (double)(y0 -= borderWidthBefore / 2.0f)), new Point((double)x0, (double)(y0 + 10.0f)));
                Point clipPoint2 = this.getIntersectionPoint(new Point((double)(x2 - this.width), (double)(y2 + borderWidthAfter)), new Point((double)x2, (double)y2), new Point((double)(x3 += innerRadiusSecond), (double)(y3 += borderWidthAfter / 2.0f)), new Point((double)x3, (double)(y3 + 10.0f)));
                if (clipPoint1.y > clipPoint2.y) {
                    Point clipPoint = this.getIntersectionPoint(new Point((double)(x1 - this.width), (double)(y1 - borderWidthBefore)), clipPoint1, clipPoint2, new Point((double)(x2 - this.width), (double)(y2 + borderWidthAfter)));
                    canvas.moveTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore)).lineTo(clipPoint.x, clipPoint.y).lineTo((double)(x2 - this.width), (double)(y2 + borderWidthAfter)).lineTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore));
                } else {
                    canvas.moveTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore)).lineTo(clipPoint1.x, clipPoint1.y).lineTo(clipPoint2.x, clipPoint2.y).lineTo((double)(x2 - this.width), (double)(y2 + borderWidthAfter)).lineTo((double)(x1 - this.width), (double)(y1 - borderWidthBefore));
                }
                canvas.clip().endPath();
                canvas.moveTo((double)x0, (double)y0).curveTo((double)(x0 - innerRadiusFirst * 0.447f), (double)y0, (double)(x1 -= widthHalf), (double)((y1 += innerRadiusBefore) - innerRadiusBefore * 0.447f), (double)x1, (double)y1).lineTo((double)(x2 -= widthHalf), (double)(y2 -= innerRadiusAfter)).curveTo((double)x2, (double)(y2 + innerRadiusAfter * 0.447f), (double)(x3 - innerRadiusSecond * 0.447f), (double)y3, (double)x3, (double)y3);
                break;
            }
        }
        canvas.stroke().restoreState();
    }

    protected float[] getStartingPointsForBorderSide(float x1, float y1, float x2, float y2, Side defaultSide) {
        float widthHalf = this.width / 2.0f;
        Side borderSide = this.getBorderSide(x1, y1, x2, y2, defaultSide);
        switch (borderSide) {
            case TOP: {
                y1 += widthHalf;
                y2 += widthHalf;
                break;
            }
            case RIGHT: {
                x1 += widthHalf;
                x2 += widthHalf;
                break;
            }
            case BOTTOM: {
                y1 -= widthHalf;
                y2 -= widthHalf;
                break;
            }
            case LEFT: {
                x1 -= widthHalf;
                x2 -= widthHalf;
                break;
            }
        }
        return new float[]{x1, y1, x2, y2};
    }

    public static enum Side {
        NONE,
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

