/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.test;

import com.itextpdf.test.RunnerSearchConfig;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class WrappedSamplesRunner {
    @Parameterized.Parameter
    public RunnerParams sampleClassParams;
    protected Class<?> sampleClass;
    private String errorMessage;

    public static Collection<Object[]> generateTestsList() {
        return WrappedSamplesRunner.generateTestsList(new RunnerSearchConfig().addPackageToRunnerSearchPath(""));
    }

    public static Collection<Object[]> generateTestsList(RunnerSearchConfig searchConfig) {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String searchPath : searchConfig.getSearchPackages()) {
            File classesFolder = Paths.get("target/classes", searchPath.replace(".", "/")).toFile();
            File testClassesFolder = Paths.get("target/test-classes", searchPath.replace(".", "/")).toFile();
            if (!searchPath.isEmpty()) {
                searchPath = searchPath + ".";
            }
            List<RunnerParams> samplesParamsList = WrappedSamplesRunner.getClassNamesRecursively(classesFolder, searchPath, searchConfig);
            samplesParamsList.addAll(WrappedSamplesRunner.getClassNamesRecursively(testClassesFolder, searchPath, searchConfig));
            for (RunnerParams sampleParam : samplesParamsList) {
                params.add(new RunnerParams[]{sampleParam});
            }
        }
        for (String className : searchConfig.getSearchClasses()) {
            params.add(new RunnerParams[]{WrappedSamplesRunner.checkIfTestAndCreateParams(className, searchConfig)});
        }
        return params;
    }

    public void runSamples() throws Exception {
        Assume.assumeTrue((String)this.sampleClassParams.ignoreMessage, (this.sampleClassParams.ignoreMessage == null ? 1 : 0) != 0);
        this.initClass();
        System.out.println("Starting test " + this.sampleClassParams);
        this.runMain();
        String dest = this.getDest();
        String cmp = this.getCmpPdf(dest);
        if (dest == null || dest.isEmpty()) {
            throw new IllegalArgumentException("Can't verify results, DEST field must not be empty!");
        }
        String outPath = this.getOutPath(dest);
        new File(outPath).mkdirs();
        System.out.println("Test executed successfully, comparing results...");
        this.comparePdf(outPath, dest, cmp);
        if (this.errorMessage != null) {
            Assert.fail((String)this.errorMessage);
        }
        System.out.println("Test complete.");
    }

    protected abstract void comparePdf(String var1, String var2, String var3) throws Exception;

    protected String getDest() {
        return WrappedSamplesRunner.getStringField(this.sampleClass, "DEST");
    }

    protected String getCmpPdf(String dest) {
        if (dest == null) {
            return null;
        }
        int i = dest.lastIndexOf("/");
        return "./cmpfiles/" + dest.substring(8, i + 1) + "cmp_" + dest.substring(i + 1);
    }

    protected String getOutPath(String dest) {
        return "./target/" + new File(dest).getParent();
    }

    protected static String getStringField(Class<?> c, String name) {
        try {
            Field field = c.getField(name);
            if (field == null) {
                return null;
            }
            Object obj = field.get(null);
            if (obj == null || !(obj instanceof String)) {
                return null;
            }
            return (String)obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void initClass() {
        if (this.sampleClass == null) {
            try {
                this.sampleClass = Class.forName(this.sampleClassParams.className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(this.sampleClassParams.className + " not found");
            }
        }
    }

    protected void addError(String error) {
        if (error != null && error.length() > 0) {
            this.errorMessage = this.errorMessage == null ? "" : this.errorMessage + "\n";
            this.errorMessage = this.errorMessage + error;
        }
    }

    private void runMain() throws IllegalAccessException, InvocationTargetException {
        Method mainMethod = WrappedSamplesRunner.getMain(this.sampleClass);
        if (mainMethod == null) {
            throw new IllegalArgumentException("Class must have main method.");
        }
        mainMethod.invoke(null, new Object[]{null});
    }

    private static Method getMain(Class<?> c) {
        try {
            return c.getDeclaredMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static List<RunnerParams> getClassNamesRecursively(File path, String currentFullName, RunnerSearchConfig searchConfig) {
        ArrayList<RunnerParams> runnerParams = new ArrayList<RunnerParams>();
        File[] files = path.listFiles();
        if (files == null) {
            return runnerParams;
        }
        for (File file : files) {
            String className;
            RunnerParams params;
            if (file.isDirectory()) {
                String[] splitted = file.getAbsolutePath().replace("\\", "/").split("/");
                String packageName = splitted[splitted.length - 1];
                runnerParams.addAll(WrappedSamplesRunner.getClassNamesRecursively(file, currentFullName + packageName + ".", searchConfig));
                continue;
            }
            String fileName = file.getName();
            if (!fileName.endsWith(".class") || fileName.contains("$") || (params = WrappedSamplesRunner.checkIfTestAndCreateParams(className = currentFullName + fileName.replace(".class", ""), searchConfig)) == null) continue;
            runnerParams.add(params);
        }
        return runnerParams;
    }

    private static RunnerParams checkIfTestAndCreateParams(String className, RunnerSearchConfig searchConfig) {
        if (WrappedSamplesRunner.isIgnoredClassOrPackage(className, searchConfig)) {
            return null;
        }
        try {
            Class<?> c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(MessageFormat.format("Cannot find class {0}", className), e);
        }
        RunnerParams params = new RunnerParams();
        params.className = className;
        return params;
    }

    private static boolean isIgnoredClassOrPackage(String fullName, RunnerSearchConfig searchConfig) {
        for (String ignoredPath : searchConfig.getIgnoredPaths()) {
            File currentFile = WrappedSamplesRunner.getFileByLocation("target/classes", ignoredPath);
            if (currentFile == null) {
                currentFile = WrappedSamplesRunner.getFileByLocation("target/test-classes", ignoredPath);
            }
            if (currentFile == null || (!currentFile.isDirectory() || !fullName.contains(ignoredPath)) && (!currentFile.isFile() || !fullName.equals(ignoredPath))) continue;
            return true;
        }
        return false;
    }

    private static File getFileByLocation(String targetSubDirectory, String filePath) {
        File currentFile = Paths.get(targetSubDirectory, filePath.replace(".", "/")).toFile();
        if (currentFile.exists()) {
            return currentFile;
        }
        currentFile = Paths.get(targetSubDirectory, filePath.replace(".", "/") + ".class").toFile();
        if (currentFile.exists()) {
            return currentFile;
        }
        return null;
    }

    private static class RunnerParams {
        String className;
        String ignoreMessage;

        private RunnerParams() {
        }

        public String toString() {
            return this.className;
        }
    }
}

