/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.DriverImpl;
import com.sun.japex.ParamsImpl;
import com.sun.japex.TestCaseImpl;
import com.sun.japex.TestSuiteImpl;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.File;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class ChartGenerator {
    TestSuiteImpl _testSuite;
    final int _chartWidth;
    final int _chartHeight;
    int _plotGroupSize;
    boolean _plotDrivers;

    public ChartGenerator(TestSuiteImpl testSuite) {
        this._testSuite = testSuite;
        this._plotGroupSize = testSuite.getIntParam("japex.plotGroupSize");
        this._plotDrivers = testSuite.getBooleanParam("japex.plotDrivers");
        List<DriverImpl> driverInfoList = this._testSuite.getDriverInfoList();
        int n = !this._plotDrivers ? driverInfoList.size() : driverInfoList.get(0).getAggregateTestCases().size();
        this._chartWidth = Math.min(Math.max(n * 80, 750), 1500);
        this._chartHeight = (int)Math.round((double)this._chartWidth * 0.6);
    }

    public void generateDriverChart(String fileName) {
        try {
            JFreeChart chart = null;
            String chartType = this._testSuite.getParam("japex.chartType");
            if (chartType.equalsIgnoreCase("barchart")) {
                chart = this.generateDriverBarChart();
            } else if (chartType.equalsIgnoreCase("scatterchart")) {
                chart = this.generateDriverScatterChart();
            } else if (chartType.equalsIgnoreCase("linechart")) {
                chart = this.generateDriverLineChart();
            } else assert (false);
            chart.setAntiAlias(true);
            ChartUtilities.saveChartAsJPEG((File)new File(fileName), (JFreeChart)chart, (int)this._chartWidth, (int)this._chartHeight);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JFreeChart generateDriverBarChart() {
        try {
            String resultUnit = this._testSuite.getParam("japex.resultUnit");
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            ParamsImpl normalizerDriver = null;
            for (DriverImpl driver : this._testSuite.getDriverInfoList()) {
                if (!driver.isNormal()) continue;
                normalizerDriver = driver;
                break;
            }
            if (normalizerDriver != null) {
                if (normalizerDriver.getDoubleParamNoNaN("japex.resultAritMean") == 0.0 || normalizerDriver.getDoubleParamNoNaN("japex.resultGeomMean") == 0.0 || normalizerDriver.getDoubleParamNoNaN("japex.resultHarmMean") == 0.0) {
                    System.out.println("Warning: Driver '" + ((DriverImpl)normalizerDriver).getName() + "' cannot be used to normalize results");
                    normalizerDriver = null;
                } else {
                    resultUnit = "% of " + resultUnit;
                }
            }
            for (DriverImpl di : this._testSuite.getDriverInfoList()) {
                if (normalizerDriver != null) {
                    dataset.addValue(normalizerDriver == di ? 100.0 : 100.0 * di.getDoubleParamNoNaN("japex.resultAritMean") / normalizerDriver.getDoubleParamNoNaN("japex.resultAritMean"), (Comparable)((Object)di.getName()), (Comparable)((Object)"Arithmetic Mean"));
                    dataset.addValue(normalizerDriver == di ? 100.0 : 100.0 * di.getDoubleParamNoNaN("japex.resultGeomMean") / normalizerDriver.getDoubleParamNoNaN("japex.resultGeomMean"), (Comparable)((Object)di.getName()), (Comparable)((Object)"Geometric Mean"));
                    dataset.addValue(normalizerDriver == di ? 100.0 : 100.0 * di.getDoubleParamNoNaN("japex.resultHarmMean") / normalizerDriver.getDoubleParamNoNaN("japex.resultHarmMean"), (Comparable)((Object)di.getName()), (Comparable)((Object)"Harmonic Mean"));
                    continue;
                }
                dataset.addValue(di.getDoubleParamNoNaN("japex.resultAritMean"), (Comparable)((Object)di.getName()), (Comparable)((Object)"Arithmetic Mean"));
                dataset.addValue(di.getDoubleParamNoNaN("japex.resultGeomMean"), (Comparable)((Object)di.getName()), (Comparable)((Object)"Geometric Mean"));
                dataset.addValue(di.getDoubleParamNoNaN("japex.resultHarmMean"), (Comparable)((Object)di.getName()), (Comparable)((Object)"Harmonic Mean"));
            }
            return ChartFactory.createBarChart3D((String)("Result Summary (" + resultUnit + ")"), (String)"", (String)resultUnit, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JFreeChart generateDriverScatterChart() {
        try {
            DefaultTableXYDataset xyDataset = new DefaultTableXYDataset();
            for (DriverImpl di : this._testSuite.getDriverInfoList()) {
                if (!di.hasParam("japex.resultAritMeanX")) {
                    System.out.println("Error: Driver '" + di.getName() + "' does not define" + " any values for the X axis needed to generate a scatter chart");
                    System.exit(1);
                }
                XYSeries xySeries = new XYSeries((Comparable)((Object)di.getName()), true, false);
                xySeries.add(di.getDoubleParamNoNaN("japex.resultAritMeanX"), di.getDoubleParamNoNaN("japex.resultAritMean"));
                xySeries.add(di.getDoubleParamNoNaN("japex.resultGeomMeanX"), di.getDoubleParamNoNaN("japex.resultGeomMean"));
                xySeries.add(di.getDoubleParamNoNaN("japex.resultHarmMeanX"), di.getDoubleParamNoNaN("japex.resultHarmMean"));
                xyDataset.addSeries(xySeries);
            }
            String resultUnit = this._testSuite.getParam("japex.resultUnit");
            String resultUnitX = this._testSuite.getParam("japex.resultUnitX");
            JFreeChart chart = ChartFactory.createScatterPlot((String)"Result Summary", (String)resultUnitX, (String)resultUnit, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            XYPlot plot = chart.getXYPlot();
            if (this._testSuite.getParam("japex.resultAxisX").equalsIgnoreCase("logarithmic")) {
                LogarithmicAxis logAxisX = new LogarithmicAxis(resultUnitX);
                logAxisX.setAllowNegativesFlag(true);
                plot.setDomainAxis((ValueAxis)logAxisX);
            }
            if (this._testSuite.getParam("japex.resultAxis").equalsIgnoreCase("logarithmic")) {
                LogarithmicAxis logAxis = new LogarithmicAxis(resultUnit);
                logAxis.setAllowNegativesFlag(true);
                plot.setRangeAxis((ValueAxis)logAxis);
            }
            return chart;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JFreeChart generateDriverLineChart() {
        try {
            String resultUnit = this._testSuite.getParam("japex.resultUnit");
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            for (DriverImpl di : this._testSuite.getDriverInfoList()) {
                dataset.addValue(di.getDoubleParamNoNaN("japex.resultAritMean"), (Comparable)((Object)"Arithmetic Mean"), (Comparable)((Object)di.getName()));
                dataset.addValue(di.getDoubleParamNoNaN("japex.resultGeomMean"), (Comparable)((Object)"Geometric Mean"), (Comparable)((Object)di.getName()));
                dataset.addValue(di.getDoubleParamNoNaN("japex.resultHarmMean"), (Comparable)((Object)"Harmonic Mean"), (Comparable)((Object)di.getName()));
            }
            JFreeChart chart = ChartFactory.createLineChart((String)("Result Summary (" + resultUnit + ")"), (String)"", (String)resultUnit, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            ChartGenerator.configureLineChart(chart);
            return chart;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int generateTestCaseCharts(String baseName, String extension) {
        String chartType = this._testSuite.getParam("japex.chartType");
        if (chartType.equalsIgnoreCase("barchart")) {
            return this.generateTestCaseBarCharts(baseName, extension);
        }
        if (chartType.equalsIgnoreCase("scatterchart")) {
            return this.generateTestCaseScatterCharts(baseName, extension);
        }
        if (chartType.equalsIgnoreCase("linechart")) {
            return this.generateTestCaseLineCharts(baseName, extension);
        }
        assert (false);
        return 0;
    }

    private int generateTestCaseBarCharts(String baseName, String extension) {
        int nOfFiles = 0;
        List<DriverImpl> driverInfoList = this._testSuite.getDriverInfoList();
        int nOfTests = driverInfoList.get(0).getAggregateTestCases().size();
        int groupSizesIndex = 0;
        int[] groupSizes = ChartGenerator.calculateGroupSizes(nOfTests, this._plotGroupSize);
        try {
            String resultUnit = this._testSuite.getParam("japex.resultUnit");
            ParamsImpl normalizerDriver = null;
            for (DriverImpl di : driverInfoList) {
                if (!di.isNormal()) continue;
                normalizerDriver = di;
                break;
            }
            if (normalizerDriver != null) {
                if (normalizerDriver.getDoubleParamNoNaN("japex.resultAritMean") == 0.0 || normalizerDriver.getDoubleParamNoNaN("japex.resultGeomMean") == 0.0 || normalizerDriver.getDoubleParamNoNaN("japex.resultHarmMean") == 0.0) {
                    normalizerDriver = null;
                } else {
                    resultUnit = "% of " + resultUnit;
                }
            }
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            int thisGroupSize = 0;
            for (int i = 0; i < nOfTests; ++i) {
                for (DriverImpl di : driverInfoList) {
                    TestCaseImpl tc = (TestCaseImpl)di.getAggregateTestCases().get(i);
                    if (normalizerDriver != null) {
                        TestCaseImpl normalTc = (TestCaseImpl)((DriverImpl)normalizerDriver).getAggregateTestCases().get(i);
                        dataset.addValue(normalizerDriver == di ? 100.0 : 100.0 * tc.getDoubleParamNoNaN("japex.resultValue") / normalTc.getDoubleParamNoNaN("japex.resultValue"), (Comparable)((Object)(this._plotDrivers ? tc.getName() : di.getName())), (Comparable)((Object)(this._plotDrivers ? di.getName() : tc.getName())));
                        continue;
                    }
                    dataset.addValue(tc.getDoubleParamNoNaN("japex.resultValue"), (Comparable)((Object)(this._plotDrivers ? tc.getName() : di.getName())), (Comparable)((Object)(this._plotDrivers ? di.getName() : tc.getName())));
                }
                if (++thisGroupSize != groupSizes[groupSizesIndex]) continue;
                JFreeChart chart = ChartFactory.createBarChart3D((String)((this._plotDrivers ? "Results per Driver (" : "Results per Test (") + resultUnit + ")"), (String)"", (String)resultUnit, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                chart.setAntiAlias(true);
                ChartUtilities.saveChartAsJPEG((File)new File(baseName + Integer.toString(nOfFiles) + extension), (JFreeChart)chart, (int)this._chartWidth, (int)this._chartHeight);
                ++nOfFiles;
                ++groupSizesIndex;
                thisGroupSize = 0;
                dataset = new DefaultCategoryDataset();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nOfFiles;
    }

    private int generateTestCaseLineCharts(String baseName, String extension) {
        int nOfFiles = 0;
        List<DriverImpl> driverInfoList = this._testSuite.getDriverInfoList();
        int nOfTests = driverInfoList.get(0).getAggregateTestCases().size();
        int groupSizesIndex = 0;
        int[] groupSizes = ChartGenerator.calculateGroupSizes(nOfTests, this._plotGroupSize);
        try {
            String resultUnit = this._testSuite.getParam("japex.resultUnit");
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            int thisGroupSize = 0;
            for (int i = 0; i < nOfTests; ++i) {
                for (DriverImpl di : driverInfoList) {
                    TestCaseImpl tc = (TestCaseImpl)di.getAggregateTestCases().get(i);
                    dataset.addValue(tc.getDoubleParamNoNaN("japex.resultValue"), (Comparable)((Object)(this._plotDrivers ? di.getName() : tc.getName())), (Comparable)((Object)(this._plotDrivers ? tc.getName() : di.getName())));
                }
                if (++thisGroupSize != groupSizes[groupSizesIndex]) continue;
                JFreeChart chart = ChartFactory.createLineChart((String)((this._plotDrivers ? "Results per Driver (" : "Results per Test (") + resultUnit + ")"), (String)"", (String)resultUnit, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                ChartGenerator.configureLineChart(chart);
                chart.setAntiAlias(true);
                ChartUtilities.saveChartAsJPEG((File)new File(baseName + Integer.toString(nOfFiles) + extension), (JFreeChart)chart, (int)this._chartWidth, (int)this._chartHeight);
                ++nOfFiles;
                ++groupSizesIndex;
                thisGroupSize = 0;
                dataset = new DefaultCategoryDataset();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nOfFiles;
    }

    private int generateTestCaseScatterCharts(String baseName, String extension) {
        int nOfFiles = 0;
        List<DriverImpl> driverInfoList = this._testSuite.getDriverInfoList();
        try {
            int nOfTests = driverInfoList.get(0).getAggregateTestCases().size();
            DefaultTableXYDataset xyDataset = new DefaultTableXYDataset();
            for (DriverImpl di : driverInfoList) {
                XYSeries xySeries = new XYSeries((Comparable)((Object)di.getName()), true, false);
                for (int j = 0; j < nOfTests; ++j) {
                    TestCaseImpl tc = (TestCaseImpl)di.getAggregateTestCases().get(j);
                    try {
                        xySeries.add(tc.getDoubleParamNoNaN("japex.resultValueX"), tc.getDoubleParamNoNaN("japex.resultValue"));
                        continue;
                    }
                    catch (SeriesException e) {
                        // empty catch block
                    }
                }
                xyDataset.addSeries(xySeries);
            }
            String resultUnit = this._testSuite.getParam("japex.resultUnit");
            String resultUnitX = this._testSuite.getParam("japex.resultUnitX");
            JFreeChart chart = ChartFactory.createScatterPlot((String)"Results Per Test", (String)resultUnitX, (String)resultUnit, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            XYPlot plot = chart.getXYPlot();
            if (this._testSuite.getParam("japex.resultAxisX").equalsIgnoreCase("logarithmic")) {
                LogarithmicAxis logAxisX = new LogarithmicAxis(resultUnitX);
                logAxisX.setAllowNegativesFlag(true);
                plot.setDomainAxis((ValueAxis)logAxisX);
            }
            if (this._testSuite.getParam("japex.resultAxis").equalsIgnoreCase("logarithmic")) {
                LogarithmicAxis logAxis = new LogarithmicAxis(resultUnit);
                logAxis.setAllowNegativesFlag(true);
                plot.setRangeAxis((ValueAxis)logAxis);
            }
            chart.setAntiAlias(true);
            ChartUtilities.saveChartAsJPEG((File)new File(baseName + Integer.toString(nOfFiles) + extension), (JFreeChart)chart, (int)this._chartWidth, (int)this._chartHeight);
            ++nOfFiles;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nOfFiles;
    }

    private static void configureLineChart(JFreeChart chart) {
        CategoryPlot plot = chart.getCategoryPlot();
        DefaultDrawingSupplier supplier = new DefaultDrawingSupplier(DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, new Shape[]{new Polygon(new int[]{3, 0, -3, 0}, new int[]{0, 3, 0, -3}, 4)});
        plot.setDomainGridlinePaint((Paint)Color.black);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setDrawingSupplier((DrawingSupplier)supplier);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setShapesVisible(true);
        renderer.setStroke((Stroke)new BasicStroke(2.0f));
    }

    private static int[] calculateGroupSizes(int nOfTests, int maxGroupSize) {
        if (nOfTests <= maxGroupSize) {
            return new int[]{nOfTests};
        }
        int[] result = new int[nOfTests / maxGroupSize + (nOfTests % maxGroupSize > 0 ? 1 : 0)];
        int m1 = (nOfTests - maxGroupSize) / maxGroupSize;
        for (int i = 0; i < m1; ++i) {
            result[i] = maxGroupSize;
        }
        int m2 = nOfTests - m1 * maxGroupSize;
        if (m2 <= maxGroupSize) {
            result[result.length - 1] = m2;
        } else {
            result[result.length - 2] = (int)Math.ceil((double)m2 / 2.0);
            result[result.length - 1] = m2 - result[result.length - 2];
        }
        return result;
    }
}

