/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.ConditionalProcessor;
import com.sun.japex.ConfigFileException;
import com.sun.japex.TestSuiteImpl;
import com.sun.japex.Util;
import com.sun.japex.testsuite.TestSuiteElement;
import java.io.File;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ConfigFileLoader {
    public static final JAXBContext context = ConfigFileLoader.getJABXContext();
    TestSuiteImpl _testSuite;

    private static JAXBContext getJABXContext() {
        try {
            return JAXBContext.newInstance((String)"com.sun.japex.testsuite");
        }
        catch (Exception e) {
            throw new RuntimeException("Japex cannot create JAXB context", e);
        }
    }

    protected ConfigFileLoader() {
    }

    public ConfigFileLoader(String fileName) throws ConfigFileException {
        try {
            TestSuiteElement testSuiteElement = (TestSuiteElement)this.loadFile(fileName);
            this._testSuite = this.createTestSuite(testSuiteElement, new File(fileName).getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TestSuiteImpl getTestSuite() {
        return this._testSuite;
    }

    protected Object loadFile(String fileName) throws Exception {
        System.out.println("Reading configuration file '" + fileName + "' ...");
        ConditionalProcessor processor = new ConditionalProcessor();
        Reader config = processor.process(fileName);
        XMLReader reader = Util.getXIncludeXMLReader();
        Unmarshaller u = context.createUnmarshaller();
        InputSource is = new InputSource(config);
        is.setSystemId(fileName);
        return u.unmarshal((Source)new SAXSource(reader, is));
    }

    protected TestSuiteImpl createTestSuite(TestSuiteElement tse, String name) {
        TestSuiteImpl testSuite = new TestSuiteImpl(tse);
        testSuite.setParam("japex.configFile", name);
        return testSuite;
    }
}

