/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.ConfigFileException;
import com.sun.japex.ConfigFileLoader;
import com.sun.japex.testsuite.DriverElement;
import com.sun.japex.testsuite.DriverGroupElement;
import com.sun.japex.testsuite.ParamElement;
import com.sun.japex.testsuite.ParamGroupElement;
import com.sun.japex.testsuite.TestCaseElement;
import com.sun.japex.testsuite.TestCaseGroupElement;
import com.sun.japex.testsuite.TestSuiteElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFileMerger
extends ConfigFileLoader {
    public ConfigFileMerger(List<String> fileNames) throws ConfigFileException {
        TestSuiteElement testSuiteElement = null;
        String testSuiteName = "";
        ArrayList<Object> objects = new ArrayList<Object>();
        for (String string : fileNames) {
            try {
                if (testSuiteName != "") {
                    testSuiteName = testSuiteName + ",";
                }
                testSuiteName = testSuiteName + new File(string).getName();
                Object o = this.loadFile(string);
                if (o instanceof TestSuiteElement) {
                    if (testSuiteElement != null) {
                        this.merge(testSuiteElement, o);
                        continue;
                    }
                    testSuiteElement = (TestSuiteElement)o;
                    continue;
                }
                objects.add(o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (testSuiteElement == null) {
            testSuiteElement = new TestSuiteElement();
            testSuiteElement.setName("Merged Test Suite");
        }
        for (String string : objects) {
            this.merge(testSuiteElement, string);
        }
        this._testSuite = this.createTestSuite(testSuiteElement, testSuiteName);
    }

    private void merge(TestSuiteElement to, Object o) {
        if (o instanceof TestSuiteElement) {
            TestSuiteElement from = (TestSuiteElement)o;
            this.appendTestSuiteName(to, from.getName());
            for (Object fromo : from.getParamOrParamGroup()) {
                to.getParamOrParamGroup().add(fromo);
            }
            for (Object fromo : from.getTestCaseOrTestCaseGroup()) {
                to.getTestCaseOrTestCaseGroup().add(fromo);
            }
            for (Object fromo : from.getDriverOrDriverGroup()) {
                to.getDriverOrDriverGroup().add(fromo);
            }
        } else if (o instanceof ParamElement || o instanceof ParamGroupElement) {
            to.getParamOrParamGroup().add(o);
            if (o instanceof ParamGroupElement) {
                this.appendTestSuiteName(to, ((ParamGroupElement)o).getName());
            }
        } else if (o instanceof TestCaseElement || o instanceof TestCaseGroupElement) {
            to.getTestCaseOrTestCaseGroup().add(o);
            if (o instanceof TestCaseGroupElement) {
                this.appendTestSuiteName(to, ((TestCaseGroupElement)o).getName());
            }
        } else if (o instanceof DriverElement || o instanceof DriverGroupElement) {
            to.getDriverOrDriverGroup().add(o);
            if (o instanceof DriverGroupElement) {
                this.appendTestSuiteName(to, ((DriverGroupElement)o).getName());
            }
        }
    }

    private void appendTestSuiteName(TestSuiteElement to, String name) {
        if (name != null && name.length() > 0) {
            to.setName(to.getName() + ", " + name);
        }
    }
}

