/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.Driver;
import com.sun.japex.ParamsImpl;
import com.sun.japex.TestCaseArrayList;
import com.sun.japex.TestCaseImpl;
import com.sun.japex.Util;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DriverImpl
extends ParamsImpl
implements Driver,
Cloneable {
    String _name;
    String _baseName = null;
    boolean _isNormal = false;
    boolean _computeMeans = true;
    Class _class = null;
    TestCaseArrayList[] _testCases;
    TestCaseArrayList _aggregateTestCases;
    String _description;

    public DriverImpl(String name, boolean isNormal, ParamsImpl params) {
        super(params);
        this._name = name;
        this._isNormal = isNormal;
    }

    public Object clone() {
        return super.clone();
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setTestCases(TestCaseArrayList testCases) {
        int runsPerDriver = this.getIntParam("japex.runsPerDriver");
        int warmupsPerDriver = this.getIntParam("japex.warmupsPerDriver");
        int actualRuns = runsPerDriver + warmupsPerDriver;
        this._testCases = new TestCaseArrayList[actualRuns];
        for (int i = 0; i < actualRuns; ++i) {
            this._testCases[i] = (TestCaseArrayList)testCases.clone();
        }
        this._aggregateTestCases = (TestCaseArrayList)testCases.clone();
    }

    private void computeMeans() {
        int warmupsPerDriver;
        int runsPerDriver = this.getIntParam("japex.runsPerDriver");
        int startRun = warmupsPerDriver = this.getIntParam("japex.warmupsPerDriver");
        int actualRuns = runsPerDriver + warmupsPerDriver;
        if (this._computeMeans) {
            int nOfTests = this._testCases[0].size();
            for (int n = 0; n < nOfTests; ++n) {
                double avgRunsResult = 0.0;
                double[] results = new double[actualRuns];
                double[] resultsX = new double[actualRuns];
                TestCaseImpl startRunTc = (TestCaseImpl)this._testCases[startRun].get(n);
                boolean hasResultValueX = startRunTc.hasParam("japex.resultValueX");
                for (int i = startRun; i < actualRuns; ++i) {
                    TestCaseImpl tc = (TestCaseImpl)this._testCases[i].get(n);
                    results[i] = tc.getDoubleParam("japex.resultValue");
                    if (!hasResultValueX) continue;
                    resultsX[i] = tc.getDoubleParam("japex.resultValueX");
                }
                TestCaseImpl tc = (TestCaseImpl)this._aggregateTestCases.get(n);
                tc.setDoubleParam("japex.resultValue", Util.arithmeticMean(results, startRun));
                if (hasResultValueX) {
                    tc.setDoubleParam("japex.resultValueX", Util.arithmeticMean(resultsX, startRun));
                }
                if (actualRuns - startRun <= 1) continue;
                tc.setDoubleParam("japex.resultValueStddev", Util.standardDev(results, startRun));
                if (!hasResultValueX) continue;
                tc.setDoubleParam("japex.resultValueXStddev", Util.standardDev(resultsX, startRun));
            }
            double geomMeanresult = 1.0;
            double aritMeanresult = 0.0;
            double harmMeanresultInverse = 0.0;
            double geomMeanresultX = 1.0;
            double aritMeanresultX = 0.0;
            double harmMeanresultXInverse = 0.0;
            boolean setMeansAxisX = false;
            for (TestCaseImpl tc : this._aggregateTestCases) {
                double result = tc.getDoubleParam("japex.resultValue");
                aritMeanresult += result / (double)nOfTests;
                geomMeanresult *= Math.pow(result, 1.0 / (double)nOfTests);
                harmMeanresultInverse += 1.0 / ((double)nOfTests * result);
                if (!tc.hasParam("japex.resultValueX")) continue;
                double resultX = tc.getDoubleParam("japex.resultValueX");
                aritMeanresultX += resultX / (double)nOfTests;
                geomMeanresultX *= Math.pow(resultX, 1.0 / (double)nOfTests);
                harmMeanresultXInverse += 1.0 / ((double)nOfTests * resultX);
                setMeansAxisX = true;
            }
            this.setDoubleParam("japex.resultAritMean", aritMeanresult);
            this.setDoubleParam("japex.resultGeomMean", geomMeanresult);
            this.setDoubleParam("japex.resultHarmMean", 1.0 / harmMeanresultInverse);
            if (setMeansAxisX) {
                this.setDoubleParam("japex.resultAritMeanX", aritMeanresultX);
                this.setDoubleParam("japex.resultGeomMeanX", geomMeanresultX);
                this.setDoubleParam("japex.resultHarmMeanX", 1.0 / harmMeanresultXInverse);
            }
            this._computeMeans = false;
            if (actualRuns - startRun == 1) {
                return;
            }
            geomMeanresult = 1.0;
            aritMeanresult = 0.0;
            harmMeanresultInverse = 0.0;
            geomMeanresultX = 1.0;
            aritMeanresultX = 0.0;
            harmMeanresultXInverse = 0.0;
            boolean setStddevsAxisX = false;
            for (TestCaseImpl tc : this._aggregateTestCases) {
                double result = tc.getDoubleParam("japex.resultValueStddev");
                aritMeanresult += result / (double)nOfTests;
                geomMeanresult *= Math.pow(result, 1.0 / (double)nOfTests);
                harmMeanresultInverse += 1.0 / ((double)nOfTests * result);
                if (!tc.hasParam("japex.resultValueXStddev")) continue;
                double resultX = tc.getDoubleParam("japex.resultValueXStddev");
                aritMeanresultX += resultX / (double)nOfTests;
                geomMeanresultX *= Math.pow(resultX, 1.0 / (double)nOfTests);
                harmMeanresultXInverse += 1.0 / ((double)nOfTests * resultX);
                setStddevsAxisX = true;
            }
            this.setDoubleParam("japex.resultAritMeanStddev", aritMeanresult);
            this.setDoubleParam("japex.resultGeomMeanStddev", geomMeanresult);
            this.setDoubleParam("japex.resultHarmMeanStddev", 1.0 / harmMeanresultInverse);
            if (setStddevsAxisX) {
                this.setDoubleParam("japex.resultAritMeanXStddev", aritMeanresultX);
                this.setDoubleParam("japex.resultGeomMeanXStddev", geomMeanresultX);
                this.setDoubleParam("japex.resultHarmMeanXStddev", 1.0 / harmMeanresultXInverse);
            }
        }
    }

    public List getTestCases(int driverRun) {
        return this._testCases[driverRun];
    }

    public List getAggregateTestCases() {
        this.computeMeans();
        return this._aggregateTestCases;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getBaseName() {
        return this._baseName;
    }

    public void setBaseName(String name) {
        this._baseName = name;
    }

    public boolean isNormal() {
        return this._isNormal;
    }

    public void setNormal(boolean b) {
        this._isNormal = b;
    }

    public void serialize(StringBuffer report, int spaces) {
        report.append(Util.getSpaces(spaces) + "<driver name=\"" + this._name + "\"" + (this._isNormal ? " normal=\"true\">\n" : ">\n"));
        if (this._description != null) {
            report.append(this._description);
        }
        List aggregateTestCases = this.getAggregateTestCases();
        super.serialize(report, spaces + 2);
        Iterator tci = aggregateTestCases.iterator();
        HashSet<String> paramsClosure = new HashSet<String>();
        while (tci.hasNext()) {
            Set<String> testCaseParams = ((TestCaseImpl)tci.next()).nameSet();
            for (String name : testCaseParams) {
                paramsClosure.add(name);
            }
        }
        for (TestCaseImpl tc : aggregateTestCases) {
            for (String name : paramsClosure) {
                if (tc.hasLocalParam(name)) continue;
                tc.setParam(name, "n/a");
            }
        }
        for (TestCaseImpl tc : aggregateTestCases) {
            tc.serialize(report, spaces + 2);
        }
        report.append(Util.getSpaces(spaces) + "</driver>\n");
    }
}

