/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.ConfigFileMerger;
import com.sun.japex.DriverImpl;
import com.sun.japex.Japex;
import com.sun.japex.JapexClassLoader;
import com.sun.japex.JapexDriverBase;
import com.sun.japex.JapexThreadFactory;
import com.sun.japex.TestCase;
import com.sun.japex.TestCaseImpl;
import com.sun.japex.TestSuiteImpl;
import com.sun.japex.Util;
import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine {
    TestSuiteImpl _testSuite;
    ThreadPoolExecutor _threadPool;
    JapexDriverBase[][] _drivers;
    DriverImpl _driverImpl;
    int _driverRun;
    Boolean _computeResult = null;
    double _geomMeanresult = 1.0;
    double _aritMeanresult = 0.0;
    double _harmMeanresultInverse = 0.0;
    protected List<GarbageCollectorMXBean> _gCCollectors = ManagementFactory.getGarbageCollectorMXBeans();
    protected long _gCTime;
    long _beforeHeapMemoryUsage;

    public TestSuiteImpl start(List<String> configFiles) {
        try {
            ConfigFileMerger cfl = new ConfigFileMerger(configFiles);
            this._testSuite = cfl.getTestSuite();
            if (Japex.test) {
                System.out.println("Running in test mode without generating reports ...");
            }
            if (this._testSuite.hasParam("japex.warmupTime") && this._testSuite.hasParam("japex.runTime")) {
                int[] hms = this.estimateRunningTime(this._testSuite);
                System.out.println("Estimated warmup time + run time is " + (hms[0] > 0 ? hms[0] + " hours " : "") + (hms[1] > 0 ? hms[1] + " minutes " : "") + (hms[2] > 0 ? hms[2] + " seconds " : ""));
            }
            this.forEachDriver();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this._testSuite;
    }

    private void forEachDriver() {
        try {
            List<DriverImpl> driverList = this._testSuite.getDriverInfoList();
            for (int k = 0; k < driverList.size(); ++k) {
                int j;
                int i;
                this._driverImpl = driverList.get(k);
                int nOfCpus = this._driverImpl.getIntParam("japex.numberOfCpus");
                int nOfThreads = this._driverImpl.getIntParam("japex.numberOfThreads");
                int runsPerDriver = this._driverImpl.getIntParam("japex.runsPerDriver");
                int warmupsPerDriver = this._driverImpl.getIntParam("japex.warmupsPerDriver");
                JapexClassLoader jcLoader = new JapexClassLoader(this._driverImpl.getParam("japex.classPath"));
                Thread.currentThread().setContextClassLoader(jcLoader);
                System.out.print("  " + this._driverImpl.getName() + " using " + nOfThreads + " thread(s) on " + nOfCpus + " cpu(s)");
                int actualRuns = warmupsPerDriver + runsPerDriver;
                try {
                    this._drivers = new JapexDriverBase[nOfThreads][actualRuns];
                    for (i = 0; i < nOfThreads; ++i) {
                        for (j = 0; j < actualRuns; ++j) {
                            this._drivers[i][j] = jcLoader.getJapexDriver(this._driverImpl.getParam("japex.driverClass"));
                            this._drivers[i][j].setDriver(this._driverImpl);
                            this._drivers[i][j].setTestSuite(this._testSuite);
                            this._drivers[i][j].initializeDriver();
                        }
                    }
                }
                catch (Throwable e) {
                    System.out.println("\n  Warning: Unable to load driver '" + this._driverImpl.getName() + "'");
                    System.out.println("           " + e.toString());
                    this._testSuite.getDriverInfoList().remove(this._driverImpl);
                    --k;
                    ++Japex.exitCode;
                    continue;
                }
                if (nOfThreads > 1) {
                    this._threadPool = new ThreadPoolExecutor(nOfThreads, nOfThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new JapexThreadFactory(jcLoader));
                    this._threadPool.prestartAllCoreThreads();
                }
                this.resetPeakMemoryUsage();
                this.forEachRun();
                if (this._driverImpl.getBooleanParam("japex.reportPeakHeapUsage")) {
                    this.setPeakMemoryUsage(this._driverImpl);
                    System.out.println("    Peak heap usage: " + this._driverImpl.getParam("japex.peakHeapUsage") + " KB");
                }
                for (i = 0; i < nOfThreads; ++i) {
                    for (j = 0; j < actualRuns; ++j) {
                        this._drivers[i][j].terminateDriver();
                    }
                }
                if (nOfThreads <= 1) continue;
                this._threadPool.shutdown();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void forEachRun() {
        try {
            int runsPerDriver = this._driverImpl.getIntParam("japex.runsPerDriver");
            int warmupsPerDriver = this._driverImpl.getIntParam("japex.warmupsPerDriver");
            int actualRuns = warmupsPerDriver + runsPerDriver;
            this._driverRun = 0;
            while (this._driverRun < actualRuns) {
                if (this._driverRun < warmupsPerDriver) {
                    System.out.print("\n    Warmup " + (this._driverRun + 1) + ": ");
                } else {
                    System.out.print("\n    Run " + (this._driverRun - warmupsPerDriver + 1) + ": ");
                }
                if (Japex.resultPerLine) {
                    System.out.println("");
                }
                this._geomMeanresult = 1.0;
                this._aritMeanresult = 0.0;
                this._harmMeanresultInverse = 0.0;
                this.forEachTestCase();
                if (Japex.resultPerLine) {
                    System.out.print("      aritmean," + Util.formatDouble(this._aritMeanresult) + ",\n      geommean," + Util.formatDouble(this._geomMeanresult) + ",\n      harmmean," + Util.formatDouble(1.0 / this._harmMeanresultInverse));
                } else {
                    System.out.print("aritmean," + Util.formatDouble(this._aritMeanresult) + ",geommean," + Util.formatDouble(this._geomMeanresult) + ",harmmean," + Util.formatDouble(1.0 / this._harmMeanresultInverse));
                }
                ++this._driverRun;
            }
            int startRun = warmupsPerDriver;
            if (actualRuns - startRun > 1) {
                System.out.print("\n     Avgs: ");
                for (TestCaseImpl tc : this._driverImpl.getAggregateTestCases()) {
                    System.out.print(tc.getName() + ",");
                    System.out.print(Util.formatDouble(tc.getDoubleParam("japex.resultValue")) + ",");
                }
                System.out.print("aritmean," + this._driverImpl.getParam("japex.resultAritMean") + ",geommean," + this._driverImpl.getParam("japex.resultGeomMean") + ",harmmean," + this._driverImpl.getParam("japex.resultHarmMean"));
                System.out.print("\n    Stdev: ");
                for (TestCaseImpl tc : this._driverImpl.getAggregateTestCases()) {
                    System.out.print(tc.getName() + ",");
                    System.out.print(Util.formatDouble(tc.getDoubleParam("japex.resultValueStddev")) + ",");
                }
                System.out.println("aritmean," + this._driverImpl.getParam("japex.resultAritMeanStddev") + ",geommean," + this._driverImpl.getParam("japex.resultGeomMeanStddev") + ",harmmean," + this._driverImpl.getParam("japex.resultHarmMeanStddev"));
            } else {
                System.out.println("");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forEachTestCase() {
        try {
            int nOfCpus = this._driverImpl.getIntParam("japex.numberOfCpus");
            int nOfThreads = this._driverImpl.getIntParam("japex.numberOfThreads");
            List tcList = this._driverImpl.getTestCases(this._driverRun);
            int nOfTests = tcList.size();
            Iterator tci = tcList.iterator();
            while (tci.hasNext()) {
                double result;
                TestCaseImpl tc;
                block27: {
                    long runTime = 0L;
                    tc = (TestCaseImpl)tci.next();
                    if (Japex.verbose) {
                        System.out.println(tc.getName());
                    } else if (Japex.resultPerLine) {
                        System.out.print("      " + tc.getName() + ",");
                    } else {
                        System.out.print(tc.getName() + ",");
                    }
                    Future[] futures = null;
                    List<Long> gCStartTimes = null;
                    try {
                        int i;
                        double endTime;
                        if (nOfThreads == 1) {
                            this._drivers[0][this._driverRun].setTestCase(tc);
                            this._drivers[0][this._driverRun].prepare();
                            endTime = tc.hasParam("japex.warmupTime") ? Util.currentTimeMillis() + (double)Util.parseDuration(tc.getParam("japex.warmupTime")) : 0.0;
                            this._drivers[0][this._driverRun].setEndTime(endTime);
                            this._drivers[0][this._driverRun].call();
                            tc.setDoubleParam("japex.actualWarmupTime", tc.getDoubleParam("japex.warmupTimeSum"));
                            endTime = tc.hasParam("japex.runTime") ? Util.currentTimeMillis() + (double)Util.parseDuration(tc.getParam("japex.runTime")) : 0.0;
                            System.gc();
                            gCStartTimes = this.getGCAbsoluteTimes();
                            this._drivers[0][this._driverRun].setEndTime(endTime);
                            this._drivers[0][this._driverRun].call();
                            tc.setDoubleParam("japex.actualRunTime", tc.getDoubleParam("japex.runTimeSum"));
                        } else {
                            for (i = 0; i < nOfThreads; ++i) {
                                this._drivers[i][this._driverRun].setTestCase(tc);
                                this._drivers[i][this._driverRun].prepare();
                            }
                            futures = new Future[nOfThreads];
                            endTime = tc.hasParam("japex.warmupTime") ? Util.currentTimeMillis() + (double)Util.parseDuration(tc.getParam("japex.warmupTime")) : 0.0;
                            for (i = 0; i < nOfThreads; ++i) {
                                this._drivers[i][this._driverRun].setEndTime(endTime);
                                futures[i] = this._threadPool.submit(this._drivers[i][this._driverRun]);
                            }
                            for (i = 0; i < nOfThreads; ++i) {
                                futures[i].get();
                            }
                            tc.setDoubleParam("japex.actualWarmupTime", tc.getDoubleParam("japex.warmupTimeSum") / (double)nOfThreads);
                            endTime = tc.hasParam("japex.runTime") ? Util.currentTimeMillis() + (double)Util.parseDuration(tc.getParam("japex.runTime")) : 0.0;
                            System.gc();
                            gCStartTimes = this.getGCAbsoluteTimes();
                            for (i = 0; i < nOfThreads; ++i) {
                                this._drivers[i][this._driverRun].setEndTime(endTime);
                                futures[i] = this._threadPool.submit(this._drivers[i][this._driverRun]);
                            }
                            for (i = 0; i < nOfThreads; ++i) {
                                futures[i].get();
                            }
                            tc.setDoubleParam("japex.actualRunTime", tc.getDoubleParam("japex.runTimeSum") / (double)nOfThreads);
                        }
                        this._gCTime = this.getGCRelativeTotalTime(gCStartTimes);
                        for (i = 0; i < nOfThreads; ++i) {
                            this._drivers[i][this._driverRun].finish();
                        }
                    }
                    catch (Exception e) {
                        tc.setDoubleParam("japex.resultValue", Double.NaN);
                        if (Japex.verbose) {
                            e.printStackTrace();
                        }
                        ++Japex.exitCode;
                    }
                    finally {
                        if (futures == null) break block27;
                        for (int i = 0; i < nOfThreads; ++i) {
                            futures[i].cancel(true);
                        }
                    }
                }
                if (tc.hasParam("japex.resultValue")) {
                    result = tc.getDoubleParam("japex.resultValue");
                } else {
                    result = this.computeResultValue(tc, nOfThreads, nOfCpus);
                    tc.setDoubleParam("japex.resultValue", result);
                }
                this._aritMeanresult += result / (double)nOfTests;
                this._geomMeanresult *= Math.pow(result, 1.0 / (double)nOfTests);
                this._harmMeanresultInverse += 1.0 / ((double)nOfTests * result);
                if (Japex.verbose) {
                    System.out.println("           " + tc.getParam("japex.resultValue"));
                    System.out.print("           ");
                    continue;
                }
                if (Japex.resultPerLine) {
                    System.out.println(tc.getParam("japex.resultValue") + ",");
                    continue;
                }
                System.out.print(tc.getParam("japex.resultValue") + ",");
                System.out.flush();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void resetPeakMemoryUsage() {
        long wasFree;
        Runtime rt = Runtime.getRuntime();
        long isFree = rt.freeMemory();
        do {
            wasFree = isFree;
            rt.runFinalization();
            rt.gc();
        } while ((isFree = rt.freeMemory()) > wasFree);
        this._beforeHeapMemoryUsage = 0L;
        for (MemoryPoolMXBean b : ManagementFactory.getMemoryPoolMXBeans()) {
            b.resetPeakUsage();
            if (b.getType() != MemoryType.HEAP) continue;
            this._beforeHeapMemoryUsage += b.getPeakUsage().getUsed();
        }
    }

    private void setPeakMemoryUsage(DriverImpl driver) {
        long afterHeapMemoryUsage = 0L;
        for (MemoryPoolMXBean b : ManagementFactory.getMemoryPoolMXBeans()) {
            if (b.getType() != MemoryType.HEAP) continue;
            afterHeapMemoryUsage += b.getPeakUsage().getUsed();
        }
        driver.setDoubleParam("japex.peakHeapUsage", (double)(afterHeapMemoryUsage - this._beforeHeapMemoryUsage) / 1024.0);
    }

    private List<Long> getGCAbsoluteTimes() {
        ArrayList<Long> gCTimes = new ArrayList<Long>();
        for (GarbageCollectorMXBean gcc : this._gCCollectors) {
            gCTimes.add(gcc.getCollectionTime());
        }
        return gCTimes;
    }

    private long getGCRelativeTotalTime(List<Long> start) {
        List<Long> end = this.getGCAbsoluteTimes();
        long time = 0L;
        for (int i = 0; i < start.size(); ++i) {
            time += end.get(i) - start.get(i);
        }
        return time;
    }

    private double computeResultValue(TestCase tc, int nOfThreads, int nOfCpus) {
        String resultUnit = this._testSuite.getParam("japex.resultUnit");
        if (Japex.verbose) {
            System.out.println("             " + Thread.currentThread().getName() + " japex.runIterationsSum = " + tc.getLongParam("japex.runIterationsSum"));
            System.out.println("             " + Thread.currentThread().getName() + " japex.runTimeSum (ms) = " + tc.getDoubleParam("japex.runTimeSum"));
        }
        double actualTime = tc.getDoubleParam("japex.actualRunTime");
        double tps = (double)tc.getLongParam("japex.runIterationsSum") / (actualTime / 1000.0);
        double l = (double)Math.min(nOfCpus, nOfThreads) / tps * 1000.0;
        if (resultUnit == null || resultUnit.equalsIgnoreCase("tps")) {
            return tps;
        }
        if (resultUnit.equalsIgnoreCase("ms")) {
            return l;
        }
        if (resultUnit.equalsIgnoreCase("mbps")) {
            String inputFile = tc.getParam("japex.inputFile");
            if (inputFile == null) {
                throw new RuntimeException("Unable to compute japex.resultValue  because japex.inputFile is not defined or refers to an illegal path.");
            }
            return (double)new File(inputFile).length() * 8.0E-6 * tps;
        }
        if (resultUnit.equalsIgnoreCase("%GCTIME")) {
            double gctime = (double)this._gCTime / actualTime * 100.0;
            this._testSuite.setParam("japex.resultUnitX", "ms");
            tc.setDoubleParam("japex.resultValueX", l);
            return gctime;
        }
        throw new RuntimeException("Unknown value '" + resultUnit + "' for global param japex.resultUnit.");
    }

    private int[] estimateRunningTime(TestSuiteImpl testSuite) {
        int nOfDrivers = testSuite.getDriverInfoList().size();
        int nOfTests = testSuite.getDriverInfoList().get(0).getTestCases(0).size();
        String runTime = testSuite.getParam("japex.runTime");
        String warmupTime = testSuite.getParam("japex.warmupTime");
        int actualRuns = testSuite.getIntParam("japex.runsPerDriver") + testSuite.getIntParam("japex.warmupsPerDriver");
        long seconds = (long)((double)(nOfDrivers * nOfTests) * ((double)Util.parseDuration(warmupTime) / 1000.0) + (double)(nOfDrivers * nOfTests) * ((double)Util.parseDuration(runTime) / 1000.0)) * (long)actualRuns;
        int[] hms = new int[]{(int)(seconds / 60L / 60L), (int)(seconds / 60L % 60L), (int)(seconds % 60L)};
        return hms;
    }
}

