/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.ChartGenerator;
import com.sun.japex.ConfigFileLoader;
import com.sun.japex.Engine;
import com.sun.japex.TestSuiteImpl;
import com.sun.japex.Util;
import com.sun.japex.testsuite.TestSuiteElement;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Japex {
    public static boolean html = true;
    public static boolean verbose = false;
    public static boolean resultPerLine = false;
    public static boolean test = false;
    public static boolean last = false;
    public static int exitCode = 0;
    public static Date TODAY = new Date();
    private static String identityTx = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template></xsl:stylesheet>";

    public void setHtml(boolean html) {
        Japex.html = html;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            Japex.displayUsageAndExit();
        }
        boolean merge = false;
        ArrayList<String> configFiles = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-nohtml")) {
                html = false;
                continue;
            }
            if (args[i].equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-line")) {
                resultPerLine = true;
                continue;
            }
            if (args[i].equals("-test")) {
                test = true;
                continue;
            }
            if (args[i].equals("-last")) {
                last = true;
                continue;
            }
            if (args[i].equals("-merge")) {
                merge = true;
                continue;
            }
            configFiles.add(args[i]);
        }
        if (configFiles.isEmpty()) {
            Japex.displayUsageAndExit();
        }
        if (configFiles.size() > 1 && !merge) {
            Japex.displayUsageAndExit();
        }
        new Japex().run(configFiles);
        System.exit(exitCode);
    }

    private static void displayUsageAndExit() {
        System.err.println("Usage: japex [-verbose] [-nohtml] [-line] [-test] [-merge] japex-config-file(s)\n   -verbose: Display additional information about the benchmark's execution\n   -nohtml : Do not generate HTML report (only XML report)\n   -line   : Insert additional newlines to separate test case results\n   -test   : Test configuration file without producing any output reports\n   -last   : Copy the report directory into a directory named 'last'\n   -merge  : Merge japex-config-files\n             An error will result if this option is absent and more than one\n             japex-config-file is present");
        System.exit(1);
    }

    public void run(String configFile) {
        this.run(Collections.singletonList(configFile));
    }

    public void run(List<String> configFiles) {
        try {
            TestSuiteImpl testSuite = new Engine().start(configFiles);
            if (test) {
                return;
            }
            String fileSep = System.getProperty("file.separator");
            SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm");
            String outputDir = testSuite.getParam("japex.reportsDirectory") + fileSep + df.format(TODAY);
            String lastDir = testSuite.getParam("japex.reportsDirectory") + fileSep + "last";
            StringBuffer report = new StringBuffer();
            testSuite.serialize(report);
            new File(outputDir).mkdirs();
            System.out.println("Generating reports ...");
            System.out.println("  " + new File(outputDir + "/" + "report.xml").toURL());
            OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(new File(outputDir + fileSep + "report.xml")));
            osw.write(report.toString());
            osw.close();
            TestSuiteElement testSuiteElement = testSuite.getTestSuiteElement();
            Marshaller m = ConfigFileLoader.context.createMarshaller();
            File configOutput = new File(outputDir + fileSep + testSuite.getParam("japex.configFile"));
            m.marshal((Object)testSuite.getTestSuiteElement(), (OutputStream)new FileOutputStream(configOutput));
            if (!html) {
                if (last) {
                    Util.copyDirectory(new File(outputDir), new File(lastDir));
                }
                return;
            }
            String resultChart = "result.jpg";
            ChartGenerator chartGenerator = new ChartGenerator(testSuite);
            chartGenerator.generateDriverChart(outputDir + fileSep + "result.jpg");
            String testCaseChartBase = "testcase";
            int nOfCharts = chartGenerator.generateTestCaseCharts(outputDir + fileSep + "testcase", ".jpg");
            StringBuffer extendedReport = new StringBuffer();
            extendedReport.append("<extendedTestSuiteReport xmlns=\"http://www.sun.com/japex/extendedTestSuiteReport\">\n").append(" <resultChart>result.jpg</resultChart>\n");
            for (int i = 0; i < nOfCharts; ++i) {
                extendedReport.append(" <testCaseChart>testcase" + i + ".jpg" + "</testCaseChart>\n");
            }
            extendedReport.append(report);
            extendedReport.append("</extendedTestSuiteReport>\n");
            URL stylesheet = this.getClass().getResource("/resources/report.xsl");
            if (stylesheet != null) {
                int c;
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer(new StreamSource(stylesheet.toExternalForm()));
                System.out.println("  " + new File(outputDir + "/" + "report.html").toURL());
                File htmlReport = new File(outputDir + fileSep + "report.html");
                transformer.transform(new StreamSource(new StringReader(extendedReport.toString())), new StreamResult(new FileOutputStream(htmlReport)));
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(htmlReport));
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(outputDir + fileSep + "index.html")));
                while ((c = ((InputStream)is).read()) != -1) {
                    ((OutputStream)os).write(c);
                }
                ((InputStream)is).close();
                ((OutputStream)os).close();
                Util.copyResource("report.css", outputDir, fileSep);
                Util.copyResource("small_japex.gif", outputDir, fileSep);
                if (last) {
                    Util.copyDirectory(new File(outputDir), new File(lastDir));
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

