/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.DriverImpl;
import com.sun.japex.JapexDriverBase;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;

class JapexClassLoader
extends URLClassLoader {
    public JapexClassLoader(String classPath) {
        super(new URL[0], (ClassLoader)null);
        this.initialize(classPath);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("com.sun.japex.") && !name.startsWith("com.sun.japex.jdsl.")) {
            return DriverImpl.class.getClassLoader().loadClass(name);
        }
        return super.findClass(name);
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    public JapexDriverBase getJapexDriver(String className) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(className, true, this);
            return (JapexDriverBase)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Class '" + className + "' must extend '" + JapexDriverBase.class.getName() + "'");
        }
    }

    private void initialize(String classPath) {
        if (classPath == null) {
            return;
        }
        String pathSep = System.getProperty("path.separator");
        String fileSep = System.getProperty("file.separator");
        StringTokenizer tokenizer = new StringTokenizer(classPath, pathSep);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                File file;
                boolean lookForJars = false;
                if (path.endsWith("*.jar")) {
                    int k = path.lastIndexOf(47);
                    path = k >= 0 ? path.substring(0, k + 1) : "./";
                    lookForJars = true;
                }
                if ((file = new File(path)).isDirectory() && lookForJars) {
                    String[] children;
                    for (String c : children = file.list(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".jar");
                        }
                    })) {
                        this.addURL(new File(path + fileSep + c).toURL());
                    }
                    continue;
                }
                this.addURL(file.toURL());
            }
            catch (MalformedURLException e) {}
        }
    }
}

