/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.Driver;
import com.sun.japex.Japex;
import com.sun.japex.JapexDriver;
import com.sun.japex.Params;
import com.sun.japex.TestCase;
import com.sun.japex.TestCaseImpl;
import com.sun.japex.TestSuiteImpl;
import com.sun.japex.Util;

public class JapexDriverBase
implements JapexDriver,
Params {
    protected Driver _driver;
    protected TestSuiteImpl _testSuite;
    protected TestCaseImpl _testCase;
    protected boolean _needWarmup = true;
    protected double _endTime;

    public void setDriver(Driver driver) {
        this._driver = driver;
    }

    public void setTestSuite(TestSuiteImpl testSuite) {
        this._testSuite = testSuite;
    }

    public void setTestCase(TestCaseImpl testCase) {
        this._testCase = testCase;
        this._needWarmup = true;
    }

    protected TestSuiteImpl getTestSuite() {
        return this._testSuite;
    }

    public void setEndTime(double endTime) {
        this._endTime = endTime;
    }

    public void prepare() {
        if (Japex.verbose) {
            System.out.println("             " + Thread.currentThread().getName() + " prepare()");
        }
        TestCaseImpl tc = this._testCase;
        double millis = Util.currentTimeMillis();
        this.prepare(tc);
        tc.setDoubleParam("japex.actualPrepareTime", Util.currentTimeMillis() - millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmup() {
        double duration;
        if (Japex.verbose) {
            System.out.println("             " + Thread.currentThread().getName() + " warmup()");
        }
        TestCaseImpl tc = this._testCase;
        long warmupIterations = 0L;
        if (tc.hasParam("japex.warmupTime")) {
            double millis;
            double startTime = millis = Util.currentTimeMillis();
            while (this._endTime > millis) {
                this.warmup(tc);
                ++warmupIterations;
                millis = Util.currentTimeMillis();
            }
            duration = millis - startTime;
        } else {
            warmupIterations = tc.getLongParam("japex.warmupIterations");
            double startTime = Util.currentTimeMillis();
            for (long i = 0L; i < warmupIterations; ++i) {
                this.warmup(tc);
            }
            duration = Util.currentTimeMillis() - startTime;
        }
        TestCaseImpl testCaseImpl = tc;
        synchronized (testCaseImpl) {
            long warmupIterationsSum = tc.hasParam("japex.warmupIterationsSum") ? tc.getLongParam("japex.warmupIterationsSum") : 0L;
            tc.setLongParam("japex.warmupIterationsSum", warmupIterationsSum + warmupIterations);
            double warmupTimeSum = tc.hasParam("japex.warmupTimeSum") ? tc.getDoubleParam("japex.warmupTimeSum") : 0.0;
            tc.setDoubleParam("japex.warmupTimeSum", warmupTimeSum + duration);
        }
        if (Japex.verbose) {
            System.out.println("               " + Thread.currentThread().getName() + " japex.actualWarmupIterations = " + warmupIterations);
            System.out.println("               " + Thread.currentThread().getName() + " japex.actualWarmupTime (ms) = " + duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        double duration;
        if (Japex.verbose) {
            System.out.println("             " + Thread.currentThread().getName() + " run()");
        }
        TestCaseImpl tc = this._testCase;
        long runIterations = 0L;
        if (tc.hasParam("japex.runTime")) {
            double millis;
            double startTime = Util.currentTimeMillis();
            do {
                this.run(tc);
                ++runIterations;
            } while (this._endTime >= (millis = Util.currentTimeMillis()));
            duration = millis - startTime;
        } else {
            runIterations = tc.getLongParam("japex.runIterations");
            double startTime = Util.currentTimeMillis();
            for (long i = 0L; i < runIterations; ++i) {
                this.run(tc);
            }
            duration = Util.currentTimeMillis() - startTime;
        }
        TestCaseImpl testCaseImpl = tc;
        synchronized (testCaseImpl) {
            long runIterationsSum = tc.hasParam("japex.runIterationsSum") ? tc.getLongParam("japex.runIterationsSum") : 0L;
            tc.setLongParam("japex.runIterationsSum", runIterationsSum + runIterations);
            double runTimeSum = tc.hasParam("japex.runTimeSum") ? tc.getDoubleParam("japex.runTimeSum") : 0.0;
            tc.setDoubleParam("japex.runTimeSum", runTimeSum + duration);
        }
        if (Japex.verbose) {
            System.out.println("               " + Thread.currentThread().getName() + " japex.actualRunIterations = " + runIterations);
            System.out.println("               " + Thread.currentThread().getName() + " japex.actualRunTime (ms) = " + duration);
        }
    }

    public void finish() {
        if (Japex.verbose) {
            System.out.println("             " + Thread.currentThread().getName() + " finish()");
        }
        this.finish(this._testCase);
    }

    public Object call() {
        if (this._needWarmup) {
            this.warmup();
            this._needWarmup = false;
        } else {
            this.run();
            this._needWarmup = true;
        }
        return null;
    }

    public boolean hasParam(String name) {
        return this._driver.hasParam(name);
    }

    public void setParam(String name, String value) {
        this._driver.setParam(name, value);
    }

    public String getParam(String name) {
        return this._driver.getParam(name);
    }

    public void setBooleanParam(String name, boolean value) {
        this._driver.setBooleanParam(name, value);
    }

    public boolean getBooleanParam(String name) {
        return this._driver.getBooleanParam(name);
    }

    public void setIntParam(String name, int value) {
        this._driver.setIntParam(name, value);
    }

    public int getIntParam(String name) {
        return this._driver.getIntParam(name);
    }

    public void setLongParam(String name, long value) {
        this._driver.setLongParam(name, value);
    }

    public long getLongParam(String name) {
        return this._driver.getLongParam(name);
    }

    public void setDoubleParam(String name, double value) {
        this._driver.setDoubleParam(name, value);
    }

    public double getDoubleParam(String name) {
        return this._driver.getDoubleParam(name);
    }

    public void initializeDriver() {
    }

    public void prepare(TestCase testCase) {
    }

    public void warmup(TestCase testCase) {
        this.run(testCase);
    }

    public void run(TestCase testCase) {
    }

    public void finish(TestCase testCase) {
    }

    public void terminateDriver() {
    }
}

