/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.Params;
import com.sun.japex.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.Execute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamsImpl
implements Params {
    static final int OUT_EXPR = 0;
    static final int IN_EXPR = 1;
    static final String DELIMITER = "\ufffe";
    Map<String, Object> _mapping = new HashMap<String, Object>();
    ParamsImpl _defaults = null;
    private static Vector ENV = Execute.getProcEnvironment();

    public ParamsImpl() {
    }

    public ParamsImpl(Properties props) {
        for (String string : props.keySet()) {
            this.convertAndPut(string, props.getProperty(string));
        }
    }

    public ParamsImpl(ParamsImpl defaults) {
        this._defaults = defaults;
    }

    public boolean isGlobal() {
        return this._defaults == null;
    }

    private void convertAndPut(String key, String value) {
        if (value.equals("true") || value.equals("false")) {
            this._mapping.put(key, new Boolean(value));
        } else {
            try {
                long l = Long.parseLong(value);
                this._mapping.put(key, new Long(l));
            }
            catch (NumberFormatException e1) {
                try {
                    double d = Double.parseDouble(value);
                    this._mapping.put(key, new Double(d));
                }
                catch (NumberFormatException e2) {
                    this._mapping.put(key, value);
                }
            }
        }
    }

    public Object clone() {
        try {
            ParamsImpl clone = (ParamsImpl)super.clone();
            clone._mapping = new HashMap<String, Object>();
            for (String key : this._mapping.keySet()) {
                clone._mapping.put(key, this._mapping.get(key));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> nameSet() {
        return this._mapping.keySet();
    }

    private Object getParamOrDefault(String name) {
        Object value = this._mapping.get(name);
        if (value == null && this._defaults != null) {
            value = this._defaults.getParamOrDefault(name);
        }
        return value;
    }

    @Override
    public synchronized boolean hasParam(String name) {
        return this.getParamOrDefault(name) != null;
    }

    public synchronized boolean hasLocalParam(String name) {
        ParamsImpl params = this;
        do {
            if (params._mapping.get(name) == null) continue;
            return true;
        } while (!(params = params._defaults).isGlobal());
        return false;
    }

    public synchronized void removeParam(String name) {
        if (this.hasParam(name)) {
            this._mapping.remove(name);
        } else if (this._defaults != null) {
            this._defaults.removeParam(name);
        }
    }

    @Override
    public synchronized void setParam(String name, String value) {
        this.convertAndPut(name, this.evaluate(name, value));
    }

    @Override
    public synchronized String getParam(String name) {
        Object value = this.getParamOrDefault(name);
        if (value instanceof Long) {
            value = ((Long)value).toString();
        } else if (value instanceof Double) {
            value = Util.formatDouble((Double)value);
        } else if (value instanceof Boolean) {
            value = ((Boolean)value).toString();
        }
        return (String)value;
    }

    @Override
    public synchronized void setBooleanParam(String name, boolean value) {
        this._mapping.put(name, new Boolean(value));
    }

    @Override
    public synchronized boolean getBooleanParam(String name) {
        Object value = this.getParamOrDefault(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf((String)value);
    }

    @Override
    public synchronized void setIntParam(String name, int value) {
        this._mapping.put(name, new Long(value));
    }

    @Override
    public synchronized int getIntParam(String name) {
        Object value = this.getParamOrDefault(name);
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        try {
            return Integer.parseInt((String)value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void setLongParam(String name, long value) {
        this._mapping.put(name, new Long(value));
    }

    @Override
    public synchronized long getLongParam(String name) {
        Object value = this.getParamOrDefault(name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Double) {
            return ((Double)value).longValue();
        }
        return Long.parseLong((String)value);
    }

    @Override
    public synchronized void setDoubleParam(String name, double value) {
        this._mapping.put(name, new Double(value));
    }

    @Override
    public synchronized double getDoubleParam(String name) {
        Object value = this.getParamOrDefault(name);
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return Double.parseDouble((String)value);
    }

    public synchronized double getDoubleParamNoNaN(String name) {
        double result = this.getDoubleParam(name);
        return Double.isNaN(result) ? 0.0 : result;
    }

    private static void collectGroupParams(ArrayList<String> groupParams, ParamsImpl params) {
        if (params.isGlobal()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(params._mapping.keySet());
        for (String s : names) {
            if (groupParams.contains(s)) continue;
            groupParams.add(s);
        }
        ParamsImpl.collectGroupParams(groupParams, params._defaults);
    }

    public void serialize(StringBuffer buffer, int indent) {
        ArrayList<String> paramNames;
        if (this.isGlobal()) {
            paramNames = new ArrayList<String>(this._mapping.keySet());
        } else {
            paramNames = new ArrayList<String>();
            ParamsImpl.collectGroupParams(paramNames, this);
        }
        Collections.sort(paramNames);
        for (String name : paramNames) {
            if (!name.startsWith("japex.")) continue;
            String xmlName = name.substring(name.indexOf(46) + 1);
            if (name.equals("japex.classPath")) {
                buffer.append(Util.getSpaces(indent) + "<" + xmlName + ">" + this.getParam(name).replaceAll(System.getProperty("path.separator"), "\n") + "</" + xmlName + ">\n");
                continue;
            }
            buffer.append(Util.getSpaces(indent) + "<" + xmlName + ">" + this.getParam(name) + "</" + xmlName + ">\n");
        }
        for (String name : paramNames) {
            if (name.startsWith("japex.")) continue;
            buffer.append(Util.getSpaces(indent) + "<" + name + " xmlns=\"\">" + this.getParam(name) + "</" + name + ">\n");
        }
    }

    private String evaluate(String name, String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, "${}", true);
        String t = null;
        StringBuffer buffer = new StringBuffer();
        int state = 0;
        block12: while (tokenizer.hasMoreTokens()) {
            t = tokenizer.nextToken();
            if (t.length() == 1) {
                switch (t.charAt(0)) {
                    case '$': {
                        switch (state) {
                            case 0: {
                                t = tokenizer.nextToken();
                                if (t.equals("{")) {
                                    buffer.append(DELIMITER);
                                    state = 1;
                                    break;
                                }
                                buffer.append("$" + t);
                                break;
                            }
                            case 1: {
                                buffer.append('$');
                            }
                        }
                        continue block12;
                    }
                    case '}': {
                        switch (state) {
                            case 0: {
                                buffer.append('}');
                                break;
                            }
                            case 1: {
                                buffer.append(DELIMITER);
                                state = 0;
                            }
                        }
                        continue block12;
                    }
                }
                buffer.append(t);
                continue;
            }
            buffer.append(t);
        }
        if (state != 0) {
            throw new RuntimeException("Error evaluating parameter '" + name + "' of value '" + value + "'");
        }
        tokenizer = new StringTokenizer(buffer.toString(), DELIMITER, true);
        StringBuffer result = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            t = tokenizer.nextToken();
            if (t.equals(DELIMITER)) {
                String paramName = tokenizer.nextToken();
                String paramValue = this.getParam(paramName);
                if (paramValue != null) {
                    result.append(paramValue);
                } else {
                    paramValue = System.getProperty(paramName);
                    if (paramValue != null) {
                        result.append(paramValue);
                    } else {
                        paramValue = this.getEnvVariable(paramName);
                        if (paramValue != null) {
                            result.append(paramValue);
                        } else {
                            throw new RuntimeException("Undefined parameter, property or environment variable '" + paramName + "'");
                        }
                    }
                }
                tokenizer.nextToken();
                continue;
            }
            result.append(t);
        }
        return result.toString();
    }

    private String getEnvVariable(String name) {
        for (int i = 0; i < ENV.size(); ++i) {
            String def = (String)ENV.get(i);
            int k = def.indexOf(61);
            if (k <= 0 || !name.equals(def.substring(0, k))) continue;
            return def.substring(k + 1);
        }
        return null;
    }
}

