/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

public class RegressionDetector {
    private double threshold = -1.0;
    private URL baseURL;
    private File oldReport;
    private File newReport;
    private static final TransformerFactory tf = TransformerFactory.newInstance();
    private static final Templates REGRESSION_REPORT;
    private static final Templates REGRESSION_REPORT_HTML;

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public void setOldReport(File oldReport) {
        this.oldReport = oldReport;
    }

    public void setNewReport(File newReport) {
        this.newReport = newReport;
    }

    public boolean checkThreshold(Source xmlReport) {
        try {
            DOMResult dom = new DOMResult();
            tf.newTransformer().transform(xmlReport, dom);
            XPath query = XPathFactory.newInstance().newXPath();
            query.setNamespaceContext(new NamespaceContext(){

                public String getNamespaceURI(String prefix) {
                    return prefix.equals("reg") ? "http://www.sun.com/japex/regressionReport" : null;
                }

                public String getPrefix(String namespaceURI) {
                    return null;
                }

                public Iterator getPrefixes(String namespaceURI) {
                    return null;
                }
            });
            Object o = query.evaluate("/reg:regressionReport/@notify", dom.getNode(), XPathConstants.STRING);
            return o.equals("true");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void generateXmlReport(File outputReportXmlFile) throws IOException {
        try {
            Transformer transformer = REGRESSION_REPORT.newTransformer();
            System.out.println("Input reports: ");
            transformer.setParameter("threshold", Double.toString(this.threshold));
            transformer.setParameter("lastReport", this.oldReport.toURL().toExternalForm());
            transformer.setParameter("nextReport", this.newReport.toURL().toExternalForm());
            if (this.baseURL != null) {
                transformer.setParameter("lastReportHref", this.getHref(this.oldReport));
                transformer.setParameter("nextReportHref", this.getHref(this.newReport));
            }
            transformer.transform(new StreamSource(new StringReader("<foo/>")), new StreamResult(outputReportXmlFile));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private String getHref(File reportXml) throws MalformedURLException {
        String fileName = reportXml.getPath();
        String href = fileName.substring(0, fileName.lastIndexOf(46)) + ".html";
        return new URL(this.baseURL, href).toExternalForm();
    }

    public void generateHtmlReport(File xmlReport, File htmlReport) throws IOException {
        this.generateHtmlReport(new StreamSource(xmlReport), new StreamResult(htmlReport));
    }

    public void generateHtmlReport(Source xmlReport, Result htmlReport) throws IOException {
        try {
            Transformer transformer = REGRESSION_REPORT_HTML.newTransformer();
            transformer.transform(xmlReport, htmlReport);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            URL stylesheet = RegressionDetector.class.getResource("/resources/regression-report.xsl");
            REGRESSION_REPORT = tf.newTemplates(new StreamSource(stylesheet.toExternalForm()));
            stylesheet = RegressionDetector.class.getResource("/resources/regression-report-html.xsl");
            REGRESSION_REPORT_HTML = tf.newTemplates(new StreamSource(stylesheet.toExternalForm()));
        }
        catch (TransformerConfigurationException e) {
            throw new Error(e);
        }
    }
}

