/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.RegressionDetector;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.xml.transform.stream.StreamSource;

public class RegressionTracker {
    private File outputDirectory;
    private File reportsDirectory;
    private final RegressionDetector detector = new RegressionDetector();

    public static void main(String[] args) {
        new RegressionTracker().run(args);
    }

    private static void displayUsageAndExit() {
        System.err.println("Usage: regression-tracker [-threshold percentage] [-baseurl URL] reports-directory output-directory");
        System.exit(1);
    }

    public void parseCommandLine(String[] args) {
        try {
            int i;
            if (args.length < 2 || args.length > 6) {
                RegressionTracker.displayUsageAndExit();
            }
            for (i = 0; i < args.length; ++i) {
                if (args[i].equals("-threshold")) {
                    this.detector.setThreshold(Double.parseDouble(args[++i]));
                    continue;
                }
                if (!args[i].equals("-baseurl")) break;
                this.detector.setBaseURL(new URL(args[++i]));
            }
            if (i != args.length - 2) {
                RegressionTracker.displayUsageAndExit();
            }
            this.reportsDirectory = new File(args[args.length - 2]);
            this.outputDirectory = new File(args[args.length - 1]);
        }
        catch (NumberFormatException e) {
            RegressionTracker.displayUsageAndExit();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            RegressionTracker.displayUsageAndExit();
        }
        catch (MalformedURLException e) {
            RegressionTracker.displayUsageAndExit();
        }
    }

    public void run(String[] args) {
        try {
            Object[] files;
            this.parseCommandLine(args);
            if (!this.reportsDirectory.isDirectory() || !this.reportsDirectory.canWrite()) {
                System.err.println("Error: Reports directory '" + this.reportsDirectory + "' is not a valid directory");
                System.exit(1);
            }
            if (!this.outputDirectory.exists()) {
                this.outputDirectory.mkdir();
            }
            if (!this.outputDirectory.isDirectory() || !this.outputDirectory.canWrite()) {
                System.err.println("Error: Output directory '" + this.outputDirectory + "' is not a valid directory");
                System.exit(1);
            }
            if ((files = this.reportsDirectory.list(new FilenameFilter(){

                public boolean accept(File f, String n) {
                    return n.length() == 16 && n.charAt(4) == '_' && n.charAt(7) == '_' && n.charAt(10) == '_' && n.charAt(13) == '_';
                }
            })).length < 2) {
                System.err.println("Error: Not enough reports in '" + this.reportsDirectory + "' to generate regression report");
                System.exit(1);
            }
            Arrays.sort(files);
            File lastReport = new File(new File(this.reportsDirectory, (String)files[files.length - 2]), "report.xml");
            File nextReport = new File(new File(this.reportsDirectory, (String)files[files.length - 1]), "report.xml");
            this.detector.setOldReport(lastReport);
            this.detector.setNewReport(nextReport);
            File outputReportXml = new File(this.outputDirectory, "report.xml");
            System.out.println("\t" + lastReport.toURL());
            System.out.println("\t" + nextReport.toURL());
            System.out.println("Output reports: ");
            System.out.println("\t" + outputReportXml.toURL());
            this.detector.generateXmlReport(outputReportXml);
            File outputReportHtml = new File(this.outputDirectory, "report.html");
            System.out.println("\t" + outputReportHtml.toURL());
            this.detector.generateHtmlReport(outputReportXml, outputReportHtml);
            this.copyResource("report.css", this.outputDirectory);
            this.copyResource("small_japex.gif", this.outputDirectory);
            if (this.detector.checkThreshold(new StreamSource(outputReportXml))) {
                this.sendMail(outputReportHtml);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sendMail(File htmlReport) throws IOException {
        int c;
        StringBuffer htmlBuffer = new StringBuffer();
        FileReader reader = new FileReader(htmlReport);
        while ((c = reader.read()) != -1) {
            htmlBuffer.append((char)c);
        }
        RegressionTracker.sendMail(htmlBuffer.toString());
    }

    private static void sendMail(String body) {
        try {
            Properties props = System.getProperties();
            String host = RegressionTracker.checkProperty("mail.smtp.host", true);
            String recipients = RegressionTracker.checkProperty("mail.recipients", true);
            String subject = RegressionTracker.checkProperty("mail.subject", false);
            props.put("mail.smtp.host", host);
            Session session = Session.getDefaultInstance((Properties)props, null);
            MimeMessage msg = new MimeMessage(session);
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipients, (boolean)false));
            msg.setSubject(subject);
            msg.setText(body);
            msg.setHeader("Content-Type", "text/html");
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            System.out.println("E-mail message sent to '" + recipients + "'");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void copyResource(String basename, File outputDir) {
        try {
            URL css = this.getClass().getResource("/resources/" + basename);
            if (css != null) {
                int c;
                InputStream is = css.openStream();
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(outputDir, basename)));
                while ((c = is.read()) != -1) {
                    ((OutputStream)os).write(c);
                }
                is.close();
                ((OutputStream)os).close();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String checkProperty(String name, boolean error) {
        String value = System.getProperty(name);
        if (value == null) {
            System.err.println((error ? "Error: " : "Warning: ") + "Property '" + name + "' not set");
            if (error) {
                System.exit(1);
            }
        }
        return value;
    }
}

