/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.ConfigFileLoader;
import com.sun.japex.DriverImpl;
import com.sun.japex.Japex;
import com.sun.japex.ParamsImpl;
import com.sun.japex.TestCaseArrayList;
import com.sun.japex.TestCaseImpl;
import com.sun.japex.TestSuite;
import com.sun.japex.testsuite.DescriptionElement;
import com.sun.japex.testsuite.DriverElement;
import com.sun.japex.testsuite.DriverGroupElement;
import com.sun.japex.testsuite.ParamElement;
import com.sun.japex.testsuite.ParamGroupElement;
import com.sun.japex.testsuite.TestCaseElement;
import com.sun.japex.testsuite.TestCaseGroupElement;
import com.sun.japex.testsuite.TestSuiteElement;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteImpl
extends ParamsImpl
implements TestSuite {
    static final String PATH_SEPARATOR = System.getProperty("path.separator");
    TestSuiteElement _testSuiteElement;
    String _name;
    List<DriverImpl> _driverList = new ArrayList<DriverImpl>();
    List<DriverImpl> _baseDriversUsed = new ArrayList<DriverImpl>();
    String _description;

    public TestSuiteImpl(TestSuiteElement ts) {
        int runsPerDriver;
        this._testSuiteElement = ts;
        this._name = ts.getName();
        this._description = this.marshalDescription(this._testSuiteElement.getDescription());
        List<ParamElement> params = this.createParamList(ts.getParamOrParamGroup());
        if (params != null) {
            for (ParamElement pt : params) {
                String name = pt.getName();
                String value = pt.getValue();
                String oldValue = this.getParam(name);
                this.setParam(name, name.equals("japex.classPath") && oldValue != null ? oldValue + PATH_SEPARATOR + value : value);
            }
        }
        this.readAndSetSystemProperties();
        if (!this.hasParam("japex.warmupTime") && !this.hasParam("japex.warmupIterations")) {
            this.setParam("japex.warmupIterations", "300");
        }
        if (!this.hasParam("japex.runTime") && !this.hasParam("japex.runIterations")) {
            this.setParam("japex.runIterations", "300");
        }
        if (!this.hasParam("japex.reportsDirectory")) {
            this.setParam("japex.reportsDirectory", "reports");
        }
        if (!this.hasParam("japex.chartType")) {
            this.setParam("japex.chartType", "barchart");
        } else {
            String chartType = this.getParam("japex.chartType");
            if (!(chartType.equalsIgnoreCase("barchart") || chartType.equalsIgnoreCase("scatterchart") || chartType.equalsIgnoreCase("linechart"))) {
                throw new RuntimeException("Parameter 'japex.chartType' must be set to 'barchart', 'scatterchart' or 'linechart'");
            }
        }
        if (!this.checkResultAxis("japex.resultAxis") || !this.checkResultAxis("japex.resultAxisX")) {
            throw new RuntimeException("Parameter 'japex.resultAxis' and 'japex.resultAxisX' must be set to either 'normal' or 'logarithmic'");
        }
        if (!this.hasParam("japex.resultUnit")) {
            this.setParam("japex.resultUnit", "TPS");
        }
        if (!this.hasParam("japex.plotDrivers")) {
            this.setParam("japex.plotDrivers", "false");
        }
        if (!this.hasParam("japex.plotGroupSize")) {
            this.setParam("japex.plotGroupSize", "5");
        }
        if (!this.hasParam("japex.numberOfThreads")) {
            this.setParam("japex.numberOfThreads", "1");
        } else {
            int nOfThreads = this.getIntParam("japex.numberOfThreads");
            if (nOfThreads < 1) {
                throw new RuntimeException("Parameter 'japex.numberOfThreads' must be at least 1");
            }
        }
        if (!this.hasParam("japex.runsPerDriver")) {
            this.setParam("japex.runsPerDriver", "1");
        }
        if ((runsPerDriver = this.getIntParam("japex.runsPerDriver")) < 1) {
            throw new RuntimeException("Parameter 'japex.runsPerDriver' must be at least 1");
        }
        if (this.hasParam("japex.includeWarmupRun")) {
            System.err.print("Warning: Parameter 'japex.includeWarmupRun' is deprecated, use 'japex.warmupsPerDriver' instead.");
        }
        if (!this.hasParam("japex.warmupsPerDriver")) {
            this.setIntParam("japex.warmupsPerDriver", runsPerDriver > 1 ? 1 : 0);
        }
        this.setParam("japex.version", "1.0.25");
        this.setParam("japex.osName", System.getProperty("os.name"));
        this.setParam("japex.osArchitecture", System.getProperty("os.arch"));
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy/HH:mm:ss z", Locale.ENGLISH);
        this.setParam("japex.dateTime", df.format(Japex.TODAY));
        this.setParam("japex.vmInfo", System.getProperty("java.vendor") + " " + System.getProperty("java.vm.version"));
        this.setIntParam("japex.numberOfCpus", Runtime.getRuntime().availableProcessors());
        String hostName = "<unknown>";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        this.setParam("japex.hostName", hostName);
        this._driverList = this.createDriverList(ts.getDriverOrDriverGroup(), this);
        for (DriverImpl driverInfo : this._baseDriversUsed) {
            this._driverList.remove(driverInfo);
        }
        TestCaseArrayList testCases = this.createTestCaseList(ts.getTestCaseOrTestCaseGroup(), this);
        if (Japex.test) {
            this.setIntParam("japex.warmupsPerDriver", 0);
            this.setIntParam("japex.runsPerDriver", 1);
            this.removeParam("japex.warmupTime");
            this.removeParam("japex.runTime");
            for (TestCaseImpl tc : testCases) {
                tc.removeParam("japex.warmupTime");
                tc.removeParam("japex.runTime");
                tc.setIntParam("japex.warmupIterations", 0);
                tc.setIntParam("japex.runIterations", 1);
            }
        }
        for (DriverImpl di : this._driverList) {
            di.setTestCases(testCases);
        }
    }

    private TestCaseArrayList createTestCaseList(List<Object> testCaseOrTestGroup, ParamsImpl defaults) {
        TestCaseArrayList result = new TestCaseArrayList();
        for (Object o : testCaseOrTestGroup) {
            if (o instanceof TestCaseElement) {
                TestCaseElement tc = (TestCaseElement)o;
                TestCaseImpl testCase = new TestCaseImpl(tc.getName(), defaults);
                for (ParamElement pt : this.createParamList(tc.getParamOrParamGroup())) {
                    testCase.setParam(pt.getName(), pt.getValue());
                }
                result.add(testCase);
                continue;
            }
            TestCaseGroupElement testCaseGroup = (TestCaseGroupElement)o;
            ParamsImpl groupScope = new ParamsImpl(defaults);
            for (ParamElement pt : this.createParamList(testCaseGroup.getParamOrParamGroup())) {
                groupScope.setParam(pt.getName(), pt.getValue());
            }
            result.addAll(this.createTestCaseList(testCaseGroup.getTestCaseOrTestCaseGroup(), groupScope));
        }
        return result;
    }

    private List<DriverImpl> createDriverList(List<Object> driverOrDriverGroup, ParamsImpl defaults) {
        ArrayList<DriverImpl> result = new ArrayList<DriverImpl>();
        for (Object o : driverOrDriverGroup) {
            DriverImpl driverInfo = null;
            if (o instanceof DriverElement) {
                DriverElement dt = (DriverElement)o;
                driverInfo = this.createDriverImpl(dt, defaults, result);
                if (!driverInfo.hasParam("japex.driverClass")) {
                    driverInfo.setParam("japex.driverClass", dt.getName());
                }
                result.add(driverInfo);
                continue;
            }
            DriverGroupElement driverGroup = (DriverGroupElement)o;
            ParamsImpl groupScope = new ParamsImpl(defaults);
            for (ParamElement pt : this.createParamList(driverGroup.getParamOrParamGroup())) {
                String name = pt.getName();
                String value = pt.getValue();
                String oldValue = groupScope.getParam(name);
                groupScope.setParam(name, name.equals("japex.classPath") && oldValue != null ? oldValue + PATH_SEPARATOR + value : value);
            }
            result.addAll(this.createDriverList(driverGroup.getDriverOrDriverGroup(), groupScope));
        }
        return result;
    }

    private DriverImpl createDriverImpl(DriverElement dt, ParamsImpl inScope, List<DriverImpl> driverList) {
        DriverImpl driverInfo = null;
        String baseDriver = dt.getExtends();
        if (baseDriver != null) {
            boolean baseDriverFound = false;
            for (DriverImpl base : driverList) {
                if (!base.getName().equals(baseDriver)) continue;
                driverInfo = (DriverImpl)base.clone();
                driverInfo.setNormal(dt.isNormal());
                driverInfo.setBaseName(driverInfo.getName());
                driverInfo.setName(dt.getName());
                if (!this._baseDriversUsed.contains(base)) {
                    this._baseDriversUsed.add(base);
                }
                for (String name : inScope.nameSet()) {
                    if (driverInfo.hasParam(name)) continue;
                    driverInfo.setParam(name, inScope.getParam(name));
                }
                baseDriverFound = true;
                break;
            }
            if (!baseDriverFound) {
                throw new RuntimeException("Base driver '" + baseDriver + "' used to extend '" + dt.getName() + "' not found");
            }
        } else {
            driverInfo = new DriverImpl(dt.getName(), dt.isNormal(), inScope);
        }
        driverInfo.setDescription(this.marshalDescription(dt.getDescription()));
        for (ParamElement pt : this.createParamList(dt.getParamOrParamGroup())) {
            String name = pt.getName();
            String value = pt.getValue();
            String oldValue = driverInfo.getParam(name);
            driverInfo.setParam(name, name.equals("japex.classPath") && oldValue != null ? oldValue + PATH_SEPARATOR + value : value);
        }
        return driverInfo;
    }

    private List<ParamElement> createParamList(List<Object> paramOrParamGroup) {
        ArrayList<ParamElement> result = new ArrayList<ParamElement>();
        for (Object o : paramOrParamGroup) {
            if (o instanceof ParamElement) {
                result.add((ParamElement)o);
                continue;
            }
            ParamGroupElement p = (ParamGroupElement)o;
            result.addAll(this.createParamList(p.getParamOrParamGroup()));
        }
        return result;
    }

    private boolean checkResultAxis(String paramName) {
        if (this.hasParam(paramName)) {
            String value = this.getParam(paramName);
            return value.equalsIgnoreCase("normal") || value.equalsIgnoreCase("logarithmic");
        }
        this.setParam(paramName, "normal");
        return true;
    }

    private void readAndSetSystemProperties() {
        Properties sysProps = System.getProperties();
        for (String string : sysProps.keySet()) {
            String value;
            if (!string.startsWith("japex.") || (value = sysProps.getProperty(string)).length() <= 0) continue;
            this.setParam(string, value);
        }
    }

    public TestSuiteElement getTestSuiteElement() {
        return this._testSuiteElement;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public List<DriverImpl> getDriverInfoList() {
        return this._driverList;
    }

    public void serialize(StringBuffer report) {
        report.append("<testSuiteReport name=\"" + this._name + "\" xmlns=\"http://www.sun.com/japex/testSuiteReport\">\n");
        if (this._description != null) {
            report.append(this._description);
        }
        this.serialize(report, 2);
        HashSet<String> paramsClosure = new HashSet<String>();
        for (DriverImpl di : this._driverList) {
            for (String name : di.nameSet()) {
                paramsClosure.add(name);
            }
        }
        for (DriverImpl di : this._driverList) {
            for (String name : paramsClosure) {
                if (di.hasLocalParam(name)) continue;
                di.setParam(name, "n/a");
            }
        }
        for (DriverImpl di : this._driverList) {
            di.serialize(report, 2);
        }
        report.append("</testSuiteReport>\n");
    }

    private String marshalDescription(DescriptionElement desc) {
        if (desc != null) {
            try {
                StringWriter writer = new StringWriter();
                Marshaller m = ConfigFileLoader.context.createMarshaller();
                m.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                m.marshal((Object)desc, (Writer)writer);
                return writer.toString();
            }
            catch (JAXBException e) {
                System.err.println("Warning: Unable to serialize 'description' element - ignoring.");
            }
        }
        return null;
    }
}

