/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.Locale;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.XMLReader;

public class Util {
    static final int KB = 1024;
    static final String spaces = "                                        ";
    static DecimalFormat _decimalFormat;
    private static SAXParserFactory saxParserFactory;

    static String getSpaces(int length) {
        return spaces.substring(0, length);
    }

    public static byte[] streamToByteArray(InputStream is) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
        try {
            int c;
            while ((c = is.read()) != -1) {
                bos.write(c);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    public static ByteArrayInputStream streamToByteArrayInputStream(InputStream is) {
        return new ByteArrayInputStream(Util.streamToByteArray(is));
    }

    public static long parseDuration(String duration) {
        try {
            int length = duration.length();
            switch (length) {
                case 1: 
                case 2: {
                    return Integer.parseInt(duration.substring(0, length)) * 1000;
                }
                case 5: {
                    if (duration.charAt(2) != ':') break;
                    return Integer.parseInt(duration.substring(0, 2)) * 60 * 1000 + Integer.parseInt(duration.substring(3, 5)) * 1000;
                }
                case 8: {
                    if (duration.charAt(2) != ':' || duration.charAt(5) != ':') break;
                    return Integer.parseInt(duration.substring(0, 2)) * 60 * 60 * 1000 + Integer.parseInt(duration.substring(3, 5)) * 60 * 1000 + Integer.parseInt(duration.substring(6, 8)) * 1000;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new RuntimeException("Duration '" + duration + "' does not conform to pattern '((HH:)?MM:)?S?S'");
    }

    public static long currentTimeNanos() {
        return System.nanoTime();
    }

    public static double currentTimeMillis() {
        return Util.nanosToMillis(System.nanoTime());
    }

    public static long millisToNanos(long millis) {
        return millis * 1000000L;
    }

    public static double nanosToMillis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    public static double arithmeticMean(double[] sample) {
        return Util.arithmeticMean(sample, 0);
    }

    public static double arithmeticMean(double[] sample, int start) {
        double mean = 0.0;
        for (int i = start; i < sample.length; ++i) {
            mean += sample[i];
        }
        return mean / (double)(sample.length - start);
    }

    public static double standardDev(double[] sample) {
        return Util.standardDev(sample, 0);
    }

    public static double standardDev(double[] sample, int start) {
        double mean = Util.arithmeticMean(sample, start);
        double variance = 0.0;
        for (int i = start; i < sample.length; ++i) {
            variance += (sample[i] - mean) * (sample[i] - mean);
        }
        return Math.sqrt(variance /= (double)(sample.length - start));
    }

    public static String formatDouble(double value) {
        return Double.isNaN(value) ? "NaN" : _decimalFormat.format(value);
    }

    public static String getManifestAsString(URLClassLoader cl, String jarBaseName) {
        try {
            Enumeration<URL> e = cl.findResources("META-INF/MANIFEST.MF");
            while (e.hasMoreElements()) {
                int c;
                URL url = e.nextElement();
                String urlString = url.toString();
                if (urlString.indexOf(jarBaseName) <= 0) continue;
                StringBuilder sb = new StringBuilder();
                InputStream is = url.openStream();
                while ((c = is.read()) != -1) {
                    char ch = (char)c;
                    sb.append(Character.isWhitespace(ch) ? (char)' ' : (char)ch);
                }
                return sb.toString();
            }
            return "";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int[] calculateGroupSizes(int nOfTests, int maxGroupSize) {
        if (nOfTests <= maxGroupSize) {
            return new int[]{nOfTests};
        }
        int[] result = new int[nOfTests / maxGroupSize + (nOfTests % maxGroupSize > 0 ? 1 : 0)];
        int m1 = (nOfTests - maxGroupSize) / maxGroupSize;
        for (int i = 0; i < m1; ++i) {
            result[i] = maxGroupSize;
        }
        int m2 = nOfTests - m1 * maxGroupSize;
        if (m2 <= maxGroupSize) {
            result[result.length - 1] = m2;
        } else {
            result[result.length - 2] = (int)Math.ceil((double)m2 / 2.0);
            result[result.length - 1] = m2 - result[result.length - 2];
        }
        return result;
    }

    public static String getFilename(String testcase) {
        StringBuffer filename = new StringBuffer();
        for (int i = 0; i < testcase.length(); ++i) {
            char achar = testcase.charAt(i);
            if (achar == '.') {
                char nchar = testcase.charAt(i + 1);
                filename.append("_");
                if (nchar != '/' && nchar != '\\') continue;
                ++i;
                continue;
            }
            if (achar == '/' || achar == '\\' || achar == ' ') {
                filename.append("_");
                continue;
            }
            filename.append(achar);
        }
        return filename.toString();
    }

    public static XMLReader getXIncludeXMLReader() {
        try {
            return saxParserFactory.newSAXParser().getXMLReader();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                Util.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            Util.copyFile(srcDir, dstDir);
        }
    }

    public static void copyResource(String basename, String outputDir, String fileSep) {
        try {
            URL css = Util.class.getResource("/resources/" + basename);
            if (css != null) {
                int c;
                InputStream is = css.openStream();
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(outputDir + fileSep + basename)));
                while ((c = is.read()) != -1) {
                    ((OutputStream)os).write(c);
                }
                is.close();
                ((OutputStream)os).close();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        dfs.setDecimalSeparator('.');
        _decimalFormat = new DecimalFormat("0.000", dfs);
        _decimalFormat.setGroupingSize(127);
        saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            saxParserFactory.setXIncludeAware(true);
        }
        catch (UnsupportedOperationException e) {
            System.err.print("Warning: Available SAX parser factory does not support XInclude");
        }
    }
}

