/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.ant;

import com.sun.japex.Japex;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class JapexTask
extends MatchingTask {
    protected Path compileClasspath = null;
    private boolean html = true;
    private String config = "config.xml";
    private boolean fork = false;

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public boolean getHtml() {
        return this.html;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public boolean getFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public void execute() throws BuildException {
        if (this.fork) {
            this.run(this.setupForkCommand().getCommandline());
        } else {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Japex japex = new Japex();
            japex.setHtml(this.html);
            japex.run(this.config);
        }
    }

    private int run(String[] command) throws BuildException {
        for (int i = 0; i < command.length; ++i) {
            System.out.println("#### command[" + i + "] =" + command[i]);
        }
        Execute exe = null;
        exe = new Execute();
        exe.setAntRun(this.project);
        exe.setCommandline(command);
        try {
            int rc = exe.execute();
            if (exe.killedProcess()) {
                this.log("Timeout: killed the sub-process", 1);
            }
            return rc;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }

    private Commandline setupForkCommand() {
        CommandlineJava forkCmd = new CommandlineJava();
        Path classpath = this.getClasspath();
        forkCmd.createClasspath(this.getProject()).append(classpath);
        forkCmd.setClassname("com.sun.japex.Japex");
        if (!this.html) {
            forkCmd.createArgument().setValue("-nohtml");
        }
        forkCmd.createArgument().setValue(this.config);
        Commandline cmd = new Commandline();
        cmd.createArgument(true).setLine(forkCmd.toString());
        return cmd;
    }
}

