/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.report;

import com.sun.japex.report.MeanMode;
import com.sun.japex.report.TestSuiteReport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartGenerator {
    SimpleDateFormat _dateFormatter = new SimpleDateFormat("MM-dd");
    SimpleDateFormat _dateTimeFormatter = new SimpleDateFormat("MM-dd HH:mm");
    List<? extends TestSuiteReport> _reports;

    public ChartGenerator(List<? extends TestSuiteReport> reports) {
        this._reports = reports;
        Collections.sort(this._reports);
    }

    public JFreeChart createTrendChart(MeanMode mean) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int size = this._reports.size();
        for (int i = 0; i < size; ++i) {
            TestSuiteReport report = this._reports.get(i);
            SimpleDateFormat formatter = this._dateFormatter;
            if (i > 0 && ChartGenerator.onSameDate(report, this._reports.get(i - 1))) {
                formatter = this._dateTimeFormatter;
            }
            if (i + 1 < size && ChartGenerator.onSameDate(report, this._reports.get(i + 1))) {
                formatter = this._dateTimeFormatter;
            }
            List<TestSuiteReport.Driver> drivers = report.getDrivers();
            for (TestSuiteReport.Driver driver : drivers) {
                double value = driver.getResult(mean);
                if (Double.isNaN(value)) continue;
                dataset.addValue(driver.getResult(MeanMode.ARITHMETIC), (Comparable)((Object)driver.getName()), (Comparable)((Object)formatter.format(report.getDate().getTime())));
            }
        }
        JFreeChart chart = ChartFactory.createLineChart((String)mean.toString(), (String)"", (String)"", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ChartGenerator.configureLineChart(chart);
        chart.setAntiAlias(true);
        return chart;
    }

    public JFreeChart createTrendChart(String testCaseName) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int size = this._reports.size();
        for (int i = 0; i < size; ++i) {
            TestSuiteReport report = this._reports.get(i);
            SimpleDateFormat formatter = this._dateFormatter;
            if (i > 0 && ChartGenerator.onSameDate(report, this._reports.get(i - 1))) {
                formatter = this._dateTimeFormatter;
            }
            if (i + 1 < size && ChartGenerator.onSameDate(report, this._reports.get(i + 1))) {
                formatter = this._dateTimeFormatter;
            }
            List<TestSuiteReport.Driver> drivers = report.getDrivers();
            for (TestSuiteReport.Driver driver : drivers) {
                TestSuiteReport.TestCase testCase = driver.getTestCase(testCaseName);
                if (testCase == null) continue;
                dataset.addValue(testCase.getResult(), (Comparable)((Object)driver.getName()), (Comparable)((Object)formatter.format(report.getDate().getTime())));
            }
        }
        JFreeChart chart = ChartFactory.createLineChart((String)testCaseName, (String)"", (String)"", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ChartGenerator.configureLineChart(chart);
        chart.setAntiAlias(true);
        return chart;
    }

    protected static void configureLineChart(JFreeChart chart) {
        CategoryPlot plot = chart.getCategoryPlot();
        DefaultDrawingSupplier supplier = new DefaultDrawingSupplier(DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, new Shape[]{new Polygon(new int[]{3, 0, -3, 0}, new int[]{0, 3, 0, -3}, 4)});
        plot.setDomainGridlinePaint((Paint)Color.black);
        plot.setRangeGridlinePaint((Paint)Color.black);
        plot.setDrawingSupplier((DrawingSupplier)supplier);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setShapesVisible(true);
        renderer.setStroke((Stroke)new BasicStroke(2.0f));
        CategoryAxis axis = plot.getDomainAxis();
        axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
    }

    protected static boolean onSameDate(TestSuiteReport r1, TestSuiteReport r2) {
        Calendar cc1 = (Calendar)r1.getDate().clone();
        cc1.set(11, 0);
        cc1.set(12, 0);
        cc1.set(13, 0);
        Calendar cc2 = (Calendar)r2.getDate().clone();
        cc2.set(11, 0);
        cc2.set(12, 0);
        cc2.set(13, 0);
        return cc1.equals(cc2);
    }
}

