/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.report;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class DateComparator
implements Comparator {
    public static final int ORDER_DESC = 1;
    public static final int ORDER_ASC = 2;
    private int order;

    public DateComparator() {
        this.order = 1;
    }

    public DateComparator(int order) {
        this.order = order;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof File && o2 instanceof File) {
            long lm2;
            long lm1 = this.convertDate((File)o1);
            if (lm1 < (lm2 = this.convertDate((File)o2))) {
                return this.order == 1 ? -1 : 1;
            }
            if (lm1 > lm2) {
                return this.order == 1 ? 1 : -1;
            }
            return 0;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo((Comparable)o2);
        }
        return -1;
    }

    public boolean equals(Object obj) {
        return obj instanceof DateComparator;
    }

    long convertDate(File file) {
        Calendar d0;
        long time = 0L;
        if (file != null && (d0 = this.parseReportDirectory(file)) != null) {
            time = d0.getTimeInMillis();
        }
        return time;
    }

    Calendar parseReportDirectory(File file) {
        Calendar result = null;
        if (file != null) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy_MM_dd_HH_mm", Locale.ENGLISH);
                Date date = formatter.parse(file.getName());
                result = Calendar.getInstance();
                result.setTime(date);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

