/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.report;

import com.sun.japex.report.TrendReport;
import com.sun.japex.report.TrendReportParams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class IndexPage {
    static final String REPORT_TITLE = "<!--{title}-->";
    static final String REPORT_NEWINDEX = "<!--{new index}-->";
    static final String REPORT_NEWROW = "<!--{new row}-->";
    TrendReportParams _params;
    String _chartName;
    StringBuffer _content;

    public IndexPage(TrendReportParams params, String chartName) {
        this._params = params;
        this._chartName = chartName;
    }

    public IndexPage(TrendReportParams params, boolean openfile) {
        this._params = params;
        if (openfile) {
            try {
                String filename = this._params.outputPath() + TrendReport.FILE_SEP + "index.html";
                File file = new File(filename);
                this._content = new StringBuffer();
                this._content.append(this.getTemplate());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void updateContent(String chartName) {
        int start = 0;
        int end = 0;
        StringBuffer newindex = new StringBuffer();
        newindex.append("<option value=\"#" + this._params.title() + "\">" + this._params.title() + "</option>");
        newindex.append(REPORT_NEWINDEX);
        StringBuffer newrow = new StringBuffer();
        newrow.append("<table id=\"" + this._params.title() + "\" ");
        newrow.append("width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tbody>");
        newrow.append("<tr valign=\"top\"><td width=\"90%\"><font color=\"005A9C\" size=\"5\">");
        newrow.append("</font></td><td align=\"right\"><a href=\"#top\"><font size=\"3\">[Top]</font></a></td></tr>");
        newrow.append("</tbody></table>\n");
        newrow.append("<table width=\"100%\" border=\"0\">");
        newrow.append("<tr><td colspan=\"2\" align=\"center\"><img src=\"" + chartName + "\"></td></tr>");
        newrow.append("</table><br>");
        newrow.append(REPORT_NEWROW);
        start = this._content.indexOf(REPORT_TITLE);
        if (start > 0) {
            end = start + REPORT_TITLE.length();
            this._content.replace(start, end, this._params.pageTitle());
        }
        start = this._content.indexOf(REPORT_NEWINDEX);
        end = start + REPORT_NEWINDEX.length();
        this._content.replace(start, end, newindex.toString());
        start = this._content.indexOf(REPORT_NEWROW);
        end = start + REPORT_NEWROW.length();
        this._content.replace(start, end, newrow.toString());
    }

    public void writeContent() {
        try {
            String filename = this._params.outputPath() + TrendReport.FILE_SEP + "index.html";
            File file = new File(filename);
            OutputStreamWriter osr = new OutputStreamWriter(new FileOutputStream(file));
            osr.write(this._content.toString());
            osr.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getTemplate() {
        StringBuffer template = new StringBuffer();
        template.append("<html>\n<link href=\"report.css\" type=\"text/css\" rel=\"stylesheet\"/>\n");
        template.append("<head><script>function jump(menu){window.location.hash=menu.choice.options[menu.choice.selectedIndex].value;}</script></head>");
        template.append("<body><table border=\"0\" cellpadding=\"2\"><tr><td valign=\"middle\" width=\"90\"><p><a href=\"https://japex.dev.java.net\"><img src=\"small_japex.gif\" align=\"middle\" border=\"0\"/></a></p></td><td valign=\"middle\"><h1>Japex Trend Report: <!--{title}--></h1></td></tr></table>");
        template.append("<h2>Global Parameters</h2>");
        template.append("<ul>\n<li>Report Path: " + this._params.reportPath() + "</li>\n");
        template.append("<li>Output Path: " + this._params.outputPath() + "</li>\n");
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy/HH:mm:ss z", Locale.ENGLISH);
        template.append("<li>Report Period: " + this._params.dateFrom().getTime() + " - " + this._params.dateTo().getTime() + "</li>\n");
        template.append("<li>Timestamp: " + df.format(new Date()));
        template.append("</li>\n</ul>\n");
        template.append("<h2>Results</h2>");
        template.append("<form action=\"dummy\" method=\"post\"><select name=\"choice\" size=\"1\" onChange=\"jump(this.form)\">");
        template.append(REPORT_NEWINDEX);
        template.append("</select></form><br>");
        template.append(REPORT_NEWROW);
        template.append("<br><br><small><hr/><font size=\"-2\">Generated using <a href=\"https://japex.dev.java.net\">Japex Trend Report</a> version 1.0.1</font></small>");
        template.append("</body>\n</html>");
        return template.toString();
    }
}

