/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.report;

import com.sun.japex.Util;
import com.sun.japex.report.ChartGenerator;
import com.sun.japex.report.IndexPage;
import com.sun.japex.report.MeanMode;
import com.sun.japex.report.TestSuiteReport;
import com.sun.japex.report.TrendReport;
import com.sun.japex.report.TrendReportParams;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportGenerator
extends ChartGenerator {
    static final int CHART_WIDTH = 750;
    static final int CHART_HEIGHT = 450;
    IndexPage _indexPage;
    TrendReportParams _params;
    List<String> _testCaseNames = new ArrayList<String>();

    public ReportGenerator(TrendReportParams params, List<? extends TestSuiteReport> reports) {
        super(reports);
        this._params = params;
        this._indexPage = new IndexPage(this._params, true);
        for (TestSuiteReport testSuiteReport : reports) {
            for (TestSuiteReport.Driver driver : testSuiteReport.getDrivers()) {
                for (TestSuiteReport.TestCase test : driver.getTestCases()) {
                    String testName = test.getName();
                    if (this._testCaseNames.contains(testName)) continue;
                    this._testCaseNames.add(testName);
                }
            }
        }
    }

    public void createReport() {
        this.singleMeansChart();
        this.oneTestcaseChart();
    }

    private void singleMeansChart() {
        JFreeChart chart = this.createTrendChart(MeanMode.ARITHMETIC);
        this._params.setTitle("Arithmetic Means");
        this.saveChart(chart, "ArithmeticMeans.jpg", 750, 450);
        this._indexPage.updateContent("ArithmeticMeans.jpg");
        chart = this.createTrendChart(MeanMode.GEOMETRIC);
        this.saveChart(chart, "GeometricMeans.jpg", 750, 450);
        this._params.setTitle("Geometric Means");
        this._indexPage.updateContent("GeometricMeans.jpg");
        chart = this.createTrendChart(MeanMode.HARMONIC);
        this.saveChart(chart, "HarmonicMeans.jpg", 750, 450);
        this._params.setTitle("Harmonic Means");
        this._indexPage.updateContent("HarmonicMeans.jpg");
        this._indexPage.writeContent();
    }

    private void oneTestcaseChart() {
        for (String testCaseName : this._testCaseNames) {
            JFreeChart chart = this.createTrendChart(testCaseName);
            String chartName = Util.getFilename(testCaseName) + ".jpg";
            this._params.setTitle(testCaseName);
            this._indexPage.updateContent(chartName);
            this.saveChart(chart, chartName, 750, 450);
        }
        this._indexPage.writeContent();
    }

    private void saveChart(JFreeChart chart, String fileName, int width, int height) {
        try {
            File file = new File(this._params.outputPath());
            if (!file.exists()) {
                file.mkdirs();
            }
            ChartUtilities.saveChartAsJPEG((File)new File(this._params.outputPath() + TrendReport.FILE_SEP + fileName), (JFreeChart)chart, (int)width, (int)height);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

