/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.report;

import com.sun.japex.report.MeanMode;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuiteReport
implements Comparable<TestSuiteReport> {
    static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    static final String TESTSUITE_REPORT_URI = "http://www.sun.com/japex/testSuiteReport";
    Document _rep;
    ArrayList<Driver> _drivers = new ArrayList();
    HashMap<String, String> _params = new HashMap();
    Calendar _date = Calendar.getInstance();

    public TestSuiteReport(File src) throws SAXException, IOException {
        if (!src.exists()) {
            throw new IllegalArgumentException("File '" + src + "' does not exist");
        }
        try {
            this._rep = dbf.newDocumentBuilder().parse(src);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        NodeList list = this._rep.getDocumentElement().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if (e.getLocalName().equals("driver") && e.hasAttribute("name")) {
                this._drivers.add(new Driver(e));
                continue;
            }
            this._params.put(e.getLocalName(), e.getFirstChild().getNodeValue());
        }
        SimpleDateFormat format = new SimpleDateFormat("dd MMM yyyy/HH:mm:ss z", Locale.ENGLISH);
        try {
            Date d = format.parse(this._params.get("dateTime"));
            this._date.setTime(d);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Calendar getDate() {
        return this._date;
    }

    @Override
    public int compareTo(TestSuiteReport other) {
        return this._date.compareTo(other._date);
    }

    public Map<String, String> getParameters() {
        return this._params;
    }

    public List<Driver> getDrivers() {
        return this._drivers;
    }

    public Driver getDriver(String name) {
        for (Driver driver : this._drivers) {
            if (!driver.getName().equals(name)) continue;
            return driver;
        }
        return null;
    }

    static double getElementValueAsDouble(Element parent, String uri, String localName) {
        try {
            return Double.parseDouble(parent.getElementsByTagNameNS(uri, localName).item(0).getFirstChild().getNodeValue());
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    static {
        dbf.setNamespaceAware(true);
    }

    public class TestCase {
        Element _rep;

        public TestCase(Element rep) {
            this._rep = rep;
        }

        public String getName() {
            return this._rep.getAttribute("name");
        }

        public double getResult() {
            return TestSuiteReport.getElementValueAsDouble(this._rep, TestSuiteReport.TESTSUITE_REPORT_URI, "resultValue");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Driver {
        Element _rep;
        HashMap<String, String> _params = new HashMap();
        ArrayList<TestCase> _testCases = new ArrayList();

        public Driver(Element rep) {
            this._rep = rep;
            NodeList list = this._rep.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (!(n instanceof Element)) continue;
                Element e = (Element)n;
                if (e.getLocalName().equals("testCase") && e.hasAttribute("name")) {
                    this._testCases.add(new TestCase(e));
                    continue;
                }
                this._params.put(e.getLocalName(), e.getFirstChild().getNodeValue());
            }
        }

        public Map<String, String> getParameters() {
            return this._params;
        }

        public String getName() {
            return this._rep.getAttribute("name");
        }

        public double getResult(MeanMode m) {
            switch (m) {
                case ARITHMETIC: {
                    return TestSuiteReport.getElementValueAsDouble(this._rep, TestSuiteReport.TESTSUITE_REPORT_URI, "resultAritMean");
                }
                case GEOMETRIC: {
                    return TestSuiteReport.getElementValueAsDouble(this._rep, TestSuiteReport.TESTSUITE_REPORT_URI, "resultGeomMean");
                }
                case HARMONIC: {
                    return TestSuiteReport.getElementValueAsDouble(this._rep, TestSuiteReport.TESTSUITE_REPORT_URI, "resultHarmMean");
                }
            }
            return Double.NaN;
        }

        public TestCase getTestCase(String name) {
            for (TestCase testCase : this._testCases) {
                if (!testCase.getName().equals(name)) continue;
                return testCase;
            }
            return null;
        }

        public List<TestCase> getTestCases() {
            return this._testCases;
        }
    }
}

