/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.report;

import com.sun.japex.report.ReportFilter;
import com.sun.japex.report.ReportGenerator;
import com.sun.japex.report.TestSuiteReport;
import com.sun.japex.report.TrendReportParams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class TrendReport {
    public static final String FILE_SEP = System.getProperty("file.separator");
    List<TestSuiteReport> _reports = new ArrayList<TestSuiteReport>();

    public static void main(String[] args) {
        TrendReportParams params = new TrendReportParams(args);
        new TrendReport().run(params);
        System.exit(0);
    }

    public void run(TrendReportParams params) {
        try {
            File cwd = new File(params.reportPath());
            ReportFilter filter = new ReportFilter(params.dateFrom(), params.dateTo());
            File[] reportDirs = cwd.listFiles(filter);
            if (reportDirs == null) {
                System.err.println("Error: No Japex reports found in '" + params.reportPath() + "' between '" + params.dateFrom().getTime() + "' and '" + params.dateTo().getTime() + "'");
                System.exit(1);
            }
            for (File dir : reportDirs) {
                File report = new File(dir.getAbsolutePath() + FILE_SEP + "report.xml");
                try {
                    this._reports.add(new TestSuiteReport(report));
                }
                catch (SAXException e) {
                    System.err.println("Warning: Skipping malformed test suite report '" + report.toString() + "'");
                }
                catch (IOException e) {
                    System.err.println("Warning: Skipping unreadable test suite report '" + report.toString() + "'");
                }
            }
            new ReportGenerator(params, this._reports).createReport();
            this.copyResource("report.css", params.outputPath());
            this.copyResource("small_japex.gif", params.outputPath());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void copyResource(String basename, String outputDir) {
        try {
            URL css = this.getClass().getResource("/resources/" + basename);
            if (css != null) {
                int c;
                InputStream is = css.openStream();
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(outputDir + FILE_SEP + basename)));
                while ((c = is.read()) != -1) {
                    ((OutputStream)os).write(c);
                }
                is.close();
                ((OutputStream)os).close();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

