/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.report;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TrendReportParams {
    String _pageTitle;
    String _reportPath;
    String _outputPath;
    Calendar _from;
    Calendar _to;
    String _title;
    DateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public TrendReportParams(String[] args) {
        if (args.length < 3 || args.length > 5) {
            this.displayUsageAndExit();
        }
        this._pageTitle = args[0];
        this._reportPath = args[1];
        this._outputPath = args[2];
        String date = null;
        String offset = null;
        switch (args.length) {
            case 3: {
                date = "today";
                offset = "-1Y";
                break;
            }
            case 4: {
                try {
                    date = args[3];
                    offset = "-1Y";
                    this._dateFormat.parse(date);
                }
                catch (ParseException e1) {
                    date = "today";
                    offset = args[3];
                }
                break;
            }
            case 5: {
                date = args[3];
                offset = args[4];
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.parseDates(date, offset);
    }

    void parseDates(String date, String offset) {
        try {
            Date date1 = date.equals("today") ? new Date() : this._dateFormat.parse(date);
            int n = Integer.parseInt(offset.substring(0, offset.length() - 1));
            char c = offset.toUpperCase().charAt(offset.length() - 1);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date1);
            switch (c) {
                case 'D': {
                    cal.add(5, n);
                    break;
                }
                case 'W': {
                    cal.add(3, n);
                    break;
                }
                case 'M': {
                    cal.add(2, n);
                    break;
                }
                case 'Y': {
                    cal.add(1, n);
                }
            }
            if (n > 0) {
                this._from = Calendar.getInstance();
                this._from.setTime(date1);
                this._to = cal;
            } else {
                this._from = cal;
                this._to = Calendar.getInstance();
                this._to.setTime(date1);
                this._to.add(5, 1);
            }
        }
        catch (ParseException e) {
            this.displayUsageAndExit();
        }
    }

    public String pageTitle() {
        return this._pageTitle;
    }

    public String reportPath() {
        return this._reportPath;
    }

    public String outputPath() {
        return this._outputPath;
    }

    public Calendar dateFrom() {
        return this._from;
    }

    public Calendar dateTo() {
        return this._to;
    }

    public String title() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    private void displayUsageAndExit() {
        System.err.println("Usage: trend-report title reportPath outputPath [date] [offset]\n  title: Title to be used for this report\n  reportPath: Directory containing timestamped Japex reports\n  outputPath: Directory where the trend report will be placed\n  date: Starting/ending date for this report in the format 'YYYY-MM-DD' (default today)\n  offset: Positive or negative offset from 'date' in the format '-?[0-9]+(D|W|M|Y)'\n    where D=days, W=weeks, M=months and Y=years (default -1Y)");
        System.exit(1);
    }
}

