/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.apps;

import com.qq.tars.common.util.StringUtils;
import com.qq.tars.protocol.annotation.Servant;
import com.qq.tars.protocol.util.TarsHelper;
import com.qq.tars.server.apps.BaseAppContext;
import com.qq.tars.server.common.XMLConfigElement;
import com.qq.tars.server.common.XMLConfigFile;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.server.config.ServantAdapterConfig;
import com.qq.tars.server.config.ServerConfig;
import com.qq.tars.server.core.AppContextListener;
import com.qq.tars.server.core.ServantAdapter;
import com.qq.tars.server.core.ServantHomeSkeleton;
import java.io.IOException;
import java.util.ArrayList;

public class XmlAppContext
extends BaseAppContext {
    @Override
    protected void loadServants() throws Exception {
        XMLConfigFile cfg = new XMLConfigFile();
        cfg.parse(this.getClass().getClassLoader().getResource("servants.xml").openStream());
        XMLConfigElement root = cfg.getRootElement();
        ArrayList<XMLConfigElement> elements = root.getChildList();
        this.loadInitParams(root.getChildListByName("context-param"));
        this.loadAppContextListeners(elements);
        this.loadAppServants(elements);
        this.loadDefaultFilter();
        this.loadAppFilters(elements);
    }

    private void loadInitParams(ArrayList<XMLConfigElement> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (XMLConfigElement e : list) {
            String name = this.getChildNodeValue(e, "param-name");
            String value = this.getChildNodeValue(e, "param-value");
            if (StringUtils.isEmpty(name)) continue;
            this.contextParams.put(name, value);
        }
    }

    private void loadAppContextListeners(ArrayList<XMLConfigElement> elements) {
        for (XMLConfigElement element : elements) {
            if (!"listener".equals(element.getName())) continue;
            String listenerClass = this.getChildNodeValue(element, "listener-class");
            try {
                AppContextListener listener = (AppContextListener)Class.forName(listenerClass).newInstance();
                this.listeners.add(listener);
            }
            catch (ClassNotFoundException e) {
                System.err.println("invalid listener config|ClassNotFoundException:" + listenerClass);
            }
            catch (ClassCastException e) {
                System.err.println("invalid listener config|It is NOT a ContextListener:" + listenerClass);
            }
            catch (Exception e) {
                System.err.println("create listener instance failed.");
            }
        }
    }

    private void loadAppFilters(ArrayList<XMLConfigElement> list) {
    }

    private void loadAppServants(ArrayList<XMLConfigElement> elements) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (XMLConfigElement element : elements) {
            if (!"servant".equals(element.getName())) continue;
            try {
                ServantHomeSkeleton skeleton = this.loadServant(element);
                this.skeletonMap.put(skeleton.name(), skeleton);
                this.appServantStarted(skeleton);
            }
            catch (Exception e) {
                System.err.println("init a service failed:context=[]");
            }
        }
    }

    private ServantHomeSkeleton loadServant(XMLConfigElement element) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        String servantName;
        String homeName = null;
        String homeApiName = null;
        String homeClassName = null;
        String processorClazzName = null;
        String codecClazzName = null;
        Class<?> homeApiClazz = null;
        Class<?> codecClazz = null;
        Class<?> processorClazz = null;
        Object homeClassImpl = null;
        ServantHomeSkeleton skeleton = null;
        int maxLoadLimit = -1;
        ServerConfig serverCfg = ConfigurationManager.getInstance().getServerConfig();
        homeName = element.getStringAttribute("name");
        if (StringUtils.isEmpty(homeName)) {
            throw new RuntimeException("servant name is null.");
        }
        homeName = String.format("%s.%s.%s", serverCfg.getApplication(), serverCfg.getServerName(), homeName);
        homeApiName = this.getChildNodeValue(element, "home-api");
        homeClassName = this.getChildNodeValue(element, "home-class");
        processorClazzName = this.getChildNodeValue(element, "home-processor-class");
        codecClazzName = this.getChildNodeValue(element, "home-codec-class");
        homeApiClazz = Class.forName(homeApiName);
        homeClassImpl = Class.forName(homeClassName).newInstance();
        codecClazz = StringUtils.isEmpty(codecClazzName) ? null : Class.forName(codecClazzName);
        Class<?> clazz = processorClazz = StringUtils.isEmpty(processorClazzName) ? null : Class.forName(processorClazzName);
        if (TarsHelper.isServant(homeApiClazz) && !StringUtils.isEmpty(servantName = homeApiClazz.getAnnotation(Servant.class).name()) && servantName.matches("^[\\w]+\\.[\\w]+\\.[\\w]+$")) {
            homeName = servantName;
        }
        ServantAdapterConfig servantAdapterConfig = serverCfg.getServantAdapterConfMap().get(homeName);
        ServantAdapter ServerAdapter = new ServantAdapter(servantAdapterConfig);
        skeleton = new ServantHomeSkeleton(homeName, homeClassImpl, homeApiClazz, codecClazz, processorClazz, maxLoadLimit);
        skeleton.setAppContext(this);
        ServerAdapter.bind(skeleton);
        this.servantAdapterMap.put(homeName, ServerAdapter);
        return skeleton;
    }

    private String getChildNodeValue(XMLConfigElement element, String nodeName) {
        if (element == null) {
            return null;
        }
        XMLConfigElement childElement = element.getChildByName(nodeName);
        if (childElement == null) {
            return null;
        }
        return StringUtils.trim(childElement.getContent());
    }
}

