/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.om;

import com.qq.tars.client.Communicator;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.server.config.ServantAdapterConfig;
import com.qq.tars.server.config.ServerConfig;
import com.qq.tars.support.log.LoggerFactory;
import com.qq.tars.support.stat.InvokeStatHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class ServerStatHelper {
    private static final Logger omLogger = LoggerFactory.getOmLogger();
    private static final ServerStatHelper instance = new ServerStatHelper();
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private volatile Communicator communicator;

    private ServerStatHelper() {
    }

    public static ServerStatHelper getInstance() {
        return instance;
    }

    public void init(Communicator communicator) {
        if (this.inited.compareAndSet(false, true)) {
            this.communicator = communicator;
        }
    }

    public void report() {
        try {
            ServerConfig serverConfig = ConfigurationManager.getInstance().getServerConfig();
            LinkedHashMap<String, ServantAdapterConfig> adapterMap = serverConfig.getServantAdapterConfMap();
            if (adapterMap == null || adapterMap.isEmpty()) {
                return;
            }
            for (Map.Entry<String, ServantAdapterConfig> adapterEntry : adapterMap.entrySet()) {
                if ("AdminObj".equals(adapterEntry.getKey())) continue;
                ServantAdapterConfig servantCfg = adapterEntry.getValue();
                this.communicator.getStatHelper().report(InvokeStatHelper.getInstance().getProxyStat(servantCfg.getServant()), false);
            }
        }
        catch (Exception e) {
            omLogger.error("ServerStatHelper|ReportThread error", (Throwable)e);
        }
    }
}

