/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.memory;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ChatMemoryService {
    public static final String DEFAULT = "default";
    private ChatMemory defaultChatMemory;
    private Map<Object, ChatMemory> chatMemories;
    private ChatMemoryProvider chatMemoryProvider;

    public ChatMemoryService(ChatMemoryProvider chatMemoryProvider) {
        this.chatMemories = new ConcurrentHashMap<Object, ChatMemory>();
        this.chatMemoryProvider = (ChatMemoryProvider)ValidationUtils.ensureNotNull((Object)chatMemoryProvider, (String)"chatMemoryProvider");
    }

    public ChatMemoryService(ChatMemory chatMemory) {
        this.defaultChatMemory = (ChatMemory)ValidationUtils.ensureNotNull((Object)chatMemory, (String)"chatMemory");
    }

    public ChatMemory getOrCreateChatMemory(Object memoryId) {
        if (memoryId == DEFAULT) {
            if (this.defaultChatMemory == null) {
                this.defaultChatMemory = this.chatMemoryProvider.get(DEFAULT);
            }
            return this.defaultChatMemory;
        }
        return this.chatMemories.computeIfAbsent(memoryId, this.chatMemoryProvider::get);
    }

    public ChatMemory getChatMemory(Object memoryId) {
        return memoryId == DEFAULT ? this.defaultChatMemory : this.chatMemories.get(memoryId);
    }

    public ChatMemory evictChatMemory(Object memoryId) {
        return this.chatMemories.remove(memoryId);
    }

    public void clearAll() {
        this.chatMemories.values().forEach(ChatMemory::clear);
        this.chatMemories.clear();
    }

    public Collection<Object> getChatMemoryIDs() {
        return this.chatMemories.keySet();
    }

    public Collection<ChatMemory> getChatMemories() {
        return this.chatMemories.values();
    }
}

