/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.output;

import dev.langchain4j.internal.Json;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElementHelper;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.output.OutputParser;
import dev.langchain4j.service.output.ParsingUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PojoOutputParser<T>
implements OutputParser<T> {
    private static final Pattern JSON_BLOCK_PATTERN = Pattern.compile("(?s)\\{.*\\}|\\[.*\\]");
    private final Class<T> type;

    PojoOutputParser(Class<T> type) {
        this.type = type;
    }

    @Override
    public T parse(String text) {
        if (Utils.isNullOrBlank((String)text)) {
            throw ParsingUtils.outputParsingException(text, this.type);
        }
        try {
            return (T)Json.fromJson((String)text, this.type);
        }
        catch (Exception ignored) {
            try {
                String jsonBlock = this.extractJsonBlock(text);
                return (T)Json.fromJson((String)jsonBlock, this.type);
            }
            catch (Exception innerException) {
                throw ParsingUtils.outputParsingException(text, this.type.getName(), innerException);
            }
        }
    }

    @Override
    public Optional<JsonSchema> jsonSchema() {
        JsonSchema jsonSchema = JsonSchema.builder().name(this.type.getSimpleName()).rootElement(JsonSchemaElementHelper.jsonObjectOrReferenceSchemaFrom(this.type, null, (boolean)false, new LinkedHashMap(), (boolean)true)).build();
        return Optional.of(jsonSchema);
    }

    @Override
    public String formatInstructions() {
        String jsonStructure = PojoOutputParser.jsonStructure(this.type, new HashSet());
        this.validateJsonStructure(jsonStructure, this.type);
        return "\nYou must answer strictly in the following JSON format: " + jsonStructure;
    }

    private static String jsonStructure(Class<?> type, Set<Class<?>> visited) {
        StringBuilder jsonSchema = new StringBuilder();
        jsonSchema.append("{\n");
        for (Field field : type.getDeclaredFields()) {
            String name = field.getName();
            if (name.equals("__$hits$__") || Modifier.isStatic(field.getModifiers())) continue;
            jsonSchema.append(String.format("\"%s\": (%s),\n", name, PojoOutputParser.descriptionFor(field, visited)));
        }
        int trailingCommaIndex = jsonSchema.lastIndexOf(",");
        if (trailingCommaIndex > 0) {
            jsonSchema.delete(trailingCommaIndex, trailingCommaIndex + 1);
        }
        jsonSchema.append("}");
        return jsonSchema.toString();
    }

    private static String descriptionFor(Field field, Set<Class<?>> visited) {
        Description fieldDescription = field.getAnnotation(Description.class);
        if (fieldDescription == null) {
            return "type: " + PojoOutputParser.typeOf(field, visited);
        }
        return String.join((CharSequence)" ", fieldDescription.value()) + "; type: " + PojoOutputParser.typeOf(field, visited);
    }

    private static String typeOf(Field field, Set<Class<?>> visited) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (parameterizedType.getRawType().equals(List.class) || parameterizedType.getRawType().equals(Set.class)) {
                return String.format("array of %s", PojoOutputParser.simpleNameOrJsonStructure((Class)typeArguments[0], visited));
            }
        } else {
            if (field.getType().isArray()) {
                return String.format("array of %s", PojoOutputParser.simpleNameOrJsonStructure(field.getType().getComponentType(), visited));
            }
            if (((Class)type).isEnum()) {
                return "enum, must be one of " + Arrays.toString(((Class)type).getEnumConstants());
            }
        }
        return PojoOutputParser.simpleNameOrJsonStructure(field.getType(), visited);
    }

    private static String simpleNameOrJsonStructure(Class<?> structured, Set<Class<?>> visited) {
        String simpleTypeName = PojoOutputParser.simpleTypeName(structured);
        if (structured.getPackage() == null || structured.getPackage().getName().startsWith("java.") || visited.contains(structured)) {
            return simpleTypeName;
        }
        visited.add(structured);
        return simpleTypeName + ": " + PojoOutputParser.jsonStructure(structured, visited);
    }

    private static String simpleTypeName(Type type) {
        return switch (type.getTypeName()) {
            case "java.lang.String" -> "string";
            case "java.lang.Integer", "int" -> "integer";
            case "java.lang.Boolean", "boolean" -> "boolean";
            case "java.lang.Float", "float" -> "float";
            case "java.lang.Double", "double" -> "double";
            case "java.util.Date", "java.time.LocalDate" -> "date string (2023-12-31)";
            case "java.time.LocalTime" -> "time string (23:59:59)";
            case "java.time.LocalDateTime" -> "date-time string (2023-12-31T23:59:59)";
            default -> type.getTypeName();
        };
    }

    private String extractJsonBlock(String text) {
        Matcher matcher = JSON_BLOCK_PATTERN.matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        return text;
    }

    private void validateJsonStructure(String jsonStructure, Type returnType) {
        if (jsonStructure.replaceAll("\\s", "").equals("{}")) {
            if (returnType.toString().contains("reactor.core.publisher.Flux")) {
                throw IllegalConfigurationException.illegalConfiguration("Please import langchain4j-reactor module if you wish to use Flux<String> as a method return type");
            }
            throw IllegalConfigurationException.illegalConfiguration("Illegal method return type: " + String.valueOf(returnType));
        }
    }
}

